/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dtd.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMAny;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMBinOp;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMLeaf;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMStateSet;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMUniOp;
import com.sun.org.apache.xerces.internal.impl.dtd.models.ContentModelValidator;
import com.sun.org.apache.xerces.internal.xni.QName;
import java.util.Hashtable;

public class DFAContentModel
implements ContentModelValidator {
    private static String fEpsilonString = "<<CMNODE_EPSILON>>";
    private static String fEOCString = "<<CMNODE_EOC>>";
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fMixed;
    private int fEOCPos = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private QName fQName = new QName();

    public DFAContentModel(CMNode cMNode, int n2, boolean bl2) {
        this.fLeafCount = n2;
        this.fMixed = bl2;
        this.buildDFA(cMNode);
    }

    public int validate(QName[] qNameArray, int n2, int n3) {
        if (n3 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string;
            int n5;
            int n6;
            QName qName = qNameArray[n2 + i2];
            if (this.fMixed && qName.localpart == null) continue;
            for (n6 = 0; n6 < this.fElemMapSize && !((n5 = this.fElemMapType[n6] & 0xF) == 0 ? this.fElemMap[n6].rawname == qName.rawname : (n5 == 6 ? (string = this.fElemMap[n6].uri) == null || string == qName.uri : (n5 == 8 ? qName.uri == null : n5 == 7 && this.fElemMap[n6].uri != qName.uri))); ++n6) {
            }
            if (n6 == this.fElemMapSize) {
                return i2;
            }
            if ((n4 = this.fTransTable[n4][n6]) != -1) continue;
            return i2;
        }
        if (!this.fFinalStateFlags[n4]) {
            return n3;
        }
        return -1;
    }

    private void buildDFA(CMNode cMNode) {
        Object object;
        int n2;
        int n3;
        this.fQName.setValues(null, fEOCString, fEOCString, null);
        CMLeaf cMLeaf = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (n3 = 0; n3 < this.fLeafCount; ++n3) {
            this.fFollowList[n3] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        for (n3 = 0; n3 < this.fLeafCount; ++n3) {
            this.fElemMap[n3] = new QName();
            QName qName = this.fLeafList[n3].getElement();
            for (n2 = 0; n2 < this.fElemMapSize && this.fElemMap[n2].rawname != qName.rawname; ++n2) {
            }
            if (n2 != this.fElemMapSize) continue;
            this.fElemMap[this.fElemMapSize].setValues(qName);
            this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n3];
            ++this.fElemMapSize;
        }
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        int n4 = 0;
        for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
            for (int i2 = 0; i2 < this.fLeafCount; ++i2) {
                object = this.fLeafList[i2].getElement();
                QName qName = this.fElemMap[n2];
                if (((QName)object).rawname != qName.rawname) continue;
                nArray[n4++] = i2;
            }
            nArray[n4++] = -1;
        }
        n2 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n2];
        this.fFinalStateFlags = new boolean[n2];
        this.fTransTable = new int[n2][];
        object = this.fHeadNode.firstPos();
        int n5 = 0;
        int n6 = 0;
        this.fTransTable[n6] = this.makeDefStateList();
        cMStateSetArray[n6] = object;
        ++n6;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n5 < n6) {
            object = cMStateSetArray[n5];
            int[] nArray2 = this.fTransTable[n5];
            this.fFinalStateFlags[n5] = ((CMStateSet)object).getBit(this.fEOCPos);
            ++n5;
            CMStateSet cMStateSet = null;
            int n7 = 0;
            for (int i3 = 0; i3 < this.fElemMapSize; ++i3) {
                int n8;
                if (cMStateSet == null) {
                    cMStateSet = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet.zeroBits();
                }
                int n9 = nArray[n7++];
                while (n9 != -1) {
                    if (((CMStateSet)object).getBit(n9)) {
                        cMStateSet.union(this.fFollowList[n9]);
                    }
                    n9 = nArray[n7++];
                }
                if (cMStateSet.isEmpty()) continue;
                Integer n10 = (Integer)hashtable.get(cMStateSet);
                int n11 = n8 = n10 == null ? n6 : n10;
                if (n8 == n6) {
                    cMStateSetArray[n6] = cMStateSet;
                    this.fTransTable[n6] = this.makeDefStateList();
                    hashtable.put(cMStateSet, new Integer(n6));
                    ++n6;
                    cMStateSet = null;
                }
                nArray2[i3] = n8;
                if (n6 != n2) continue;
                int n12 = (int)((double)n2 * 1.5);
                CMStateSet[] cMStateSetArray2 = new CMStateSet[n12];
                boolean[] blArray = new boolean[n12];
                int[][] nArrayArray = new int[n12][];
                for (int i4 = 0; i4 < n2; ++i4) {
                    cMStateSetArray2[i4] = cMStateSetArray[i4];
                    blArray[i4] = this.fFinalStateFlags[i4];
                    nArrayArray[i4] = this.fTransTable[i4];
                }
                n2 = n12;
                cMStateSetArray = cMStateSetArray2;
                this.fFinalStateFlags = blArray;
                this.fTransTable = nArrayArray;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            for (int i2 = 0; i2 < this.fLeafCount; ++i2) {
                if (!cMStateSet.getBit(i2)) continue;
                this.fFollowList[i2].union(cMStateSet2);
            }
        } else if (cMNode.type() == 2 || cMNode.type() == 3) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            for (int i3 = 0; i3 < this.fLeafCount; ++i3) {
                if (!cMStateSet3.getBit(i3)) continue;
                this.fFollowList[i3].union(cMStateSet);
            }
        } else if (cMNode.type() == 1) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("   ");
        }
        n3 = cMNode.type();
        if (n3 == 4 || n3 == 5) {
            if (n3 == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMBinOp)cMNode).getLeft(), n2 + 1);
            this.dumpTree(((CMBinOp)cMNode).getRight(), n2 + 1);
        } else if (cMNode.type() == 2) {
            System.out.print("Rep Node ");
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMUniOp)cMNode).getChild(), n2 + 1);
        } else if (cMNode.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + ((CMLeaf)cMNode).getElement() + "(elemIndex=" + ((CMLeaf)cMNode).getElement() + ") ");
            if (cMNode.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            nArray[i2] = -1;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n2) {
        cMNode.setMaxStates(this.fLeafCount);
        if ((cMNode.type() & 0xF) == 6 || (cMNode.type() & 0xF) == 8 || (cMNode.type() & 0xF) == 7) {
            QName qName = new QName(null, null, null, ((CMAny)cMNode).getURI());
            this.fLeafList[n2] = new CMLeaf(qName, ((CMAny)cMNode).getPosition());
            this.fLeafListType[n2] = cMNode.type();
            ++n2;
        } else if (cMNode.type() == 4 || cMNode.type() == 5) {
            n2 = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n2);
            n2 = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n2);
        } else if (cMNode.type() == 2 || cMNode.type() == 3 || cMNode.type() == 1) {
            n2 = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n2);
        } else if (cMNode.type() == 0) {
            QName qName = ((CMLeaf)cMNode).getElement();
            if (qName.localpart != fEpsilonString) {
                this.fLeafList[n2] = (CMLeaf)cMNode;
                this.fLeafListType[n2] = 0;
                ++n2;
            }
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM: type=" + cMNode.type());
        }
        return n2;
    }

    static {
        fEpsilonString = fEpsilonString.intern();
        fEOCString = fEOCString.intern();
    }
}

