/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPushInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.generic.Visitor;

public class ICONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private int value;

    ICONST() {
    }

    public ICONST(int n2) {
        super((short)3, (short)1);
        if (n2 < -1 || n2 > 5) {
            throw new ClassGenException("ICONST can be used only for value between -1 and 5: " + n2);
        }
        this.opcode = (short)(3 + n2);
        this.value = n2;
    }

    public Number getValue() {
        return new Integer(this.value);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.INT;
    }

    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitICONST(this);
    }
}

