/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class Fixups
extends AbstractCollection
implements Constants {
    byte[] bytes;
    int head;
    int tail;
    int size;
    ConstantPool.Entry[] entries;
    int[] bigDescs;
    private static final int MINBIGSIZE = 1;
    private static int[] noBigDescs = new int[]{1};
    static final int LOC_SHIFT = 1;
    static final int FMT_MASK = 1;
    static final byte UNUSED_BYTE = 0;
    static final byte OVERFLOW_BYTE = -1;
    static final int BIGSIZE = 0;
    public static final int U2_FORMAT = 0;
    public static final int U1_FORMAT = 1;
    private static final int SPECIAL_LOC = 0;
    private static final int SPECIAL_FMT = 0;

    Fixups(byte[] byArray) {
        this.bytes = byArray;
        this.entries = new ConstantPool.Entry[3];
        this.bigDescs = noBigDescs;
    }

    Fixups() {
        this((byte[])null);
    }

    Fixups(byte[] byArray, Collection collection) {
        this(byArray);
        this.addAll(collection);
    }

    Fixups(Collection collection) {
        this((byte[])null);
        this.addAll(collection);
    }

    public int size() {
        return this.size;
    }

    public void trimToSize() {
        int n2;
        if (this.size != this.entries.length) {
            ConstantPool.Entry[] entryArray = this.entries;
            this.entries = new ConstantPool.Entry[this.size];
            System.arraycopy(entryArray, 0, this.entries, 0, this.size);
        }
        if ((n2 = this.bigDescs[0]) == 1) {
            this.bigDescs = noBigDescs;
        } else if (n2 != this.bigDescs.length) {
            int[] nArray = this.bigDescs;
            this.bigDescs = new int[n2];
            System.arraycopy(nArray, 0, this.bigDescs, 0, n2);
        }
    }

    public void visitRefs(Collection collection) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            collection.add(this.entries[i2]);
        }
    }

    public void clear() {
        if (this.bytes != null) {
            for (Fixup fixup : this) {
                this.storeIndex(fixup.location(), fixup.format(), 0);
            }
        }
        this.size = 0;
        if (this.bigDescs != noBigDescs) {
            this.bigDescs[0] = 1;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        if (this.bytes == byArray) {
            return;
        }
        ArrayList arrayList = null;
        assert ((arrayList = new ArrayList(this)) != null);
        if (this.bytes == null || byArray == null) {
            ArrayList arrayList2 = new ArrayList(this);
            this.clear();
            this.bytes = byArray;
            this.addAll((Collection)arrayList2);
        } else {
            this.bytes = byArray;
        }
        assert (arrayList.equals(new ArrayList(this)));
    }

    static int fmtLen(int n2) {
        return 1 + (n2 - 1) / -1;
    }

    static int descLoc(int n2) {
        return n2 >>> 1;
    }

    static int descFmt(int n2) {
        return n2 & 1;
    }

    static int descEnd(int n2) {
        return Fixups.descLoc(n2) + Fixups.fmtLen(Fixups.descFmt(n2));
    }

    static int makeDesc(int n2, int n3) {
        int n4 = n2 << 1 | n3;
        assert (Fixups.descLoc(n4) == n2);
        assert (Fixups.descFmt(n4) == n3);
        return n4;
    }

    int fetchDesc(int n2, int n3) {
        int n4;
        byte by = this.bytes[n2];
        assert (by != -1);
        if (n3 == 0) {
            byte by2 = this.bytes[n2 + 1];
            n4 = ((by & 0xFF) << 8) + (by2 & 0xFF);
        } else {
            n4 = by & 0xFF;
        }
        return n4 + (n2 << 1);
    }

    boolean storeDesc(int n2, int n3, int n4) {
        if (this.bytes == null) {
            return false;
        }
        int n5 = n4 - (n2 << 1);
        switch (n3) {
            case 0: {
                assert (this.bytes[n2 + 0] == 0);
                assert (this.bytes[n2 + 1] == 0);
                byte by = (byte)(n5 >> 8);
                byte by2 = (byte)(n5 >> 0);
                if (n5 != (n5 & 0xFFFF) || by == -1) break;
                this.bytes[n2 + 0] = by;
                this.bytes[n2 + 1] = by2;
                assert (this.fetchDesc(n2, n3) == n4);
                return true;
            }
            case 1: {
                assert (this.bytes[n2] == 0);
                byte by = (byte)n5;
                if (n5 != (n5 & 0xFF) || by == -1) break;
                this.bytes[n2] = by;
                assert (this.fetchDesc(n2, n3) == n4);
                return true;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.bytes[n2] = -1;
        assert (n3 == 1 || (this.bytes[n2 + 1] = (byte)this.bigDescs[0]) != 999);
        return false;
    }

    void storeIndex(int n2, int n3, int n4) {
        Fixups.storeIndex(this.bytes, n2, n3, n4);
    }

    static void storeIndex(byte[] byArray, int n2, int n3, int n4) {
        switch (n3) {
            case 0: {
                assert (n4 == (n4 & 0xFFFF)) : n4;
                byArray[n2 + 0] = (byte)(n4 >> 8);
                byArray[n2 + 1] = (byte)(n4 >> 0);
                break;
            }
            case 1: {
                assert (n4 == (n4 & 0xFF)) : n4;
                byArray[n2] = (byte)n4;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    public void add(int n2, int n3, ConstantPool.Entry entry) {
        this.addDesc(Fixups.makeDesc(n2, n3), entry);
    }

    public boolean add(Fixup fixup) {
        this.addDesc(fixup.desc, fixup.entry);
        return true;
    }

    public boolean add(Object object) {
        return this.add((Fixup)object);
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof Fixups) {
            Fixups fixups = (Fixups)collection;
            if (fixups.size == 0) {
                return false;
            }
            if (this.size == 0 && this.entries.length < fixups.size) {
                this.growEntries(fixups.size);
            }
            ConstantPool.Entry[] entryArray = fixups.entries;
            Fixups fixups2 = fixups;
            fixups2.getClass();
            Itr itr = fixups2.new Itr();
            while (itr.hasNext()) {
                int n2 = itr.index;
                this.addDesc(itr.nextDesc(), entryArray[n2]);
            }
            return true;
        }
        return super.addAll(collection);
    }

    private void addDesc(int n2, ConstantPool.Entry entry) {
        if (this.entries.length == this.size) {
            this.growEntries(this.size * 2);
        }
        this.entries[this.size] = entry;
        if (this.size == 0) {
            this.head = this.tail = n2;
        } else {
            int n3 = this.tail;
            int n4 = Fixups.descLoc(n3);
            int n5 = Fixups.descFmt(n3);
            int n6 = Fixups.fmtLen(n5);
            int n7 = Fixups.descLoc(n2);
            if (n7 < n4 + n6) {
                this.badOverlap(n7);
            }
            this.tail = n2;
            if (!this.storeDesc(n4, n5, n2)) {
                int n8 = this.bigDescs[0];
                if (this.bigDescs.length == n8) {
                    this.growBigDescs();
                }
                this.bigDescs[n8++] = n2;
                this.bigDescs[0] = n8;
            }
        }
        ++this.size;
    }

    private void badOverlap(int n2) {
        throw new IllegalArgumentException("locs must be ascending and must not overlap:  " + n2 + " >> " + this);
    }

    private void growEntries(int n2) {
        ConstantPool.Entry[] entryArray = this.entries;
        this.entries = new ConstantPool.Entry[Math.max(3, n2)];
        System.arraycopy(entryArray, 0, this.entries, 0, entryArray.length);
    }

    private void growBigDescs() {
        int[] nArray = this.bigDescs;
        this.bigDescs = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, this.bigDescs, 0, nArray.length);
    }

    public static Object add(Object object, byte[] byArray, int n2, int n3, ConstantPool.Entry entry) {
        Fixups fixups;
        if (object == null) {
            if (n2 == 0 && n3 == 0) {
                return entry;
            }
            fixups = new Fixups(byArray);
        } else if (!(object instanceof Fixups)) {
            ConstantPool.Entry entry2 = (ConstantPool.Entry)object;
            fixups = new Fixups(byArray);
            fixups.add(0, 0, entry2);
        } else {
            fixups = (Fixups)object;
            assert (fixups.bytes == byArray);
        }
        fixups.add(n2, n3, entry);
        return fixups;
    }

    public static void setBytes(Object object, byte[] byArray) {
        if (object instanceof Fixups) {
            Fixups fixups = (Fixups)object;
            fixups.setBytes(byArray);
        }
    }

    public static Object trimToSize(Object object) {
        if (object instanceof Fixups) {
            Fixups fixups = (Fixups)object;
            fixups.trimToSize();
            if (fixups.size() == 0) {
                object = null;
            }
        }
        return object;
    }

    public static void visitRefs(Object object, Collection collection) {
        if (object != null) {
            if (!(object instanceof Fixups)) {
                collection.add((ConstantPool.Entry)object);
            } else {
                Fixups fixups = (Fixups)object;
                fixups.visitRefs(collection);
            }
        }
    }

    public static void finishRefs(Object object, byte[] byArray, ConstantPool.Index index) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Fixups)) {
            int n2 = index.indexOf((ConstantPool.Entry)object);
            Fixups.storeIndex(byArray, 0, 0, n2);
            return;
        }
        Fixups fixups = (Fixups)object;
        assert (fixups.bytes == byArray);
        fixups.finishRefs(index);
    }

    void finishRefs(ConstantPool.Index index) {
        if (this.isEmpty()) {
            return;
        }
        for (Fixup fixup : this) {
            int n2 = index.indexOf(fixup.entry);
            this.storeIndex(fixup.location(), fixup.format(), n2);
        }
        this.bytes = null;
        this.clear();
    }

    public static class Fixup
    implements Comparable {
        int desc;
        ConstantPool.Entry entry;

        Fixup(int n2, ConstantPool.Entry entry) {
            this.desc = n2;
            this.entry = entry;
        }

        public Fixup(int n2, int n3, ConstantPool.Entry entry) {
            this.desc = Fixups.makeDesc(n2, n3);
            this.entry = entry;
        }

        public int location() {
            return Fixups.descLoc(this.desc);
        }

        public int format() {
            return Fixups.descFmt(this.desc);
        }

        public ConstantPool.Entry entry() {
            return this.entry;
        }

        public int compareTo(Fixup fixup) {
            return this.location() - fixup.location();
        }

        public int compareTo(Object object) {
            return this.compareTo((Fixup)object);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Fixup)) {
                return false;
            }
            Fixup fixup = (Fixup)object;
            return this.desc == fixup.desc && this.entry == fixup.entry;
        }

        public String toString() {
            return "@" + this.location() + (this.format() == 1 ? ".1" : "") + "=" + this.entry;
        }
    }

    private class Itr
    implements Iterator {
        int index = 0;
        int bigIndex = 1;
        int next;

        private Itr() {
            this.next = Fixups.this.head;
        }

        public boolean hasNext() {
            return this.index < Fixups.this.size;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            int n2 = this.index;
            return new Fixup(this.nextDesc(), Fixups.this.entries[n2]);
        }

        int nextDesc() {
            int n2 = this.index++;
            int n3 = this.next;
            if (this.index < Fixups.this.size) {
                int n4 = Fixups.descLoc(n3);
                int n5 = Fixups.descFmt(n3);
                if (Fixups.this.bytes != null && Fixups.this.bytes[n4] != -1) {
                    this.next = Fixups.this.fetchDesc(n4, n5);
                } else {
                    assert (n5 == 1 || Fixups.this.bytes == null || Fixups.this.bytes[n4 + 1] == (byte)this.bigIndex);
                    this.next = Fixups.this.bigDescs[this.bigIndex++];
                }
            }
            return n3;
        }
    }
}

