/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WindowsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
            this.progressBar.setBorder(null);
        }
    }

    protected Dimension getPreferredInnerHorizontal() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            return xPStyle.getDimension("progress.bar.normalsize");
        }
        return super.getPreferredInnerHorizontal();
    }

    protected Dimension getPreferredInnerVertical() {
        if (XPStyle.getXP() != null) {
            Dimension dimension = this.getPreferredInnerHorizontal();
            return new Dimension(dimension.height, dimension.width);
        }
        return super.getPreferredInnerVertical();
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl2 = this.progressBar.getOrientation() == 1;
            boolean bl3 = WindowsGraphicsUtils.isLeftToRight(jComponent);
            int n2 = this.progressBar.getWidth();
            int n3 = this.progressBar.getHeight() - 1;
            int n4 = this.getAmountFull(null, n2, n3);
            this.paintXPBackground(graphics, bl2, n2, n3);
            if (this.progressBar.isStringPainted()) {
                graphics.setColor(this.progressBar.getForeground());
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(bl2 ? (n2 -= 2) : (n3 -= 2), 0, 2));
                if (!bl2) {
                    if (bl3) {
                        graphics2D.drawLine(2, n3 / 2 + 1, n4 - 2, n3 / 2 + 1);
                    } else {
                        graphics2D.drawLine(2 + n2, n3 / 2 + 1, 2 + n2 - (n4 - 2), n3 / 2 + 1);
                    }
                    this.paintString(graphics, 0, 0, n2, n3, n4, null);
                } else {
                    graphics2D.drawLine(n2 / 2 + 1, n3 + 1, n2 / 2 + 1, n3 + 1 - n4 + 2);
                    this.paintString(graphics, 2, 2, n2, n3, n4, null);
                }
            } else {
                XPStyle.Skin skin = xPStyle.getSkin(bl2 ? "progress.chunkvert" : "progress.chunk");
                int n5 = bl2 ? n2 - 5 : n3 - 5;
                int n6 = xPStyle.getInt("progress.progresschunksize", 2);
                int n7 = xPStyle.getInt("progress.progressspacesize", 0);
                int n8 = (n4 - 4) / (n6 + n7);
                if (n7 > 0 && n8 * (n6 + n7) + n6 < n4 - 4) {
                    ++n8;
                }
                for (int i2 = 0; i2 < n8; ++i2) {
                    if (bl2) {
                        skin.paintSkin(graphics, 3, n3 - i2 * (n6 + n7) - n6 - 2, n5, n6, 0);
                        continue;
                    }
                    if (bl3) {
                        skin.paintSkin(graphics, 4 + i2 * (n6 + n7), 2, n6, n5, 0);
                        continue;
                    }
                    skin.paintSkin(graphics, n2 - (2 + (i2 + 1) * (n6 + n7)), 2, n6, n5, 0);
                }
            }
        } else {
            super.paintDeterminate(graphics, jComponent);
        }
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl2 = this.progressBar.getOrientation() == 1;
            int n2 = this.progressBar.getWidth();
            int n3 = this.progressBar.getHeight() - 1;
            this.paintXPBackground(graphics, bl2, n2, n3);
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                graphics.setColor(this.progressBar.getForeground());
                if (!bl2) {
                    graphics.fillRect(this.boxRect.x, this.boxRect.y + 2, this.boxRect.width, this.boxRect.height - 4);
                } else {
                    graphics.fillRect(this.boxRect.x + 2, this.boxRect.y, this.boxRect.width - 3, this.boxRect.height);
                }
                if (this.progressBar.isStringPainted()) {
                    if (!bl2) {
                        this.paintString(graphics, -1, -1, n2, n3, 0, null);
                    } else {
                        this.paintString(graphics, 1, 1, n2, n3, 0, null);
                    }
                }
            }
        } else {
            super.paintIndeterminate(graphics, jComponent);
        }
    }

    private void paintXPBackground(Graphics graphics, boolean bl2, int n2, int n3) {
        XPStyle xPStyle = XPStyle.getXP();
        String string = bl2 ? "progress.barvert" : "progress.bar";
        XPStyle.Skin skin = xPStyle.getSkin(string);
        Color color = xPStyle.getColor(string + ".fillcolorhint", null);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(2, 2, n2 - 4, n3 - 4);
        }
        skin.paintSkin(graphics, 0, 0, n2, n3, 0);
    }
}

