/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPConstants;
import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.common.ImageUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class BMPMetadata
extends IIOMetadata
implements BMPConstants {
    public static final String nativeMetadataFormatName = "javax_imageio_bmp_1.0";
    public String bmpVersion;
    public int width;
    public int height;
    public short bitsPerPixel;
    public int compression;
    public int imageSize;
    public int xPixelsPerMeter;
    public int yPixelsPerMeter;
    public int colorsUsed;
    public int colorsImportant;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int alphaMask;
    public int colorSpace;
    public double redX;
    public double redY;
    public double redZ;
    public double greenX;
    public double greenY;
    public double greenZ;
    public double blueX;
    public double blueY;
    public double blueZ;
    public int gammaRed;
    public int gammaGreen;
    public int gammaBlue;
    public int intent;
    public byte[] palette = null;
    public int paletteSize;
    public int red;
    public int green;
    public int blue;
    public List comments = null;

    public BMPMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.imageio.plugins.bmp.BMPMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("BMPMetadata0"));
    }

    private String toISO8859(byte[] byArray) {
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private Node getNativeTree() {
        int n2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(iIOMetadataNode, "BMPVersion", this.bmpVersion);
        this.addChildNode(iIOMetadataNode, "Width", new Integer(this.width));
        this.addChildNode(iIOMetadataNode, "Height", new Integer(this.height));
        this.addChildNode(iIOMetadataNode, "BitsPerPixel", new Short(this.bitsPerPixel));
        this.addChildNode(iIOMetadataNode, "Compression", new Integer(this.compression));
        this.addChildNode(iIOMetadataNode, "ImageSize", new Integer(this.imageSize));
        IIOMetadataNode iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "PixelsPerMeter", null);
        this.addChildNode(iIOMetadataNode2, "X", new Integer(this.xPixelsPerMeter));
        this.addChildNode(iIOMetadataNode2, "Y", new Integer(this.yPixelsPerMeter));
        this.addChildNode(iIOMetadataNode, "ColorsUsed", new Integer(this.colorsUsed));
        this.addChildNode(iIOMetadataNode, "ColorsImportant", new Integer(this.colorsImportant));
        int n3 = 0;
        for (n2 = 0; n2 < this.bmpVersion.length(); ++n2) {
            if (!Character.isDigit(this.bmpVersion.charAt(n2))) continue;
            n3 = this.bmpVersion.charAt(n2) - 48;
        }
        if (n3 >= 4) {
            iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "Mask", null);
            this.addChildNode(iIOMetadataNode2, "Red", new Integer(this.redMask));
            this.addChildNode(iIOMetadataNode2, "Green", new Integer(this.greenMask));
            this.addChildNode(iIOMetadataNode2, "Blue", new Integer(this.blueMask));
            this.addChildNode(iIOMetadataNode2, "Alpha", new Integer(this.alphaMask));
            this.addChildNode(iIOMetadataNode, "ColorSpaceType", new Integer(this.colorSpace));
            iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "CIEXYZEndPoints", null);
            this.addXYZPoints(iIOMetadataNode2, "Red", this.redX, this.redY, this.redZ);
            this.addXYZPoints(iIOMetadataNode2, "Green", this.greenX, this.greenY, this.greenZ);
            this.addXYZPoints(iIOMetadataNode2, "Blue", this.blueX, this.blueY, this.blueZ);
            iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "Intent", new Integer(this.intent));
        }
        if (this.palette != null && this.paletteSize > 0) {
            iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "Palette", null);
            n2 = this.palette.length / this.paletteSize;
            int n4 = 0;
            for (int i2 = 0; i2 < this.paletteSize; ++i2) {
                IIOMetadataNode iIOMetadataNode3 = this.addChildNode(iIOMetadataNode2, "PaletteEntry", null);
                this.red = this.palette[n4++] & 0xFF;
                this.green = this.palette[n4++] & 0xFF;
                this.blue = this.palette[n4++] & 0xFF;
                this.addChildNode(iIOMetadataNode3, "Red", new Byte((byte)this.red));
                this.addChildNode(iIOMetadataNode3, "Green", new Byte((byte)this.green));
                this.addChildNode(iIOMetadataNode3, "Blue", new Byte((byte)this.blue));
                if (n2 != 4) continue;
                this.addChildNode(iIOMetadataNode3, "Alpha", new Byte((byte)(this.palette[n4++] & 0xFF)));
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        if (this.palette != null && this.paletteSize > 0) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Palette");
            int n2 = this.palette.length / this.paletteSize;
            iIOMetadataNode2.setAttribute("value", "" + n2);
            int n3 = 0;
            for (int i2 = 0; i2 < this.paletteSize; ++i2) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", "" + i2);
                iIOMetadataNode3.setAttribute("red", "" + this.palette[n3++]);
                iIOMetadataNode3.setAttribute("green", "" + this.palette[n3++]);
                iIOMetadataNode3.setAttribute("blue", "" + this.palette[n3++]);
                if (n2 == 4 && this.palette[n3] != 0) {
                    iIOMetadataNode3.setAttribute("alpha", "" + this.palette[n3++]);
                }
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", compressionTypeNames[this.compression]);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        String string = "";
        if (this.bitsPerPixel == 24) {
            string = "8 8 8 ";
        } else if (this.bitsPerPixel == 16 || this.bitsPerPixel == 32) {
            string = "" + this.countBits(this.redMask) + " " + this.countBits(this.greenMask) + this.countBits(this.blueMask) + "" + this.countBits(this.alphaMask);
        }
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        if ((float)this.yPixelsPerMeter > 0.0f && (float)this.xPixelsPerMeter > 0.0f) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
            float f2 = this.yPixelsPerMeter / this.xPixelsPerMeter;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode2.setAttribute("value", "" + f2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPhysicalPixelSpacing");
            iIOMetadataNode2.setAttribute("value", "" + 1 / this.xPixelsPerMeter * 1000);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPhysicalPixelSpacing");
            iIOMetadataNode2.setAttribute("value", "" + 1 / this.yPixelsPerMeter * 1000);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    public void setFromTree(String string, Node node) {
        throw new IllegalStateException(I18N.getString("BMPMetadata1"));
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException(I18N.getString("BMPMetadata1"));
    }

    public void reset() {
        throw new IllegalStateException(I18N.getString("BMPMetadata1"));
    }

    private String countBits(int n2) {
        int n3 = 0;
        while (n2 > 0) {
            if ((n2 & 1) == 1) {
                ++n3;
            }
            n2 >>>= 1;
        }
        return n3 == 0 ? "" : "" + n3;
    }

    private void addXYZPoints(IIOMetadataNode iIOMetadataNode, String string, double d2, double d3, double d4) {
        IIOMetadataNode iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, string, null);
        this.addChildNode(iIOMetadataNode2, "X", new Double(d2));
        this.addChildNode(iIOMetadataNode2, "Y", new Double(d3));
        this.addChildNode(iIOMetadataNode2, "Z", new Double(d4));
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode iIOMetadataNode, String string, Object object) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        if (object != null) {
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(object));
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }
}

