/*
 * Decompiled with CFR 0.152.
 */
package cc.kss.gui;

import cc.kss.gui.DialogSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class DialogLayout
implements LayoutManager {
    protected static final int COMP_TWO_COL = 0;
    protected static final int COMP_BIG = 1;
    protected static final int COMP_BUTTON = 2;
    protected int m_divider = -1;
    protected int m_hGap = 10;
    protected int m_vGap = 5;
    protected Vector m_v = new Vector();

    public DialogLayout() {
    }

    public DialogLayout(int n, int n2) {
        this.m_hGap = n;
        this.m_vGap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        this.m_v.removeAllElements();
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            serializable = container.getComponent(i);
            int n4 = this.getLayoutType((Component)serializable);
            if (i == 0) {
                n3 = n4;
            }
            if (n3 != n4) {
                Dimension dimension = this.preferredLayoutSize(this.m_v, n3);
                n = Math.max(n, dimension.width);
                n2 += dimension.height + this.m_vGap;
                this.m_v.removeAllElements();
                n3 = n4;
            }
            this.m_v.addElement(serializable);
        }
        Dimension dimension = this.preferredLayoutSize(this.m_v, n3);
        n = Math.max(n, dimension.width);
        n2 += dimension.height + this.m_vGap;
        serializable = container.getInsets();
        return new Dimension(n + ((Insets)serializable).left + ((Insets)serializable).right, (n2 -= this.m_vGap) + ((Insets)serializable).top + ((Insets)serializable).bottom);
    }

    protected Dimension preferredLayoutSize(Vector vector, int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                int n4 = this.getDivider(vector);
                for (int i = 1; i < vector.size(); i += 2) {
                    Component component = (Component)vector.elementAt(i);
                    Dimension dimension = component.getPreferredSize();
                    n2 = Math.max(n2, dimension.width);
                    n3 += dimension.height + this.m_vGap;
                }
                return new Dimension(n4 + n2, n3 -= this.m_vGap);
            }
            case 1: {
                for (int i = 0; i < vector.size(); ++i) {
                    Component component = (Component)vector.elementAt(i);
                    Dimension dimension = component.getPreferredSize();
                    n2 = Math.max(n2, dimension.width);
                    n3 += dimension.height + this.m_vGap;
                }
                return new Dimension(n2, n3 -= this.m_vGap);
            }
            case 2: {
                Dimension dimension = this.getMaxDimension(vector);
                n2 = dimension.width + this.m_hGap;
                n3 = dimension.height;
                return new Dimension(n2 * vector.size() - this.m_hGap, n3);
            }
        }
        return new Dimension(0, 0);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        this.m_v.removeAllElements();
        int n = -1;
        Insets insets = container.getInsets();
        int n2 = container.getWidth() - insets.left - insets.right;
        int n3 = insets.left;
        int n4 = insets.top;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            int n5 = this.getLayoutType(component);
            if (i == 0) {
                n = n5;
            }
            if (n != n5) {
                n4 = this.layoutComponents(this.m_v, n, n3, n4, n2);
                this.m_v.removeAllElements();
                n = n5;
            }
            this.m_v.addElement(component);
        }
        n4 = this.layoutComponents(this.m_v, n, n3, n4, n2);
        this.m_v.removeAllElements();
    }

    protected int layoutComponents(Vector vector, int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                int n5 = this.getDivider(vector);
                for (int i = 1; i < vector.size(); i += 2) {
                    Component component = (Component)vector.elementAt(i - 1);
                    Component component2 = (Component)vector.elementAt(i);
                    Dimension dimension = component2.getPreferredSize();
                    component.setBounds(n2, n3, n5 - this.m_hGap, dimension.height);
                    component2.setBounds(n2 + n5, n3, n4 - n5, dimension.height);
                    if (!component.isVisible() || !component2.isVisible()) continue;
                    n3 += dimension.height + this.m_vGap;
                }
                return n3;
            }
            case 1: {
                for (int i = 0; i < vector.size(); ++i) {
                    Component component = (Component)vector.elementAt(i);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(n2, n3, n4, dimension.height);
                    if (!component.isVisible()) continue;
                    n3 += dimension.height + this.m_vGap;
                }
                return n3;
            }
            case 2: {
                Dimension dimension = this.getMaxDimension(vector);
                int n6 = dimension.width * vector.size() + this.m_hGap * (vector.size() - 1);
                int n7 = n2 + Math.max(0, (n4 - n6) / 2);
                for (int i = 0; i < vector.size(); ++i) {
                    Component component = (Component)vector.elementAt(i);
                    component.setBounds(n7, n3, dimension.width, dimension.height);
                    n7 += dimension.width + this.m_hGap;
                }
                return n3 + dimension.height;
            }
        }
        throw new IllegalArgumentException("Illegal type " + Integer.toString(n));
    }

    public int getHGap() {
        return this.m_hGap;
    }

    public int getVGap() {
        return this.m_vGap;
    }

    public void setDivider(int n) {
        if (n > 0) {
            this.m_divider = n;
        }
    }

    public int getDivider() {
        return this.m_divider;
    }

    protected int getDivider(Vector vector) {
        if (this.m_divider > 0) {
            return this.m_divider;
        }
        int n = 0;
        for (int i = 0; i < vector.size(); i += 2) {
            Component component = (Component)vector.elementAt(i);
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
        }
        return n += this.m_hGap;
    }

    protected Dimension getMaxDimension(Vector vector) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Component component = (Component)vector.elementAt(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        return new Dimension(n, n2);
    }

    protected int getLayoutType(Component component) {
        if (component instanceof AbstractButton) {
            return 2;
        }
        if (component instanceof JPanel || component instanceof JScrollPane || component instanceof JSplitPane || component instanceof JTabbedPane || component instanceof JTextArea || component instanceof JProgressBar || component instanceof DialogSeparator) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "";
    }
}

