/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BrowserAuthenticator;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.awt.Component;
import java.awt.Frame;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;

public class DeployAuthenticator
extends Authenticator {
    private static final String SCHEME_NTLM = "NTLM";
    private static HashMap baSites = new HashMap();
    protected Frame parentFrame = null;

    private BrowserAuthenticator getBrowserAuthenticator() {
        Service service = ServiceManager.getService();
        return service.getBrowserAuthenticator();
    }

    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication = null;
        try {
            Object object;
            String string;
            InetAddress inetAddress = this.getRequestingSite();
            if (inetAddress != null) {
                string = inetAddress.toString();
            } else {
                string = this.getRequestingHost();
                if (string == null || string.length() == 0) {
                    string = this.getMessage("net.authenticate.unknownSite");
                }
            }
            StringBuffer stringBuffer = new StringBuffer(this.getRequestingProtocol());
            stringBuffer.append(':');
            stringBuffer.append(this.getRequestingHost());
            stringBuffer.append(':');
            stringBuffer.append(this.getRequestingPort());
            stringBuffer.append(':');
            stringBuffer.append(this.getRequestingScheme());
            stringBuffer.append(':');
            stringBuffer.append(this.getRequestingPrompt());
            if (!baSites.containsKey(stringBuffer.toString()) && (object = this.getBrowserAuthenticator()) != null && (passwordAuthentication = object.getAuthentication(this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort(), this.getRequestingScheme(), this.getRequestingPrompt(), this.getRequestingURL(), this.getRequestorType() == Authenticator.RequestorType.PROXY)) != null) {
                baSites.put(stringBuffer.toString(), stringBuffer.toString());
                return passwordAuthentication;
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("Firewall authentication: site=");
            ((StringBuffer)object).append(this.getRequestingSite());
            ((StringBuffer)object).append(":" + this.getRequestingPort());
            ((StringBuffer)object).append(", protocol=");
            ((StringBuffer)object).append(this.getRequestingProtocol());
            ((StringBuffer)object).append(", prompt=");
            ((StringBuffer)object).append(this.getRequestingPrompt());
            ((StringBuffer)object).append(", scheme=");
            ((StringBuffer)object).append(this.getRequestingScheme());
            Trace.netPrintln(((StringBuffer)object).toString());
            passwordAuthentication = this.openDialog(string, this.getRequestingPrompt(), this.getRequestingScheme());
        }
        catch (Exception exception) {
            Trace.netPrintException(exception);
        }
        return passwordAuthentication;
    }

    private PasswordAuthentication openDialog(String string, String string2, String string3) {
        final String string4 = string;
        final String string5 = string2;
        final String string6 = string3;
        final Frame frame = this.parentFrame;
        try {
            return (PasswordAuthentication)DeploySysRun.execute(new DeploySysAction(){

                public Object execute() throws Exception {
                    return DeployAuthenticator.this.openDialogImpl(frame, string4, string5, string6);
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordAuthentication openDialogImpl(Component component, String string, String string2, String string3) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            JTextField jTextField = new JTextField();
            jTextField.setColumns(15);
            JLabel jLabel = new JLabel(this.getMessage("net.authenticate.username"));
            jLabel.setDisplayedMnemonic(ResourceManager.getVKCode("net.authenticate.username.mnemonic"));
            jLabel.setLabelFor(jTextField);
            JPasswordField jPasswordField = new JPasswordField();
            jPasswordField.setColumns(15);
            JLabel jLabel2 = new JLabel(this.getMessage("net.authenticate.password"));
            jLabel2.setDisplayedMnemonic(ResourceManager.getVKCode("net.authenticate.password.mnemonic"));
            jLabel2.setLabelFor(jPasswordField);
            JTextField jTextField2 = new JTextField();
            jTextField2.setColumns(15);
            JLabel jLabel3 = new JLabel(this.getMessage("net.authenticate.domain"));
            jLabel3.setDisplayedMnemonic(ResourceManager.getVKCode("net.authenticate.domain.mnemonic"));
            jLabel3.setLabelFor(jTextField2);
            boolean bl = string3 != null ? SCHEME_NTLM.equalsIgnoreCase(string3) : false;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(new JLabel(this.getMessage("net.authenticate.firewall")));
            jPanel.add(Box.createVerticalStrut(5));
            if (!bl) {
                jPanel.add(new JLabel(this.getMessage("net.authenticate.realm")));
                jPanel.add(Box.createVerticalStrut(5));
            }
            jPanel.add(new JLabel(this.getMessage("net.authenticate.scheme")));
            jPanel.add(Box.createVerticalStrut(15));
            jPanel.add(jLabel);
            jPanel.add(Box.createVerticalStrut(15));
            jPanel.add(jLabel2);
            jPanel.add(Box.createVerticalStrut(15));
            if (bl) {
                jPanel.add(jLabel3);
                jPanel.add(Box.createVerticalStrut(15));
            }
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(new JLabel(string));
            jPanel2.add(Box.createVerticalStrut(5));
            if (!bl) {
                jPanel2.add(new JLabel(string2));
                jPanel2.add(Box.createVerticalStrut(5));
            }
            jPanel2.add(new JLabel(string3));
            jPanel2.add(Box.createVerticalStrut(10));
            jPanel2.add(jTextField);
            jPanel2.add(Box.createVerticalStrut(10));
            jPanel2.add(jPasswordField);
            if (bl) {
                jPanel2.add(Box.createVerticalStrut(10));
                jPanel2.add(jTextField2);
            }
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(jPanel);
            jPanel3.add(Box.createHorizontalStrut(15));
            jPanel3.add(jPanel2);
            Object[] objectArray = new Object[]{jPanel3};
            int n = DialogFactory.showConfirmDialog(component, objectArray, this.getMessage("net.authenticate.caption"));
            if (n == 0) {
                char[] cArray = jPasswordField.getPassword();
                String string4 = jTextField2.getText();
                String string5 = bl && string4 != null && string4.length() > 0 ? string4 + '\\' + jTextField.getText() : jTextField.getText();
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(string5, cArray);
                Arrays.fill(cArray, ' ');
                PasswordAuthentication passwordAuthentication2 = passwordAuthentication;
                return passwordAuthentication2;
            }
            PasswordAuthentication passwordAuthentication = null;
            return passwordAuthentication;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void setParentFrame(Frame frame) {
        this.parentFrame = frame;
    }
}

