/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.GraphModelEvent;
import com.borland.jbcl.model.GraphModelListener;
import java.io.Serializable;
import java.util.EventListener;

public abstract class AbstractGraphModel
implements GraphModel,
Serializable {
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public GraphLocation find(Object data) {
        return null;
    }

    public void touched(GraphLocation node) {
        this.fireItemTouched(node);
    }

    public boolean canSet(GraphLocation node) {
        return true;
    }

    public boolean isVariableSize() {
        return true;
    }

    public void addModelListener(GraphModelListener listener) {
        this.modelListeners.add((EventListener)listener);
    }

    public void removeModelListener(GraphModelListener listener) {
        this.modelListeners.remove((EventListener)listener);
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.fireStructureChanged();
            }
        }
    }

    protected void fireContentChanged() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 1));
        }
    }

    protected void fireStructureChanged() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 2));
        }
    }

    protected void fireItemChanged(GraphLocation node) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 17, node));
        }
    }

    protected void fireItemTouched(GraphLocation node) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 33, node));
        }
    }

    protected void fireNodeAdded(GraphLocation node) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 18, node));
        }
    }

    protected void fireNodeRemoved(GraphLocation node) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 34, node));
        }
    }

    protected void fireNodeReplaced(GraphLocation node) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new GraphModelEvent(this, 50, node));
        }
    }

    public abstract Object get(GraphLocation var1);

    public abstract GraphLocation getRoot();
}

