/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Filer
implements WindowListener,
Serializable {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    protected FileDialog dialog;
    protected Frame frame;
    protected String title;
    protected int mode;
    protected String file;
    protected String dir;
    protected transient FilenameFilter filter;

    public Filer(Frame frame, String title, int mode) {
        this.frame = frame;
        this.title = title;
        this.mode = mode;
        if (frame != null) {
            this.dialog = new FileDialog(frame, title, mode);
        }
    }

    public Filer(Frame frame, String title) {
        this(frame, title, 0);
    }

    public Filer(Frame frame) {
        this(frame, "", 0);
    }

    public Filer() {
        this(null, "", 0);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }

    public String getTitle() {
        if (this.dialog != null) {
            this.title = this.dialog.getTitle();
        }
        return this.title;
    }

    public void setMode(int m) {
        this.mode = m;
        if (this.dialog != null) {
            this.dialog.setMode(m);
        }
    }

    public int getMode() {
        if (this.dialog != null) {
            this.mode = this.dialog.getMode();
        }
        return this.mode;
    }

    public void setDirectory(String dir) {
        this.dir = dir;
        if (this.dialog != null) {
            this.dialog.setDirectory(dir);
        }
    }

    public String getDirectory() {
        if (this.dialog != null) {
            this.dir = this.dialog.getDirectory();
        }
        return this.dir;
    }

    public void setFile(String file) {
        this.file = file;
        if (this.dialog != null) {
            this.dialog.setFile(file);
        }
    }

    public String getFile() {
        if (this.dialog != null) {
            this.file = this.dialog.getFile();
        }
        return this.file;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
        if (this.dialog != null) {
            this.dialog.setFilenameFilter(filter);
        }
    }

    public FilenameFilter getFilenameFilter() {
        if (this.dialog != null) {
            this.filter = this.dialog.getFilenameFilter();
        }
        return this.filter;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res._NoFrame);
                }
                this.dialog = new FileDialog(this.frame, this.title, this.mode);
                this.dialog.setFile(this.file);
                this.dialog.setDirectory(this.dir);
                this.dialog.setFilenameFilter(this.filter);
                this.dialog.addWindowListener(this);
            }
            this.dialog.show();
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        this.getFile();
        this.getDirectory();
        this.getFilenameFilter();
    }

    public void windowClosed(WindowEvent e2) {
        if (this.dialog != null) {
            this.getFile();
            this.getDirectory();
            this.getFilenameFilter();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.frame.getFocusOwner() != null) {
                this.frame.getFocusOwner().requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowActivated(WindowEvent e2) {
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.filter instanceof Serializable ? this.filter : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof FilenameFilter) {
            this.filter = (FilenameFilter)data;
        }
    }

    static {
        LOAD = 0;
        SAVE = 1;
    }
}

