/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.BakedArrayList;
import sun.swing.plaf.synth.DefaultSynthStyle;
import sun.swing.plaf.synth.StyleAssociation;

class DefaultSynthStyleFactory
extends SynthStyleFactory {
    public static final int NAME = 0;
    public static final int REGION = 1;
    private List _nameStyles;
    private List _regionStyles;
    private BakedArrayList _tmpList = new BakedArrayList(5);
    private Map _resolvedStyles = new HashMap();
    private SynthStyle _defaultStyle;

    DefaultSynthStyleFactory() {
    }

    public synchronized void addStyle(DefaultSynthStyle defaultSynthStyle, String string, int n2) throws PatternSyntaxException {
        if (string == null) {
            string = ".*";
        }
        if (n2 == 0) {
            if (this._nameStyles == null) {
                this._nameStyles = new ArrayList();
            }
            this._nameStyles.add(StyleAssociation.createStyleAssociation(string, defaultSynthStyle));
        } else if (n2 == 1) {
            if (this._regionStyles == null) {
                this._regionStyles = new ArrayList();
            }
            this._regionStyles.add(StyleAssociation.createStyleAssociation(string.toLowerCase(), defaultSynthStyle));
        }
    }

    public synchronized SynthStyle getStyle(JComponent jComponent, Region region) {
        BakedArrayList bakedArrayList = this._tmpList;
        bakedArrayList.clear();
        this.getMatchingStyles(bakedArrayList, jComponent, region);
        if (bakedArrayList.size() == 0) {
            return this.getDefaultStyle();
        }
        bakedArrayList.cacheHashCode();
        SynthStyle synthStyle = this.getCachedStyle(bakedArrayList);
        if (synthStyle == null && (synthStyle = this.mergeStyles(bakedArrayList)) != null) {
            this.cacheStyle(bakedArrayList, synthStyle);
        }
        return synthStyle;
    }

    private SynthStyle getDefaultStyle() {
        if (this._defaultStyle == null) {
            this._defaultStyle = new DefaultSynthStyle();
            ((DefaultSynthStyle)this._defaultStyle).setFont(new FontUIResource("Dialog", 0, 12));
        }
        return this._defaultStyle;
    }

    private void getMatchingStyles(List list, JComponent jComponent, Region region) {
        if (this._regionStyles != null) {
            this.getMatches(region.getLowerCaseName(), this._regionStyles, list);
        }
        if (this._nameStyles != null) {
            String string = jComponent.getName();
            if (string == null) {
                string = "";
            }
            this.getMatches(string, this._nameStyles, list);
        }
    }

    private void getMatches(CharSequence charSequence, List list, List list2) {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            StyleAssociation styleAssociation = (StyleAssociation)list.get(i2);
            if (!styleAssociation.matches(charSequence) || list2.indexOf(styleAssociation.getStyle()) != -1) continue;
            list2.add(styleAssociation.getStyle());
        }
    }

    private void cacheStyle(List list, SynthStyle synthStyle) {
        BakedArrayList bakedArrayList = new BakedArrayList(list);
        this._resolvedStyles.put(bakedArrayList, synthStyle);
    }

    private SynthStyle getCachedStyle(List list) {
        if (list.size() == 0) {
            return null;
        }
        return (SynthStyle)this._resolvedStyles.get(list);
    }

    private SynthStyle mergeStyles(List list) {
        int n2 = list.size();
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return (SynthStyle)((DefaultSynthStyle)list.get(0)).clone();
        }
        DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)list.get(n2 - 1);
        defaultSynthStyle = (DefaultSynthStyle)defaultSynthStyle.clone();
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            defaultSynthStyle = ((DefaultSynthStyle)list.get(i2)).addTo(defaultSynthStyle);
        }
        return defaultSynthStyle;
    }
}

