/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteConstants;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.EngineOutputRecord;
import com.sun.net.ssl.internal.ssl.HandshakeHash;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.PRF;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RandomCookie;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.ServerHandshaker;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;

abstract class Handshaker
implements CipherSuiteConstants {
    ProtocolVersion protocolVersion;
    ProtocolList enabledProtocols;
    private boolean isClient;
    SSLSocketImpl conn = null;
    SSLEngineImpl engine = null;
    HandshakeHash handshakeHash;
    HandshakeInStream input;
    HandshakeOutStream output;
    int state;
    SSLContextImpl sslContext;
    RandomCookie clnt_random;
    RandomCookie svr_random;
    SSLSessionImpl session;
    private MessageDigest md5Tmp;
    private MessageDigest shaTmp;
    CipherSuiteList enabledCipherSuites;
    CipherSuite cipherSuite;
    CipherSuite.KeyExchange keyExchange;
    boolean resumingSession;
    boolean enableNewSession;
    private byte[] clntWriteKey;
    private byte[] svrWriteKey;
    private byte[] clntWriteIV;
    private byte[] svrWriteIV;
    private byte[] clntMacSecret;
    private byte[] svrMacSecret;
    private boolean taskDelegated = false;
    private DelegatedTask delegatedTask = null;
    private Exception thrown = null;
    static final Debug debug = Debug.getInstance("ssl");

    Handshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2) {
        this.conn = sSLSocketImpl;
        this.init(sSLContextImpl, protocolList, bl, bl2);
    }

    Handshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2) {
        this.engine = sSLEngineImpl;
        this.init(sSLContextImpl, protocolList, bl, bl2);
    }

    private void init(SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2) {
        this.sslContext = sSLContextImpl;
        this.isClient = bl2;
        this.enableNewSession = true;
        this.setCipherSuite(CipherSuite.C_NULL);
        this.md5Tmp = JsseJce.getMD5();
        this.shaTmp = JsseJce.getSHA();
        this.handshakeHash = new HandshakeHash(bl);
        this.setEnabledProtocols(protocolList);
        if (this.conn != null) {
            this.conn.getAppInputStream().r.setHandshakeHash(this.handshakeHash);
        } else {
            this.engine.inputRecord.setHandshakeHash(this.handshakeHash);
        }
        this.state = -1;
    }

    void fatalSE(byte by, String string) throws IOException {
        this.fatalSE(by, string, null);
    }

    void fatalSE(byte by, Throwable throwable) throws IOException {
        this.fatalSE(by, null, throwable);
    }

    void fatalSE(byte by, String string, Throwable throwable) throws IOException {
        if (this.conn != null) {
            this.conn.fatal(by, string, throwable);
        } else {
            this.engine.fatal(by, string, throwable);
        }
    }

    void warningSE(byte by) {
        if (this.conn != null) {
            this.conn.warning(by);
        } else {
            this.engine.warning(by);
        }
    }

    String getHostSE() {
        if (this.conn != null) {
            return this.conn.getHost();
        }
        return this.engine.getPeerHost();
    }

    String getHostAddressSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return this.engine.getPeerHost();
    }

    boolean isLoopbackSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().isLoopbackAddress();
        }
        return false;
    }

    int getPortSE() {
        if (this.conn != null) {
            return this.conn.getPort();
        }
        return this.engine.getPeerPort();
    }

    int getLocalPortSE() {
        if (this.conn != null) {
            return this.conn.getLocalPort();
        }
        return -1;
    }

    AccessControlContext getAccSE() {
        if (this.conn != null) {
            return this.conn.getAcc();
        }
        return this.engine.getAcc();
    }

    private void setVersionSE(ProtocolVersion protocolVersion) {
        if (this.conn != null) {
            this.conn.setVersion(protocolVersion);
        } else {
            this.engine.setVersion(protocolVersion);
        }
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.setVersionSE(protocolVersion);
        this.output.r.setVersion(protocolVersion);
    }

    void setEnabledProtocols(ProtocolList protocolList) {
        this.enabledProtocols = protocolList;
        this.protocolVersion = protocolList.max;
        ProtocolVersion protocolVersion = protocolList.helloVersion;
        this.input = new HandshakeInStream(this.handshakeHash);
        if (this.conn != null) {
            this.output = new HandshakeOutStream(this.protocolVersion, protocolVersion, this.handshakeHash, this.conn);
            this.conn.getAppInputStream().r.setHelloVersion(protocolVersion);
        } else {
            this.output = new HandshakeOutStream(this.protocolVersion, protocolVersion, this.handshakeHash, this.engine);
            this.engine.outputRecord.setHelloVersion(protocolVersion);
        }
    }

    void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        this.keyExchange = cipherSuite.keyExchange;
    }

    boolean isEnabled(CipherSuite cipherSuite) {
        return this.enabledCipherSuites.contains(cipherSuite) && cipherSuite.isAvailable();
    }

    void setEnableSessionCreation(boolean bl) {
        this.enableNewSession = bl;
    }

    CipherBox newReadCipher() throws NoSuchAlgorithmException {
        CipherBox cipherBox;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        if (this.isClient) {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, false);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        } else {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, false);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        }
        return cipherBox;
    }

    CipherBox newWriteCipher() throws NoSuchAlgorithmException {
        CipherBox cipherBox;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        if (this.isClient) {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, true);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        } else {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, true);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        }
        return cipherBox;
    }

    MAC newReadMAC() throws NoSuchAlgorithmException {
        MAC mAC;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mAC = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        } else {
            mAC = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        }
        return mAC;
    }

    MAC newWriteMAC() throws NoSuchAlgorithmException {
        MAC mAC;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mAC = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        } else {
            mAC = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        }
        return mAC;
    }

    boolean isDone() {
        return this.state == 20;
    }

    SSLSessionImpl getSession() {
        return this.session;
    }

    void process_record(InputRecord inputRecord, boolean bl) throws IOException {
        this.checkThrown();
        this.input.incomingRecord(inputRecord);
        if (this.conn != null || bl) {
            this.processLoop();
        } else {
            this.delegateTask(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Handshaker.this.processLoop();
                    return null;
                }
            });
        }
    }

    void processLoop() throws IOException {
        while (this.input.available() > 0) {
            this.input.mark(4);
            byte by = (byte)this.input.getInt8();
            int n = this.input.getInt24();
            if (this.input.available() < n) {
                this.input.reset();
                return;
            }
            if (by == 0) {
                this.input.reset();
                this.processMessage(by, n);
                this.input.ignore(4 + n);
                continue;
            }
            this.input.mark(n);
            this.processMessage(by, n);
            this.input.digestNow();
        }
    }

    boolean started() {
        return this.state >= 0;
    }

    void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage handshakeMessage = this.getKickstartMessage();
        if (debug != null && Debug.isOn("handshake")) {
            handshakeMessage.print(System.out);
        }
        handshakeMessage.write(this.output);
        this.output.flush();
        this.state = handshakeMessage.messageType();
    }

    abstract HandshakeMessage getKickstartMessage() throws SSLException;

    abstract void processMessage(byte var1, int var2) throws IOException;

    abstract void handshakeAlert(byte var1) throws SSLProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChangeCipherSpec(HandshakeMessage.Finished finished) throws IOException {
        this.output.flush();
        OutputRecord outputRecord = this.conn != null ? new OutputRecord(20) : new EngineOutputRecord(20, this.engine);
        outputRecord.setVersion(this.protocolVersion);
        outputRecord.write(1);
        if (this.conn != null) {
            Object object = this.conn.writeLock;
            synchronized (object) {
                this.conn.writeRecord(outputRecord);
                this.conn.changeWriteCiphers();
                if (debug != null && Debug.isOn("handshake")) {
                    finished.print(System.out);
                }
                finished.write(this.output);
                this.output.flush();
            }
        }
        Object object = this.engine.wrapLock;
        synchronized (object) {
            this.engine.writeRecord((EngineOutputRecord)outputRecord);
            this.engine.changeWriteCiphers();
            if (debug != null && Debug.isOn("handshake")) {
                finished.print(System.out);
            }
            finished.write(this.output);
            if (this instanceof ServerHandshaker) {
                this.output.setFinishedMsg();
            }
            this.output.flush();
        }
    }

    void calculateKeys(byte[] byArray) {
        byte[] byArray2 = this.calculateMasterSecret(byArray);
        this.session.setMasterSecret(byArray2);
        this.calculateConnectionKeys(byArray2);
    }

    private byte[] calculateMasterSecret(byte[] byArray) {
        byte[] byArray2 = new byte[48];
        if (debug != null && Debug.isOn("keygen")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("SESSION KEYGEN:");
                System.out.println("PreMaster Secret:");
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.doPRF(byArray, PRF.LABEL_MASTER_SECRET, byArray2);
        } else {
            for (int i = 0; i < 3; ++i) {
                byte by = (byte)(65 + i);
                for (int j = 0; j <= i; ++j) {
                    this.shaTmp.update(by);
                }
                this.shaTmp.update(byArray);
                this.shaTmp.update(this.clnt_random.random_bytes);
                this.shaTmp.update(this.svr_random.random_bytes);
                this.md5Tmp.update(byArray);
                this.md5Tmp.update(this.shaTmp.digest());
                System.arraycopy(this.md5Tmp.digest(), 0, byArray2, 16 * i, 16);
            }
        }
        return byArray2;
    }

    private void doPRF(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        PRF.compute(this.md5Tmp, this.shaTmp, byArray, byArray2, this.clnt_random.random_bytes, this.svr_random.random_bytes, byArray3);
    }

    private void doKeyExpansionPRF(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        PRF.compute(this.md5Tmp, this.shaTmp, byArray, byArray2, this.svr_random.random_bytes, this.clnt_random.random_bytes, byArray3);
    }

    void calculateConnectionKeys(byte[] byArray) {
        int n;
        int n2 = this.cipherSuite.macAlg.size;
        boolean bl = this.cipherSuite.exportable;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        int n3 = bulkCipher.keySize;
        int n4 = bulkCipher.ivSize;
        int n5 = n2 + n3 + (bl ? 0 : n4);
        byte[] byArray2 = new byte[n5 *= 2];
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.doKeyExpansionPRF(byArray, PRF.LABEL_KEY_EXPANSION, byArray2);
        } else {
            n = 0;
            for (int i = n5; i > 0; i -= 16) {
                byte by = (byte)(65 + n);
                for (int j = 0; j <= n; ++j) {
                    this.shaTmp.update(by);
                }
                this.shaTmp.update(byArray);
                this.shaTmp.update(this.svr_random.random_bytes);
                this.shaTmp.update(this.clnt_random.random_bytes);
                this.md5Tmp.update(byArray);
                this.md5Tmp.update(this.shaTmp.digest());
                System.arraycopy(this.md5Tmp.digest(), 0, byArray2, n * 16, Math.min(i, 16));
                ++n;
            }
        }
        this.clntMacSecret = new byte[n2];
        this.svrMacSecret = new byte[n2];
        System.arraycopy(byArray2, 0, this.clntMacSecret, 0, n2);
        System.arraycopy(byArray2, n2, this.svrMacSecret, 0, n2);
        this.clntWriteKey = new byte[n3];
        this.svrWriteKey = new byte[n3];
        System.arraycopy(byArray2, 2 * n2, this.clntWriteKey, 0, n3);
        System.arraycopy(byArray2, 2 * n2 + n3, this.svrWriteKey, 0, n3);
        if (n4 != 0) {
            this.clntWriteIV = new byte[n4];
            this.svrWriteIV = new byte[n4];
            if (!bl) {
                System.arraycopy(byArray2, 2 * (n2 + n3), this.clntWriteIV, 0, n4);
                System.arraycopy(byArray2, 2 * (n2 + n3) + n4, this.svrWriteIV, 0, n4);
            }
        } else {
            this.clntWriteIV = null;
            this.svrWriteIV = null;
        }
        if (bl) {
            n = bulkCipher.expandedKeySize;
            if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                byte[] byArray3 = new byte[n];
                this.doPRF(this.clntWriteKey, PRF.LABEL_CLIENT_WRITE_KEY, byArray3);
                this.clntWriteKey = byArray3;
                byte[] byArray4 = new byte[n];
                this.doPRF(this.svrWriteKey, PRF.LABEL_SERVER_WRITE_KEY, byArray4);
                this.svrWriteKey = byArray4;
                if (n4 != 0) {
                    byte[] byArray5 = new byte[2 * n4];
                    this.doPRF(null, PRF.LABEL_IV_BLOCK, byArray5);
                    System.arraycopy(byArray5, 0, this.clntWriteIV, 0, n4);
                    System.arraycopy(byArray5, n4, this.svrWriteIV, 0, n4);
                }
            } else {
                this.md5Tmp.update(this.clntWriteKey);
                this.md5Tmp.update(this.clnt_random.random_bytes);
                this.md5Tmp.update(this.svr_random.random_bytes);
                this.clntWriteKey = new byte[n];
                System.arraycopy(this.md5Tmp.digest(), 0, this.clntWriteKey, 0, n);
                this.md5Tmp.update(this.svrWriteKey);
                this.md5Tmp.update(this.svr_random.random_bytes);
                this.md5Tmp.update(this.clnt_random.random_bytes);
                this.svrWriteKey = new byte[n];
                System.arraycopy(this.md5Tmp.digest(), 0, this.svrWriteKey, 0, n);
                if (n4 != 0) {
                    this.md5Tmp.update(this.clnt_random.random_bytes);
                    this.md5Tmp.update(this.svr_random.random_bytes);
                    System.arraycopy(this.md5Tmp.digest(), 0, this.clntWriteIV, 0, n4);
                    this.md5Tmp.update(this.svr_random.random_bytes);
                    this.md5Tmp.update(this.clnt_random.random_bytes);
                    System.arraycopy(this.md5Tmp.digest(), 0, this.svrWriteIV, 0, n4);
                }
            }
        }
        if (debug != null && Debug.isOn("keygen")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                hexDumpEncoder.encodeBuffer(this.clnt_random.random_bytes, (OutputStream)System.out);
                System.out.println("Server Nonce:");
                hexDumpEncoder.encodeBuffer(this.svr_random.random_bytes, (OutputStream)System.out);
                System.out.println("Master Secret:");
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
                System.out.println("Client MAC write Secret:");
                hexDumpEncoder.encodeBuffer(this.clntMacSecret, (OutputStream)System.out);
                System.out.println("Server MAC write Secret:");
                hexDumpEncoder.encodeBuffer(this.svrMacSecret, (OutputStream)System.out);
                System.out.println("Client write key:");
                hexDumpEncoder.encodeBuffer(this.clntWriteKey, (OutputStream)System.out);
                System.out.println("Server write key:");
                hexDumpEncoder.encodeBuffer(this.svrWriteKey, (OutputStream)System.out);
                if (this.clntWriteIV != null) {
                    System.out.println("Client write IV:");
                    hexDumpEncoder.encodeBuffer(this.clntWriteIV, (OutputStream)System.out);
                    System.out.println("Server write IV:");
                    hexDumpEncoder.encodeBuffer(this.svrWriteIV, (OutputStream)System.out);
                } else {
                    System.out.println("... no IV for cipher");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void throwSSLException(String string, Throwable throwable) throws SSLException {
        SSLException sSLException = new SSLException(string);
        sSLException.initCause(throwable);
        throw sSLException;
    }

    private void delegateTask(PrivilegedExceptionAction privilegedExceptionAction) {
        this.delegatedTask = new DelegatedTask(privilegedExceptionAction);
        this.taskDelegated = false;
        this.thrown = null;
    }

    DelegatedTask getTask() {
        if (!this.taskDelegated) {
            this.taskDelegated = true;
            return this.delegatedTask;
        }
        return null;
    }

    boolean taskOutstanding() {
        return this.delegatedTask != null;
    }

    void checkThrown() throws SSLException {
        if (this.thrown != null) {
            String string = this.thrown.getMessage();
            if (string == null) {
                string = "Delegated task threw Exception/Error";
            }
            Exception exception = this.thrown;
            this.thrown = null;
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)new RuntimeException(string).initCause(exception);
            }
            if (exception instanceof SSLHandshakeException) {
                throw (SSLHandshakeException)new SSLHandshakeException(string).initCause(exception);
            }
            if (exception instanceof SSLKeyException) {
                throw (SSLKeyException)new SSLKeyException(string).initCause(exception);
            }
            if (exception instanceof SSLPeerUnverifiedException) {
                throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(string).initCause(exception);
            }
            if (exception instanceof SSLProtocolException) {
                throw (SSLProtocolException)new SSLProtocolException(string).initCause(exception);
            }
            throw (SSLException)new SSLException(string).initCause(exception);
        }
    }

    class DelegatedTask
    implements Runnable {
        private PrivilegedExceptionAction pea;

        DelegatedTask(PrivilegedExceptionAction privilegedExceptionAction) {
            this.pea = privilegedExceptionAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SSLEngineImpl sSLEngineImpl = Handshaker.this.engine;
            synchronized (sSLEngineImpl) {
                try {
                    AccessController.doPrivileged(this.pea, Handshaker.this.engine.getAcc());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Handshaker.this.thrown = privilegedActionException.getException();
                }
                catch (RuntimeException runtimeException) {
                    Handshaker.this.thrown = runtimeException;
                }
                Handshaker.this.delegatedTask = null;
                Handshaker.this.taskDelegated = false;
            }
        }
    }
}

