/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jbcl.editors.Res;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class StringArrayEditorPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JTable list = new JTable();
    JScrollPane listPane = new JScrollPane();
    DefaultTableModel model = new DefaultTableModel();
    JButton add = new JButton();
    JButton remove = new JButton();
    JButton clear = new JButton();
    JButton up = new JButton();
    JButton down = new JButton();
    JLabel spacer = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();

    public StringArrayEditorPanel() {
        this.jbInit();
        this.checkButtons();
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout2);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setPreferredWidth(120);
        column.setModelIndex(0);
        column.setHeaderValue("");
        this.model.addColumn("column1");
        columnModel.addColumn(column);
        this.list.setAutoCreateColumnsFromModel(false);
        this.list.setModel(this.model);
        this.list.setColumnModel(columnModel);
        this.list.getSelectionModel().addListSelectionListener(this);
        this.up.setText(Res._MoveUp);
        this.up.addActionListener(this);
        this.down.setText(Res._MoveDown);
        this.down.addActionListener(this);
        this.add.setText(Res._Add);
        this.add.addActionListener(this);
        this.remove.setText(Res._Remove);
        this.remove.addActionListener(this);
        this.clear.setText(Res._Clear);
        this.clear.addActionListener(this);
        this.add((Component)this.up, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.down, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.clear, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.remove, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.add, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.spacer, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.listPane, new GridBagConstraints(0, 0, 1, 6, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), -300, -200));
        this.listPane.getViewport().add((Component)this.list, null);
    }

    void setItems(String[] sa) {
        this.list.getSelectionModel().removeListSelectionListener(this);
        if (sa != null) {
            int i2;
            int size = this.model.getRowCount();
            for (i2 = 0; i2 < size; ++i2) {
                this.model.removeRow(0);
            }
            for (i2 = 0; i2 < sa.length; ++i2) {
                this.model.addRow(new String[]{sa[i2]});
            }
        }
        this.list.getSelectionModel().addListSelectionListener(this);
        this.checkButtons();
    }

    public void actionPerformed(ActionEvent e2) {
        if (this.list.isEditing()) {
            TableCellEditor editor = this.list.getCellEditor();
            editor.stopCellEditing();
        }
        Object src = e2.getSource();
        int sf = this.list.getSelectedRow();
        int count = this.model.getRowCount();
        if (src == this.up) {
            if (count > 1 && sf > 0) {
                Object above = this.model.getValueAt(sf - 1, 0);
                Object below = this.model.getValueAt(sf, 0);
                this.model.setValueAt(above, sf, 0);
                this.model.setValueAt(below, sf - 1, 0);
                this.list.setRowSelectionInterval(sf - 1, sf - 1);
            }
        } else if (src == this.down) {
            if (count > 1 && sf < count - 1) {
                Object below = this.model.getValueAt(sf + 1, 0);
                Object above = this.model.getValueAt(sf, 0);
                this.model.setValueAt(below, sf, 0);
                this.model.setValueAt(above, sf + 1, 0);
                this.list.setRowSelectionInterval(sf + 1, sf + 1);
            }
        } else if (src == this.add) {
            this.model.addRow(new String[]{Res.bundle.format(89, String.valueOf(count + 1))});
            this.list.setRowSelectionInterval(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
            this.checkButtons();
        } else if (src == this.remove) {
            this.model.removeRow(sf);
            this.checkButtons();
        } else if (src == this.clear) {
            int rowCount = this.model.getRowCount();
            for (int i2 = 0; i2 < rowCount; ++i2) {
                this.model.removeRow(0);
            }
            this.checkButtons();
        }
    }

    public Insets getInsets() {
        return new Insets(10, 10, 5, 10);
    }

    void checkButtons() {
        int count = this.model.getRowCount();
        int sf = this.list.getSelectedRow();
        if (count > 1) {
            if (sf == 0) {
                this.up.setEnabled(false);
                this.down.setEnabled(true);
            } else if (sf == count - 1) {
                this.up.setEnabled(true);
                this.down.setEnabled(false);
            } else {
                this.up.setEnabled(true);
                this.down.setEnabled(true);
            }
        } else {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        }
        if (count > 0) {
            this.remove.setEnabled(true);
            this.clear.setEnabled(true);
        } else {
            this.remove.setEnabled(false);
            this.clear.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent e2) {
        this.checkButtons();
    }
}

