/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipResourceLoader {
    Hashtable resources = new Hashtable();
    URLStreamHandler handler = new URLStreamHandler(){

        protected URLConnection openConnection(URL u) {
            return new ZipURLConnection(u);
        }

        protected void parseURL(URL u, String spec, int start, int limit) {
            String file = u.getFile();
            int index = file.indexOf("/");
            if (index != -1) {
                String path = file.substring(0, index);
                this.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), path + "/" + spec, u.getRef());
            } else {
                this.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), spec, u.getRef());
            }
        }

        protected String toExternalForm(URL u) {
            return "ziploader://" + u.getFile();
        }
    };

    public ZipResourceLoader(URL p_JarUrl) throws Exception {
        this(p_JarUrl.openStream());
    }

    public ZipResourceLoader(InputStream p_JarStream) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(p_JarStream);
        ZipInputStream input = new ZipInputStream(bis);
        ZipEntry entry = null;
        while ((entry = input.getNextEntry()) != null) {
            int read;
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            while ((read = input.read()) != -1) {
                outBuffer.write(read);
            }
            this.resources.put(entry.getName(), outBuffer.toByteArray());
        }
    }

    public InputStream getResourceAsStream(String name) throws MalformedURLException, IOException {
        return this.getResource(name).openStream();
    }

    public URL getResource(String name) throws MalformedURLException {
        if (this.resources.get(name) == null) {
            return null;
        }
        return new URL("ziploader", null, -1, name, this.handler);
    }

    public ZipResource getZipResource(String name) {
        return new ZipResource(name);
    }

    public ZipResource getZipResource(URL name) {
        return this.getZipResource(name.getFile());
    }

    public Enumeration entries() {
        return this.resources.keys();
    }

    public void dump() {
        Enumeration e = this.resources.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.out.println(name + " size = " + ((byte[])this.resources.get(name)).length);
        }
    }

    public void release() {
        this.resources.clear();
        this.resources = null;
    }

    private byte[] getURLContent(String name) {
        byte[] data = (byte[])this.resources.get(name);
        if (data == null && name.startsWith("/")) {
            data = (byte[])this.resources.get(name.substring(1));
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        ZipResourceLoader loader = new ZipResourceLoader(new File(args[0]).toURL());
        Enumeration e = loader.entries();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.out.println(name);
            URL url = loader.getResource(name);
            System.out.println(url);
            System.out.println(url.openStream());
            System.out.println(loader.getZipResource(name).getInputStream());
        }
    }

    class ZipURLConnection
    extends URLConnection {
        public ZipURLConnection(URL p_Url) {
            super(p_Url);
        }

        public InputStream getInputStream() {
            ByteArrayInputStream input = new ByteArrayInputStream((byte[])ZipResourceLoader.this.resources.get(this.getURL().getFile()));
            return input;
        }

        public void connect() throws IOException {
            if (ZipResourceLoader.this.resources == null || ZipResourceLoader.this.resources.get(this.getURL().getFile()) == null) {
                throw new IOException("No data for " + this.getURL());
            }
        }
    }

    public class ZipResource {
        String m_Name;

        public ZipResource(String p_Name) {
            this.m_Name = p_Name;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("http", null, -1, this.m_Name);
        }

        public InputStream getInputStream() {
            ByteArrayInputStream input = new ByteArrayInputStream(ZipResourceLoader.this.getURLContent(this.m_Name));
            return input;
        }

        public byte[] getURLContent() {
            return ZipResourceLoader.this.getURLContent(this.m_Name);
        }
    }
}

