/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JLinkButton;
import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.icons.EmptyIcon;
import com.l2fprod.common.swing.plaf.TaskPaneGroupUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicTaskPaneGroupUI
extends TaskPaneGroupUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected JTaskPaneGroup group;
    protected boolean mouseOver;
    protected PropertyChangeListener propertyListener;
    protected MouseInputListener mouseListener;
    protected boolean animationRunning = false;
    protected float animationStage = 0.0f;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTaskPaneGroupUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.group = (JTaskPaneGroup)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this.group.setLayout(new Layout(new PercentLayout(1, 2)));
        this.group.setOpaque(true);
        this.group.setBorder(new CompoundBorder(this.createPaneBorder(), BorderFactory.createEmptyBorder(10, 10, 0, 10)));
        LookAndFeel.installColorsAndFont(this.group, "TaskPaneGroup.background", "TaskPaneGroup.foreground", "TaskPaneGroup.font");
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyListener();
        this.group.addPropertyChangeListener(this.propertyListener);
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
    }

    protected void installKeyboardActions() {
        ActionMap map;
        InputMap inputMap = (InputMap)UIManager.get("TaskPaneGroup.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((map = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, map);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("toggleExpanded", new ToggleExpandedAction());
        return map;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        super.uninstallUI(c);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new ChangeListener();
    }

    protected boolean isInBorder(MouseEvent event) {
        return event.getY() < this.getTitleHeight();
    }

    protected int getTitleHeight() {
        return 25;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    public Component createAction(Action action) {
        JLinkButton button = new JLinkButton(action);
        button.setOpaque(false);
        button.setBorder(null);
        button.setBorderPainted(false);
        button.setFocusPainted(true);
        button.setForeground(UIManager.getColor("TaskPaneGroup.titleForeground"));
        return button;
    }

    protected void expandedStateChanged() {
        if (UIManager.getBoolean("TaskPaneGroup.animate") && !Beans.isDesignTime() && this.group.isShowing() && this.group.isVisible()) {
            AnimatorThread animator = new AnimatorThread(this.group.isExpanded());
            animator.start();
        } else {
            this.setSubComponentsVisible();
        }
    }

    protected void setSubComponentsVisible() {
        Component[] components = this.group.getComponents();
        boolean expanded = this.group.isExpanded();
        boolean componentHadFocus = false;
        int c = components.length;
        for (int i = 0; i < c; ++i) {
            components[i].setVisible(expanded);
            if (expanded || !components[i].hasFocus()) continue;
            componentHadFocus = true;
        }
        if (componentHadFocus) {
            this.group.requestFocus();
        }
    }

    public boolean isAnimating() {
        return this.animationRunning;
    }

    protected static int getTitleHeight(Component c) {
        return ((BasicTaskPaneGroupUI)((JTaskPaneGroup)c).getUI()).getTitleHeight();
    }

    protected static class PaneBorder
    implements Border {
        protected Color titleForeground = UIManager.getColor("TaskPaneGroup.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPaneGroup.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPaneGroup.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPaneGroup.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPaneGroup.titleBackgroundGradientEnd");

        public Insets getBorderInsets(Component c) {
            return new Insets(BasicTaskPaneGroupUI.getTitleHeight(c), 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        protected void paintBorder(JTaskPaneGroup group, Graphics g) {
            if (group.isExpanded() || ((BasicTaskPaneGroupUI)group.getUI()).isAnimating()) {
                if (group.isSpecial()) {
                    g.setColor(this.specialTitleBackground);
                } else {
                    g.setColor(this.titleBackgroundGradientStart);
                }
                g.drawRect(0, 0, group.getWidth() - 1, group.getHeight() - 1);
            }
        }

        protected void paintTitleBackground(JTaskPaneGroup group, Graphics g) {
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
            }
            g.fillRect(0, 0, group.getWidth(), BasicTaskPaneGroupUI.getTitleHeight(group) - 1);
        }

        protected void paintTitle(JTaskPaneGroup group, Graphics g, Color textColor, int x, int y, int width, int height) {
            JLabel label = new JLabel();
            label.setOpaque(false);
            label.setForeground(textColor);
            label.setFont(g.getFont());
            label.setIconTextGap(8);
            label.setText(group.getText());
            label.setIcon(group.getIcon() == null ? new EmptyIcon() : group.getIcon());
            g.translate(x, y);
            label.setBounds(0, 0, width, height);
            label.paint(g);
            g.translate(-x, -y);
        }

        protected void paintExpandedControls(JTaskPaneGroup group, Graphics g) {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JTaskPaneGroup group = (JTaskPaneGroup)c;
            this.paintBorder(group, g);
            this.paintTitleBackground(group, g);
            this.paintExpandedControls(group, g);
            Color paintColor = group.isSpecial() ? this.specialTitleForeground : this.titleForeground;
            if (group.hasFocus()) {
                g.setColor(paintColor);
                BasicGraphicsUtils.drawDashedRect(g, 3, 3, width - 6, BasicTaskPaneGroupUI.getTitleHeight(c) - 6);
            }
            this.paintTitle(group, g, paintColor, 3, 0, c.getWidth() - BasicTaskPaneGroupUI.getTitleHeight(c) - 3, BasicTaskPaneGroupUI.getTitleHeight(c));
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean up) {
            this.up = up;
        }

        public int getIconHeight() {
            return 3;
        }

        public int getIconWidth() {
            return 6;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.up) {
                g.drawLine(x + 3, y, x, y + 3);
                g.drawLine(x + 3, y, x + 6, y + 3);
            } else {
                g.drawLine(x, y, x + 3, y + 3);
                g.drawLine(x + 3, y + 3, x + 6, y);
            }
        }
    }

    protected static class Layout
    implements LayoutManager2 {
        private LayoutManager2 layout;

        public Layout(LayoutManager2 layout) {
            this.layout = layout;
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            this.layout.addLayoutComponent(comp, constraints);
        }

        public void addLayoutComponent(String name, Component comp) {
            this.layout.addLayoutComponent(name, comp);
        }

        public float getLayoutAlignmentX(Container target) {
            return this.layout.getLayoutAlignmentX(target);
        }

        public float getLayoutAlignmentY(Container target) {
            return this.layout.getLayoutAlignmentY(target);
        }

        public void invalidateLayout(Container target) {
            this.layout.invalidateLayout(target);
        }

        public void layoutContainer(Container parent) {
            this.layout.layoutContainer(parent);
            JTaskPaneGroup group = (JTaskPaneGroup)parent;
            BasicTaskPaneGroupUI ui = (BasicTaskPaneGroupUI)group.getUI();
            if (ui.animationRunning) {
                Component[] components = parent.getComponents();
                int c = components.length;
                for (int i = 0; i < c; ++i) {
                    components[i].setBounds(components[i].getX(), Math.max(BasicTaskPaneGroupUI.getTitleHeight(group), (int)(ui.animationStage * (float)components[i].getY())), components[i].getWidth(), (int)(ui.animationStage * (float)components[i].getHeight()));
                }
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            JTaskPaneGroup group = (JTaskPaneGroup)target;
            if (group.isExpanded()) {
                return this.layout.maximumLayoutSize(target);
            }
            return new Dimension(Integer.MAX_VALUE, ((BasicTaskPaneGroupUI)group.getUI()).getTitleHeight());
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size = this.layout.preferredLayoutSize(parent);
            Insets insets = parent.getInsets();
            JTaskPaneGroup group = (JTaskPaneGroup)parent;
            int titleWidth = BasicTaskPaneGroupUI.getTitleHeight(group);
            BasicTaskPaneGroupUI ui = (BasicTaskPaneGroupUI)group.getUI();
            FontMetrics metrics = parent.getToolkit().getFontMetrics(parent.getFont());
            if (metrics != null && group.getText() != null) {
                titleWidth += SwingUtilities.computeStringWidth(metrics, group.getText());
            }
            titleWidth += insets.left + insets.right;
            if (group.getIcon() != null) {
                titleWidth += group.getIcon().getIconWidth();
            }
            if (ui.animationRunning) {
                return new Dimension(Math.max(size.width, titleWidth), BasicTaskPaneGroupUI.getTitleHeight(group) + (int)((float)(size.height - BasicTaskPaneGroupUI.getTitleHeight(group)) * ui.animationStage));
            }
            if (group.isExpanded()) {
                return new Dimension(Math.max(size.width, titleWidth), size.height);
            }
            return new Dimension(Math.max(size.width, titleWidth), BasicTaskPaneGroupUI.getTitleHeight(group));
        }

        public void removeLayoutComponent(Component comp) {
            this.layout.removeLayoutComponent(comp);
        }
    }

    class ToggleExpandedAction
    extends AbstractAction {
        public ToggleExpandedAction() {
            super("toggleExpanded");
        }

        public void actionPerformed(ActionEvent e) {
            BasicTaskPaneGroupUI.this.group.setExpanded(!BasicTaskPaneGroupUI.this.group.isExpanded());
        }

        public boolean isEnabled() {
            return BasicTaskPaneGroupUI.this.group.isVisible();
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("expanded".equals(evt.getPropertyName())) {
                BasicTaskPaneGroupUI.this.expandedStateChanged();
                BasicTaskPaneGroupUI.this.group.revalidate();
                BasicTaskPaneGroupUI.this.group.repaint();
            } else {
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        public void mouseEntered(MouseEvent e) {
            if (BasicTaskPaneGroupUI.this.isInBorder(e)) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneGroupUI.this.mouseOver = false;
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            BasicTaskPaneGroupUI.this.mouseOver = false;
            BasicTaskPaneGroupUI.this.group.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (BasicTaskPaneGroupUI.this.isInBorder(e)) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneGroupUI.this.mouseOver = true;
                BasicTaskPaneGroupUI.this.group.repaint();
            } else {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
                BasicTaskPaneGroupUI.this.mouseOver = false;
                BasicTaskPaneGroupUI.this.group.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicTaskPaneGroupUI.this.isInBorder(e)) {
                BasicTaskPaneGroupUI.this.group.setExpanded(!BasicTaskPaneGroupUI.this.group.isExpanded());
            }
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        public void focusLost(FocusEvent e) {
            e.getComponent().repaint();
        }
    }

    class AnimatorThread
    extends Thread {
        private final boolean expanding;
        final float increment;

        public AnimatorThread(boolean targetState) {
            super("TaskPaneGroup-Animator");
            this.expanding = targetState;
            BasicTaskPaneGroupUI.this.animationRunning = true;
            if (this.expanding) {
                BasicTaskPaneGroupUI.this.animationStage = 0.0f;
                this.increment = 0.05f;
            } else {
                BasicTaskPaneGroupUI.this.animationStage = 1.0f;
                this.increment = -0.05f;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (BasicTaskPaneGroupUI.this.group.isExpanded()) {
                    BasicTaskPaneGroupUI.this.setSubComponentsVisible();
                }
                while (true) {
                    try {
                        AnimatorThread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    BasicTaskPaneGroupUI.this.animationStage += this.increment;
                    if (this.expanding && BasicTaskPaneGroupUI.this.animationStage >= 1.0f || !this.expanding && BasicTaskPaneGroupUI.this.animationStage <= 0.0f) break;
                    BasicTaskPaneGroupUI.this.group.revalidate();
                }
                Object var3_2 = null;
                BasicTaskPaneGroupUI.this.animationRunning = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                BasicTaskPaneGroupUI.this.animationRunning = false;
                BasicTaskPaneGroupUI.this.group.revalidate();
                BasicTaskPaneGroupUI.this.group.repaint();
                if (!BasicTaskPaneGroupUI.this.group.isExpanded()) {
                    BasicTaskPaneGroupUI.this.setSubComponentsVisible();
                }
                throw throwable;
            }
            BasicTaskPaneGroupUI.this.group.revalidate();
            BasicTaskPaneGroupUI.this.group.repaint();
            if (!BasicTaskPaneGroupUI.this.group.isExpanded()) {
                BasicTaskPaneGroupUI.this.setSubComponentsVisible();
            }
        }
    }
}

