/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class ComboBoxPropertyEditor
extends AbstractPropertyEditor {
    public ComboBoxPropertyEditor() {
        this.editor = new JComboBox(){

            public void setSelectedItem(Object anObject) {
                Object oldValue = this.getSelectedItem();
                super.setSelectedItem(anObject);
                ComboBoxPropertyEditor.this.firePropertyChange(oldValue, this.getSelectedItem());
            }
        };
        ((JComboBox)this.editor).setRenderer(new Renderer());
    }

    public Object getValue() {
        Object selected = ((JComboBox)this.editor).getSelectedItem();
        if (selected instanceof Value) {
            return ((Value)selected).value;
        }
        return selected;
    }

    public void setValue(Object value) {
        JComboBox combo = (JComboBox)this.editor;
        Object current = null;
        int index = -1;
        int c = combo.getModel().getSize();
        for (int i = 0; i < c; ++i) {
            current = combo.getModel().getElementAt(i);
            if (value != current && (current == null || !current.equals(value))) continue;
            index = i;
            break;
        }
        ((JComboBox)this.editor).setSelectedIndex(index);
    }

    public void setAvailableValues(Object[] values) {
        ((JComboBox)this.editor).setModel(new DefaultComboBoxModel<Object>(values));
    }

    public static final class Value {
        private Object value;
        private Object visualValue;

        public Value(Object value, Object visualValue) {
            this.value = value;
            this.visualValue = visualValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.value == o || this.value != null && this.value.equals(o);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }

    public static class Renderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Value) {
                return super.getListCellRendererComponent((JList<?>)list, ((Value)value).visualValue, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

