/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;

public class WinRegistryWrapper {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_ITEM_EXIST = 0;
    public static final int ERROR_ITEM_NOTEXIST = 9;
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_VALUE_NAME_LENGTH = 255;
    private static final int OPENED_KEY_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;

    private static native int[] RegOpenKey(int var0, byte[] var1, int var2);

    private static native int RegCloseKey(int var0);

    private static native int[] RegCreateKeyEx(int var0, byte[] var1);

    private static native int RegDeleteKey(int var0, byte[] var1);

    private static native int RegFlushKey(int var0);

    private static native byte[] RegQueryValueEx(int var0, byte[] var1);

    private static native int RegSetValueEx(int var0, byte[] var1, byte[] var2);

    private static native int RegDeleteValue(int var0, byte[] var1);

    private static native int[] RegQueryInfoKey(int var0);

    private static native byte[] RegEnumKeyEx(int var0, int var1, int var2);

    private static native byte[] RegEnumValue(int var0, int var1, int var2);

    private static native byte[] FindMimeFromData(byte[] var0, byte[] var1);

    private static native byte[] ExpandEnvironmentStrings(byte[] var0);

    private static byte[] stringToByteArray(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = 0;
        return byArray2;
    }

    private static String byteArrayToString(byte[] byArray) {
        String string;
        if (byArray != null && (string = new String(byArray)) != null) {
            return string.substring(0, string.length() - 1);
        }
        return null;
    }

    private WinRegistryWrapper() {
    }

    public static int WinRegCreateKeyEx(int n, String string) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegCreateKeyEx(n, byArray);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] == 0) {
            WinRegistryWrapper.RegCloseKey(nArray[0]);
        }
        return nArray[1];
    }

    public static int WinRegDeleteKey(int n, String string) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int n2 = WinRegistryWrapper.RegDeleteKey(n, byArray);
        if (n2 == 0) {
            return n2;
        }
        int n3 = WinRegistryWrapper.WinRegSubKeyExist(n, string);
        if (n3 == 9) {
            return n2;
        }
        String[] stringArray = WinRegistryWrapper.WinRegGetSubKeys(n, string, 255);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + "\\" + stringArray[i];
            if (string2 == null) continue;
            WinRegistryWrapper.WinRegDeleteKey(n, string2);
        }
        n2 = WinRegistryWrapper.RegDeleteKey(n, byArray);
        return n2;
    }

    public static int WinRegFlushKey(int n, String string) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131078);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n2 = WinRegistryWrapper.RegFlushKey(nArray[0]);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return n2;
    }

    public static String WinRegQueryValueEx(int n, String string, String string2) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray2 = WinRegistryWrapper.stringToByteArray(string2);
        byte[] byArray3 = WinRegistryWrapper.RegQueryValueEx(nArray[0], byArray2);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        if (byArray3 != null) {
            if (byArray3.length == 1 && byArray3[0] == 0 && string2.equals("")) {
                return null;
            }
            return WinRegistryWrapper.byteArrayToString(byArray3);
        }
        return null;
    }

    public static int WinRegSetValueEx(int n, String string, String string2, String string3) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 2);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] != 0) {
            return nArray[1];
        }
        byte[] byArray2 = WinRegistryWrapper.stringToByteArray(string2);
        byte[] byArray3 = WinRegistryWrapper.stringToByteArray(string3);
        int n2 = WinRegistryWrapper.RegSetValueEx(nArray[0], byArray2, byArray3);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return n2;
    }

    public static int WinRegDeleteValue(int n, String string, String string2) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131078);
        if (nArray == null) {
            return -1;
        }
        if (nArray[1] != 0) {
            return nArray[1];
        }
        byte[] byArray2 = WinRegistryWrapper.stringToByteArray(string2);
        int n2 = WinRegistryWrapper.RegDeleteValue(nArray[0], byArray2);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return n2;
    }

    public static int[] WinRegQueryInfoKey(int n, String string) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return nArray;
        }
        int[] nArray2 = WinRegistryWrapper.RegQueryInfoKey(nArray[0]);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return nArray2;
    }

    public static String WinRegEnumKeyEx(int n, String string, int n2, int n3) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray2 = WinRegistryWrapper.RegEnumKeyEx(nArray[0], n2, n3);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        if (byArray2 != null) {
            return WinRegistryWrapper.byteArrayToString(byArray2);
        }
        return null;
    }

    public static String WinRegEnumValue(int n, String string, int n2, int n3) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray2 = WinRegistryWrapper.RegEnumValue(nArray[0], n2, n3);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        if (byArray2 != null) {
            return WinRegistryWrapper.byteArrayToString(byArray2);
        }
        return null;
    }

    public static String[] WinRegGetSubKeys(int n, String string, int n2) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = WinRegistryWrapper.RegQueryInfoKey(nArray[0]);
        int n3 = nArray2[0];
        if (n3 == 0) {
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return null;
        }
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            byte[] byArray2 = WinRegistryWrapper.RegEnumKeyEx(nArray[0], i, n2);
            stringArray[i] = WinRegistryWrapper.byteArrayToString(byArray2);
        }
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return stringArray;
    }

    public static String[] WinRegGetValues(int n, String string, int n2) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = WinRegistryWrapper.RegQueryInfoKey(nArray[0]);
        int n3 = nArray2[2];
        if (n3 == 0) {
            WinRegistryWrapper.RegCloseKey(nArray[0]);
            return null;
        }
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            byte[] byArray2 = WinRegistryWrapper.RegEnumValue(nArray[0], i, n2);
            stringArray[i] = WinRegistryWrapper.byteArrayToString(byArray2);
        }
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return stringArray;
    }

    public static int WinRegSubKeyExist(int n, String string) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return 9;
        }
        if (nArray[1] != 0) {
            return 9;
        }
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        return 0;
    }

    public static int WinRegValueExist(int n, String string, String string2) {
        if (string.trim().equals("")) {
            return 9;
        }
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        int[] nArray = WinRegistryWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return 9;
        }
        if (nArray[1] != 0) {
            return 9;
        }
        byte[] byArray2 = WinRegistryWrapper.stringToByteArray(string2);
        byte[] byArray3 = WinRegistryWrapper.RegQueryValueEx(nArray[0], byArray2);
        WinRegistryWrapper.RegCloseKey(nArray[0]);
        if (byArray3 == null) {
            return 9;
        }
        if (byArray3.length == 1 && byArray3[0] == 0 && string2.equals("")) {
            return 9;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String WinFindMimeFromData(URL uRL) {
        String string = uRL.toString();
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        byte[] byArray2 = WinRegistryWrapper.FindMimeFromData(byArray, null);
        if (byArray2 != null) {
            return WinRegistryWrapper.byteArrayToString(byArray2);
        }
        byte[] byArray3 = new byte[256];
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(uRL.openStream());
            dataInputStream.read(byArray3, 0, 256);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            String string2 = null;
            return string2;
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        byArray2 = WinRegistryWrapper.FindMimeFromData(null, byArray3);
        if (byArray2 != null) {
            return WinRegistryWrapper.byteArrayToString(byArray2);
        }
        return null;
    }

    public static String WinExpandEnvironmentStrings(String string) {
        byte[] byArray = WinRegistryWrapper.stringToByteArray(string);
        byte[] byArray2 = WinRegistryWrapper.ExpandEnvironmentStrings(byArray);
        return WinRegistryWrapper.byteArrayToString(byArray2);
    }

    static {
        System.loadLibrary("deploy");
    }
}

