/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.FilePane;
import sun.swing.plaf.synth.SynthFileChooserUIImpl;
import sun.swing.plaf.synth.SynthUI;

public abstract class SynthFileChooserUI
extends BasicFileChooserUI
implements SynthUI {
    private JButton approveButton;
    private JButton cancelButton;
    private SynthStyle style;
    private SynthFileView fileView = new SynthFileView();
    private String cancelButtonText = null;
    private String cancelButtonToolTipText = null;
    private int cancelButtonMnemonic = 0;
    private Action fileNameCompletionAction = new FileNameCompletionAction();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private boolean readOnly;
    private String fileNameCompletionString;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthFileChooserUIImpl((JFileChooser)jComponent);
    }

    public SynthFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public SynthContext getContext(JComponent jComponent) {
        return new SynthContext(jComponent, Region.FILE_CHOOSER, this.style, this.getComponentState(jComponent));
    }

    protected SynthContext getContext(JComponent jComponent, int n2) {
        Region region = SynthLookAndFeel.getRegion(jComponent);
        return new SynthContext(jComponent, Region.FILE_CHOOSER, this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (jComponent.isEnabled()) {
            if (jComponent.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    private void updateStyle(JComponent jComponent) {
        SynthStyle synthStyle = SynthLookAndFeel.getStyleFactory().getStyle(jComponent, Region.FILE_CHOOSER);
        if (synthStyle != this.style) {
            if (this.style != null) {
                this.style.uninstallDefaults(this.getContext(jComponent, 1));
            }
            this.style = synthStyle;
            SynthContext synthContext = this.getContext(jComponent, 1);
            this.style.installDefaults(synthContext);
            Border border = jComponent.getBorder();
            if (border == null || border instanceof UIResource) {
                jComponent.setBorder(new UIBorder(this.style.getInsets(synthContext, null)));
            }
        }
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtilities.replaceUIActionMap(jComponent, this.createActionMap());
    }

    public void installComponents(JFileChooser jFileChooser) {
        SynthContext synthContext = this.getContext(jFileChooser, 1);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", jFileChooser.getLocale());
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setName("SynthFileChooser.cancelButton");
        this.cancelButton.setIcon(synthContext.getStyle().getIcon(synthContext, "FileChooser.cancelIcon"));
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.setName("SynthFileChooser.approveButton");
        this.approveButton.setIcon(synthContext.getStyle().getIcon(synthContext, "FileChooser.okIcon"));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", this.getCancelSelectionAction());
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        actionMapUIResource.put("fileNameCompletion", this.getFileNameCompletionAction());
        return actionMapUIResource;
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.updateStyle(jFileChooser);
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
        SynthContext synthContext = this.getContext(this.getFileChooser(), 1);
        this.style.uninstallDefaults(synthContext);
        this.style = null;
    }

    protected void installIcons(JFileChooser jFileChooser) {
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        if (jComponent.isOpaque()) {
            graphics.setColor(this.style.getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.style.getPainter(synthContext).paintFileChooserBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public abstract void setFileName(String var1);

    public abstract String getFileName();

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = this.getFileChooser().getCurrentDirectory();
        if (!this.readOnly && file != null) {
            this.getNewFolderAction().setEnabled(FilePane.canWrite(file));
        }
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.approveButton.setText(this.getApproveButtonText(this.getFileChooser()));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
        }
    }

    protected void doAncestorChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new SynthFCPropertyChangeListener();
    }

    private void updateFileNameCompletion() {
        if (this.fileNameCompletionString != null && this.fileNameCompletionString.equals(this.getFileName())) {
            File[] fileArray = this.getModel().getFiles().toArray(new File[0]);
            String string = this.getCommonStartString(fileArray);
            if (string != null && string.startsWith(this.fileNameCompletionString)) {
                this.setFileName(string);
            }
            this.fileNameCompletionString = null;
        }
    }

    private String getCommonStartString(File[] fileArray) {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (fileArray.length == 0) {
            return null;
        }
        while (true) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string3 = fileArray[i2].getName();
                if (i2 == 0) {
                    if (string3.length() == n2) {
                        return string;
                    }
                    string2 = string3.substring(0, n2 + 1);
                }
                if (string3.startsWith(string2)) continue;
                return string;
            }
            string = string2;
            ++n2;
        }
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && string.indexOf(42) >= 0 || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    public Action getFileNameCompletionAction() {
        return this.fileNameCompletionAction;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    protected JButton getCancelButton(JFileChooser jFileChooser) {
        return this.cancelButton;
    }

    public void clearIconCache() {
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            SynthFileChooserUI.this.updateFileNameCompletion();
        }
    }

    private class FileNameCompletionAction
    extends AbstractAction {
        protected FileNameCompletionAction() {
            super("fileNameCompletion");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = SynthFileChooserUI.this.getFileChooser();
            String string = SynthFileChooserUI.this.getFileName();
            if (string != null) {
                string = string.trim();
            }
            SynthFileChooserUI.this.resetGlobFilter();
            if (string == null || string.equals("") || jFileChooser.isMultiSelectionEnabled() && string.startsWith("\"")) {
                return;
            }
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (SynthFileChooserUI.this.globFilter == null) {
                SynthFileChooserUI.this.globFilter = new GlobFilter();
            }
            try {
                SynthFileChooserUI.this.globFilter.setPattern(!SynthFileChooserUI.isGlobPattern(string) ? string + "*" : string);
                if (!(fileFilter instanceof GlobFilter)) {
                    SynthFileChooserUI.this.actualFileFilter = fileFilter;
                }
                jFileChooser.setFileFilter(null);
                jFileChooser.setFileFilter(SynthFileChooserUI.this.globFilter);
                SynthFileChooserUI.this.fileNameCompletionString = string;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl2 = File.separatorChar == '\\';
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            this.globPattern = string;
            if (bl2) {
                int n3 = cArray.length;
                if (string.endsWith("*.*")) {
                    n3 -= 2;
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (cArray[i2] == '*') {
                        cArray2[n2++] = 46;
                    }
                    cArray2[n2++] = cArray[i2];
                }
            } else {
                block12: for (int i3 = 0; i3 < cArray.length; ++i3) {
                    switch (cArray[i3]) {
                        case '*': {
                            if (!bl3) {
                                cArray2[n2++] = 46;
                            }
                            cArray2[n2++] = 42;
                            continue block12;
                        }
                        case '?': {
                            cArray2[n2++] = bl3 ? 63 : 46;
                            continue block12;
                        }
                        case '[': {
                            bl3 = true;
                            cArray2[n2++] = cArray[i3];
                            if (i3 >= cArray.length - 1) continue block12;
                            switch (cArray[i3 + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n2++] = 94;
                                    ++i3;
                                    break;
                                }
                                case ']': {
                                    cArray2[n2++] = cArray[++i3];
                                }
                            }
                            continue block12;
                        }
                        case ']': {
                            cArray2[n2++] = cArray[i3];
                            bl3 = false;
                            continue block12;
                        }
                        case '\\': {
                            if (i3 == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n2++] = cArray[++i3];
                                continue block12;
                            }
                            cArray2[n2++] = 92;
                            if (i3 < cArray.length - 1 && "*?[]".indexOf(cArray[i3 + 1]) >= 0) {
                                cArray2[n2++] = cArray[++i3];
                                continue block12;
                            }
                            cArray2[n2++] = 92;
                            continue block12;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[i3])) {
                                cArray2[n2++] = 92;
                            }
                            cArray2[n2++] = cArray[i3];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n2), 2);
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }
    }

    private class SynthFCPropertyChangeListener
    implements PropertyChangeListener {
        private SynthFCPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("fileSelectionChanged")) {
                SynthFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
            } else if (string.equals("SelectedFileChangedProperty")) {
                SynthFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
            } else if (string.equals("SelectedFilesChangedProperty")) {
                SynthFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
            } else if (string.equals("directoryChanged")) {
                SynthFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
            } else if (string == "MultiSelectionEnabledChangedProperty") {
                SynthFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
            } else if (string == "AccessoryChangedProperty") {
                SynthFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
            } else if (string == "ApproveButtonTextChangedProperty" || string == "ApproveButtonToolTipTextChangedProperty" || string == "DialogTypeChangedProperty" || string == "ControlButtonsAreShownChangedProperty") {
                SynthFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    jFileChooser.applyComponentOrientation(componentOrientation);
                }
            } else if (string.equals("ancestor")) {
                SynthFileChooserUI.this.doAncestorChanged(propertyChangeEvent);
            }
        }
    }

    private class SynthFileView
    extends BasicFileChooserUI.BasicFileView {
        public SynthFileView() {
            this.iconCache = null;
        }

        public void clearIconCache() {
        }

        public Icon getCachedIcon(File file) {
            return null;
        }

        public void cacheIcon(File file, Icon icon) {
        }

        public Icon getIcon(File file) {
            return null;
        }
    }

    private class UIBorder
    extends AbstractBorder
    implements UIResource {
        private Insets _insets;

        UIBorder(Insets insets) {
            this._insets = insets != null ? new Insets(insets.top, insets.left, insets.bottom, insets.right) : null;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JComponent jComponent = (JComponent)component;
            SynthContext synthContext = SynthFileChooserUI.this.getContext(jComponent);
            SynthStyle synthStyle = synthContext.getStyle();
            if (synthStyle != null) {
                synthStyle.getPainter(synthContext).paintFileChooserBorder(synthContext, graphics, n2, n3, n4, n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            if (this._insets != null) {
                insets.top = this._insets.top;
                insets.bottom = this._insets.bottom;
                insets.left = this._insets.left;
                insets.right = this._insets.right;
            } else {
                insets.left = 0;
                insets.right = 0;
                insets.bottom = 0;
                insets.top = 0;
            }
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

