/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.util.ObjectIdentifier;

abstract class Krb5Token {
    public static final int TBD = -1;
    public static final int AP_REQ_ID = 256;
    public static final int AP_REP_ID = 512;
    public static final int ERR_ID = 768;
    public static final int MIC_ID = 257;
    public static final int WRAP_ID = 513;
    public static ObjectIdentifier OID;

    Krb5Token() {
    }

    public static final void writeLittleEndian(int n2, byte[] byArray) {
        Krb5Token.writeLittleEndian(n2, byArray, 0);
    }

    public static final void writeLittleEndian(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)n2;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 24);
    }

    public static final int readLittleEndian(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0) {
            n4 += (byArray[n2] & 0xFF) << n5;
            n5 += 8;
            ++n2;
            --n3;
        }
        return n4;
    }

    public static final void writeInt(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >>> 8);
        outputStream.write(n2);
    }

    public static final int writeInt(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        return n3;
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        return (0xFF & inputStream.read()) << 8 | 0xFF & inputStream.read();
    }

    public static final int readInt(byte[] byArray, int n2) {
        return (0xFF & byArray[n2]) << 8 | 0xFF & byArray[n2 + 1];
    }

    public static final void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        Krb5Token.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static final void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = inputStream.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException("Cannot read all " + n3 + " bytes needed to form this token!");
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    public static final void debug(String string) {
        System.err.print(string);
    }

    public static final String getHexBytes(byte[] byArray) {
        return Krb5Token.getHexBytes(byArray, 0, byArray.length);
    }

    public static final String getHexBytes(byte[] byArray, int n2) {
        return Krb5Token.getHexBytes(byArray, 0, n2);
    }

    public static final String getHexBytes(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            int n4 = byArray[i2] >> 4 & 0xF;
            int n5 = byArray[i2] & 0xF;
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(Integer.toHexString(n5));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String getTokenName(int n2) {
        String string = null;
        switch (n2) {
            case 256: 
            case 512: {
                string = "Context Establishment Token";
                break;
            }
            case 257: {
                string = "MIC Token";
                break;
            }
            case 513: {
                string = "Wrap Token";
                break;
            }
            default: {
                string = "Kerberos GSS-API Mechanism Token";
            }
        }
        return string;
    }

    static {
        try {
            OID = new ObjectIdentifier(Krb5MechFactory.GSS_KRB5_MECH_OID.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

