/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class BasicIconFactory
implements Serializable {
    private static Icon frame_icon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon createEmptyFrameIcon() {
        if (frame_icon == null) {
            frame_icon = new EmptyFrameIcon();
        }
        return frame_icon;
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl2 = buttonModel.isSelected();
            if (bl2) {
                graphics.drawLine(n2 + 7, n3 + 1, n2 + 7, n3 + 3);
                graphics.drawLine(n2 + 6, n3 + 2, n2 + 6, n3 + 4);
                graphics.drawLine(n2 + 5, n3 + 3, n2 + 5, n3 + 5);
                graphics.drawLine(n2 + 4, n3 + 4, n2 + 4, n3 + 6);
                graphics.drawLine(n2 + 3, n3 + 5, n2 + 3, n3 + 7);
                graphics.drawLine(n2 + 2, n3 + 4, n2 + 2, n3 + 6);
                graphics.drawLine(n2 + 1, n3 + 3, n2 + 1, n3 + 5);
            }
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class EmptyFrameIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        private EmptyFrameIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2 + this.getIconWidth(), n3 + this.getIconHeight() / 2);
            polygon.addPoint(n2, n3 + this.getIconHeight());
            graphics.fillPolygon(polygon);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemCheckIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillOval(n2 + 1, n3 + 1, this.getIconWidth(), this.getIconHeight());
            }
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 6;
        }
    }
}

