/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.AttributeHTML;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class MethodHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private ConstantHTML constant_html;
    private AttributeHTML attribute_html;

    MethodHTML(String string, String string2, Method[] methodArray, Field[] fieldArray, ConstantHTML constantHTML, AttributeHTML attributeHTML) throws IOException {
        int n2;
        this.class_name = string2;
        this.attribute_html = attributeHTML;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_methods.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        this.file.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
        for (n2 = 0; n2 < fieldArray.length; ++n2) {
            this.writeField(fieldArray[n2]);
        }
        this.file.println("</TABLE>");
        this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            this.writeMethod(methodArray[n2], n2);
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    private void writeField(Field field) throws IOException {
        int n2;
        String string = Utility.signatureToString(field.getSignature());
        String string2 = field.getName();
        String string3 = Utility.accessToString(field.getAccessFlags());
        string3 = Utility.replace(string3, " ", "&nbsp;");
        this.file.print("<TR><TD><FONT COLOR=\"#FF0000\">" + string3 + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(string) + "</TD><TD><A NAME=\"field" + string2 + "\">" + string2 + "</A></TD>");
        Attribute[] attributeArray = field.getAttributes();
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            this.attribute_html.writeAttribute(attributeArray[n2], string2 + "@" + n2);
        }
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            if (attributeArray[n2].getTag() != 1) continue;
            String string4 = ((ConstantValue)attributeArray[n2]).toString();
            this.file.print("<TD>= <A HREF=\"" + this.class_name + "_attributes.html#" + string2 + "@" + n2 + "\" TARGET=\"Attributes\">" + string4 + "</TD>\n");
            break;
        }
        this.file.println("</TR>");
    }

    private final void writeMethod(Method method, int n2) throws IOException {
        int n3;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributeArray = method.getAttributes();
        string4 = Utility.replace(string4, " ", "&nbsp;");
        String string5 = Class2HTML.toHTML(string3);
        this.file.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + n2 + ">" + string4 + "</A></FONT></TD>");
        this.file.print("<TD>" + Class2HTML.referenceType(string2) + "</TD><TD>" + "<A HREF=" + this.class_name + "_code.html#method" + n2 + " TARGET=Code>" + string5 + "</A></TD>\n<TD>(");
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            this.file.print(Class2HTML.referenceType(stringArray[n3]));
            if (n3 >= stringArray.length - 1) continue;
            this.file.print(", ");
        }
        this.file.print(")</TD></TR>");
        for (n3 = 0; n3 < attributeArray.length; ++n3) {
            int n4;
            Object[] objectArray;
            this.attribute_html.writeAttribute(attributeArray[n3], "method" + n2 + "@" + n3, n2);
            byte by = attributeArray[n3].getTag();
            if (by == 3) {
                this.file.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                objectArray = ((ExceptionTable)attributeArray[n3]).getExceptionIndexTable();
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    this.file.print(this.constant_html.referenceConstant((int)objectArray[n4]));
                    if (n4 >= objectArray.length - 1) continue;
                    this.file.print(", ");
                }
                this.file.println("</TD></TR>");
                continue;
            }
            if (by != 2) continue;
            objectArray = ((Code)attributeArray[n3]).getAttributes();
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                this.attribute_html.writeAttribute(objectArray[n4], "method" + n2 + "@" + n3 + "@" + n4, n2);
            }
        }
    }
}

