/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import sun.misc.SharedSecrets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationType {
    private final Map<String, Class> memberTypes = new HashMap<String, Class>();
    private final Map<String, Object> memberDefaults = new HashMap<String, Object>();
    private final Map<String, Method> members = new HashMap<String, Method>();
    private RetentionPolicy retention = RetentionPolicy.RUNTIME;
    private boolean inherited = false;

    public static synchronized AnnotationType getInstance(Class clazz) {
        AnnotationType annotationType = SharedSecrets.getJavaLangAccess().getAnnotationType(clazz);
        if (annotationType == null) {
            annotationType = new AnnotationType(clazz);
        }
        return annotationType;
    }

    private AnnotationType(Class<?> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type");
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (Method method : methodArray) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException(method + " has params");
            }
            String string = method.getName();
            Class<?> clazz2 = method.getReturnType();
            this.memberTypes.put(string, AnnotationType.invocationHandlerReturnType(clazz2));
            this.members.put(string, method);
            Object object = method.getDefaultValue();
            if (object != null) {
                this.memberDefaults.put(string, object);
            }
            this.members.put(string, method);
        }
        SharedSecrets.getJavaLangAccess().setAnnotationType(clazz, this);
        if (clazz != Retention.class && clazz != Inherited.class) {
            Retention retention = clazz.getAnnotation(Retention.class);
            this.retention = retention == null ? RetentionPolicy.CLASS : retention.value();
            this.inherited = clazz.isAnnotationPresent(Inherited.class);
        }
    }

    public static Class invocationHandlerReturnType(Class clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    public Map<String, Class> memberTypes() {
        return this.memberTypes;
    }

    public Map<String, Method> members() {
        return this.members;
    }

    public Map<String, Object> memberDefaults() {
        return this.memberDefaults;
    }

    public RetentionPolicy retention() {
        return this.retention;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Annotation Type:\n");
        stringBuffer.append("   Member types: " + this.memberTypes + "\n");
        stringBuffer.append("   Member defaults: " + this.memberDefaults + "\n");
        stringBuffer.append("   Retention policy: " + (Object)((Object)this.retention) + "\n");
        stringBuffer.append("   Inherited: " + this.inherited);
        return stringBuffer.toString();
    }
}

