/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import sun.management.MXBeanSupport;
import sun.management.ManagementFactory;
import sun.management.VMManagement;

class ThreadImpl
extends MXBeanSupport
implements ThreadMXBean {
    private final VMManagement jvm;
    private boolean contentionMonitoringEnabled = false;
    private boolean cpuTimeEnabled;

    ThreadImpl(VMManagement vMManagement) {
        super(ThreadMXBean.class);
        this.jvm = vMManagement;
        this.cpuTimeEnabled = this.jvm.isThreadCpuTimeEnabled();
    }

    public int getThreadCount() {
        return this.jvm.getLiveThreadCount();
    }

    public int getPeakThreadCount() {
        return this.jvm.getPeakThreadCount();
    }

    public long getTotalStartedThreadCount() {
        return this.jvm.getTotalThreadCount();
    }

    public int getDaemonThreadCount() {
        return this.jvm.getDaemonThreadCount();
    }

    public boolean isThreadContentionMonitoringSupported() {
        return this.jvm.isThreadContentionMonitoringSupported();
    }

    public synchronized boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported.");
        }
        return this.contentionMonitoringEnabled;
    }

    public boolean isThreadCpuTimeSupported() {
        return this.jvm.isOtherThreadCpuTimeSupported();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        return this.jvm.isCurrentThreadCpuTimeSupported();
    }

    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    public long[] getAllThreadIds() {
        ManagementFactory.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.getThreads();
        int n2 = threadArray.length;
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Thread thread = threadArray[i2];
            lArray[i2] = thread.getId();
        }
        return lArray;
    }

    public ThreadInfo getThreadInfo(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l2);
        }
        long[] lArray = new long[]{l2};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, 0);
        return threadInfoArray[0];
    }

    public ThreadInfo getThreadInfo(long l2, int n2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l2);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n2);
        }
        long[] lArray = new long[]{l2};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, n2);
        return threadInfoArray[0];
    }

    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] lArray, int n2) {
        if (lArray == null) {
            throw new NullPointerException("Null ids parameter.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n2);
        }
        ManagementFactory.checkMonitorAccess();
        ThreadInfo[] threadInfoArray = new ThreadInfo[lArray.length];
        if (n2 == Integer.MAX_VALUE) {
            ThreadImpl.getThreadInfo0(lArray, -1, threadInfoArray);
        } else {
            ThreadImpl.getThreadInfo0(lArray, n2, threadInfoArray);
        }
        return threadInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadContentionMonitoringEnabled(boolean bl2) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.contentionMonitoringEnabled != bl2) {
                if (bl2) {
                    ThreadImpl.resetContentionTimes0(0L);
                }
                ThreadImpl.setThreadContentionMonitoringEnabled0(bl2);
                this.contentionMonitoringEnabled = bl2;
            }
        }
    }

    public long getCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return ThreadImpl.getThreadTotalCpuTime0(0L);
    }

    public long getThreadCpuTime(long l2) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU Time Measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported() && l2 != Thread.currentThread().getId()) {
            throw new UnsupportedOperationException("Thread CPU Time Measurement is only supported for the current thread.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l2);
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        if (l2 == Thread.currentThread().getId()) {
            return ThreadImpl.getThreadTotalCpuTime0(0L);
        }
        return ThreadImpl.getThreadTotalCpuTime0(l2);
    }

    public long getCurrentThreadUserTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return ThreadImpl.getThreadUserCpuTime0(0L);
    }

    public long getThreadUserTime(long l2) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported() && l2 != Thread.currentThread().getId()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is only supported for the current thread.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l2);
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        if (l2 == Thread.currentThread().getId()) {
            return ThreadImpl.getThreadUserCpuTime0(0L);
        }
        return ThreadImpl.getThreadUserCpuTime0(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCpuTimeEnabled(boolean bl2) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.cpuTimeEnabled != bl2) {
                ThreadImpl.setThreadCpuTimeEnabled0(bl2);
                this.cpuTimeEnabled = bl2;
            }
        }
    }

    public long[] findMonitorDeadlockedThreads() {
        ManagementFactory.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findMonitorDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i2 = 0; i2 < threadArray.length; ++i2) {
            Thread thread = threadArray[i2];
            lArray[i2] = thread.getId();
        }
        return lArray;
    }

    public void resetPeakThreadCount() {
        ManagementFactory.checkControlAccess();
        ThreadImpl.resetPeakThreadCount0();
    }

    private static native Thread[] getThreads();

    private static native void getThreadInfo0(long[] var0, int var1, ThreadInfo[] var2);

    private static native long getThreadTotalCpuTime0(long var0);

    private static native long getThreadUserCpuTime0(long var0);

    private static native void setThreadCpuTimeEnabled0(boolean var0);

    private static native void setThreadContentionMonitoringEnabled0(boolean var0);

    private static native Thread[] findMonitorDeadlockedThreads0();

    private static native void resetPeakThreadCount0();

    private static native void resetContentionTimes0(long var0);
}

