/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.management.HotspotThreadMBean;
import sun.management.VMManagement;

class HotspotThread
implements HotspotThreadMBean {
    private VMManagement jvm;
    private static final String JAVA_THREADS = "java.threads.";
    private static final String COM_SUN_THREADS = "com.sun.threads.";
    private static final String SUN_THREADS = "sun.threads.";
    private static final String THREADS_COUNTER_NAME_PATTERN = "java.threads.|com.sun.threads.|sun.threads.";

    HotspotThread(VMManagement vMManagement) {
        this.jvm = vMManagement;
    }

    public native int getInternalThreadCount();

    public Map getInternalThreadCpuTimes() {
        int n2 = this.getInternalThreadCount();
        if (n2 == 0) {
            return Collections.EMPTY_MAP;
        }
        String[] stringArray = new String[n2];
        long[] lArray = new long[n2];
        int n3 = this.getInternalThreadTimes0(stringArray, lArray);
        HashMap<String, Long> hashMap = new HashMap<String, Long>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            hashMap.put(stringArray[i2], new Long(lArray[i2]));
        }
        return hashMap;
    }

    public native int getInternalThreadTimes0(String[] var1, long[] var2);

    public List getInternalThreadingCounters() {
        return this.jvm.getInternalCounters(THREADS_COUNTER_NAME_PATTERN);
    }
}

