/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPlatform;

public class JdbcOdbcBoundCol
extends JdbcOdbcObject {
    protected int type = 9999;
    protected int len = -1;
    protected JdbcOdbcInputStream inputStream;
    protected boolean isRenamed = false;
    protected String aliasName = null;
    protected int rowSetSize;
    protected Object colObj;
    protected Object[] columnWiseData;
    protected byte[] columnWiseLength;
    protected byte[] binaryData;
    protected int streamType;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    protected long pA1 = 0L;
    protected long pA2 = 0L;
    protected long pB1 = 0L;
    protected long pB2 = 0L;
    protected long pC1 = 0L;
    protected long pC2 = 0L;
    protected long pS1 = 0L;
    protected long pS2 = 0L;

    public void setInputStream(JdbcOdbcInputStream jdbcOdbcInputStream) {
        this.inputStream = jdbcOdbcInputStream;
    }

    public void closeInputStream() {
        if (this.inputStream != null) {
            this.inputStream.invalidate();
            this.inputStream = null;
        }
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public int getType() {
        return this.type;
    }

    public void setLength(int n2) {
        this.len = n2;
    }

    public int getLength() {
        return this.len;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
        this.isRenamed = true;
    }

    public String mapAliasName(String string) {
        if (this.isRenamed) {
            return this.aliasName;
        }
        return string;
    }

    public void setColumnValue(Object object, int n2) {
        try {
            if (this.type == -1 || this.type == -4) {
                if ((InputStream)object != null) {
                    this.setInputStream((JdbcOdbcInputStream)object);
                } else {
                    this.colObj = object;
                }
            } else {
                this.colObj = object;
            }
            this.setLength(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getColumnValue() {
        if (this.type == -1 || this.type == -4) {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            return this.colObj;
        }
        return this.colObj;
    }

    public JdbcOdbcInputStream getInputStream() {
        return this.inputStream;
    }

    public void initStagingArea(int n2) {
        this.rowSetSize = n2;
        this.columnWiseData = new Object[this.rowSetSize + 1];
        this.columnWiseLength = new byte[(this.rowSetSize + 1) * JdbcOdbcPlatform.getLengthBufferSize()];
        byte[] byArray = JdbcOdbcPlatform.convertIntToByteArray(-6);
        for (int i2 = 0; i2 < (this.rowSetSize + 1) * byArray.length; i2 += byArray.length) {
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                this.columnWiseLength[i2 + i3] = byArray[i3];
            }
        }
    }

    public void resetColumnToIgnoreData() {
        byte[] byArray = JdbcOdbcPlatform.convertIntToByteArray(-6);
        for (int i2 = 0; i2 < (this.rowSetSize + 1) * byArray.length; i2 += byArray.length) {
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                this.columnWiseLength[i2 + i3] = byArray[i3];
            }
        }
    }

    public void setRowValues(int n2, Object object, int n3) {
        int n4;
        this.columnWiseData[n2] = object;
        byte[] byArray = JdbcOdbcPlatform.convertIntToByteArray(n3);
        for (int i2 = n4 = n2 * byArray.length; i2 < n4 + byArray.length; ++i2) {
            this.columnWiseLength[i2] = byArray[i2 - n4];
        }
    }

    public Object getRowValue(int n2) {
        return this.columnWiseData[n2];
    }

    public int getRowLenInd(int n2) {
        return this.columnWiseLength[n2];
    }

    public Object[] getRowValues() {
        return this.columnWiseData;
    }

    public byte[] getRowLengths() {
        return this.columnWiseLength;
    }

    public byte[] allocBindDataBuffer(int n2) {
        this.binaryData = new byte[n2];
        return this.binaryData;
    }

    public void setStreamType(int n2) {
        this.streamType = n2;
    }

    public int getStreamType() {
        return this.streamType;
    }
}

