/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.util.Hashtable;
import sun.font.CharToGlyphMapper;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;

public abstract class PhysicalStrike
extends FontStrike {
    static final long INTMASK = 0xFFFFFFFFL;
    private PhysicalFont physicalFont;
    protected CharToGlyphMapper mapper;
    protected long pScalerContext;
    protected long[] longGlyphImages;
    protected int[] intGlyphImages;
    Hashtable glyphPointMapCache;
    protected static final int MAXADVANCECACHESIZE = 1000;
    protected boolean getImageWithAdvance;
    protected static final int complexTX = 124;

    PhysicalStrike(PhysicalFont physicalFont, FontStrikeDesc fontStrikeDesc) {
        this.physicalFont = physicalFont;
        this.desc = fontStrikeDesc;
    }

    protected PhysicalStrike() {
    }

    public int getNumGlyphs() {
        return this.physicalFont.getNumGlyphs();
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.physicalFont.getFontMetrics(this.pScalerContext);
        }
        return this.strikeMetrics;
    }

    float getCodePointAdvance(int n2) {
        return this.getGlyphAdvance(this.physicalFont.getMapper().charToGlyph(n2));
    }

    Point2D.Float getCharMetrics(char c2) {
        return this.getGlyphMetrics(this.physicalFont.getMapper().charToGlyph(c2));
    }

    int getSlot0GlyphImagePtrs(int[] nArray, long[] lArray, int n2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point2D.Float getGlyphPoint(int n2, int n3) {
        Point2D.Float float_ = null;
        Integer n4 = new Integer(n2 << 16 | n3);
        if (this.glyphPointMapCache == null) {
            PhysicalStrike physicalStrike = this;
            synchronized (physicalStrike) {
                if (this.glyphPointMapCache == null) {
                    this.glyphPointMapCache = new Hashtable();
                }
            }
        } else {
            float_ = (Point2D.Float)this.glyphPointMapCache.get(n4);
        }
        if (float_ == null) {
            float_ = this.physicalFont.getGlyphPoint(this.pScalerContext, n2, n3);
            this.adjustPoint(float_);
            this.glyphPointMapCache.put(n4, float_);
        }
        return float_;
    }

    protected void adjustPoint(Point2D.Float float_) {
    }
}

