/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Hashtable;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.security.action.LoadLibraryAction;

public class JPEGImageDecoder
extends ImageDecoder {
    private static ColorModel RGBcolormodel;
    private static ColorModel ARGBcolormodel;
    private static ColorModel Graycolormodel;
    private static final Class InputStreamClass;
    private ColorModel colormodel;
    Hashtable props = new Hashtable();
    private static final int hintflags = 22;

    private static native void initIDs(Class var0);

    private native void readImage(InputStream var1, byte[] var2) throws ImageFormatException, IOException;

    public JPEGImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    public boolean sendHeaderInfo(int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
        this.setDimensions(n2, n3);
        this.setProperties(this.props);
        this.colormodel = bl2 ? Graycolormodel : (bl3 ? ARGBcolormodel : RGBcolormodel);
        this.setColorModel(this.colormodel);
        int n4 = 22;
        if (!bl4) {
            n4 |= 8;
        }
        this.setHints(22);
        this.headerComplete();
        return true;
    }

    public boolean sendPixels(int[] nArray, int n2) {
        int n3 = this.setPixels(0, n2, nArray.length, 1, this.colormodel, nArray, 0, nArray.length);
        if (n3 <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    public boolean sendPixels(byte[] byArray, int n2) {
        int n3 = this.setPixels(0, n2, byArray.length, 1, this.colormodel, byArray, 0, byArray.length);
        if (n3 <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readImage(this.input, new byte[1024]);
            if (!this.aborted) {
                this.imageComplete(3, true);
            }
        }
        catch (IOException iOException) {
            if (!this.aborted) {
                throw iOException;
            }
        }
        finally {
            this.close();
        }
    }

    static {
        InputStreamClass = InputStream.class;
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        JPEGImageDecoder.initIDs(InputStreamClass);
        RGBcolormodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        ARGBcolormodel = ColorModel.getRGBdefault();
        byte[] byArray = new byte[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            byArray[i2] = (byte)i2;
        }
        Graycolormodel = new IndexColorModel(8, 256, byArray, byArray, byArray);
    }
}

