/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.xpath.XPathFactory;

class XPathFactoryFinder {
    private static boolean debug = false;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public XPathFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == Thread.currentThread().getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        XPathFactory xPathFactory = this._newFactory(string);
        if (xPathFactory != null) {
            XPathFactoryFinder.debugPrintln("factory '" + xPathFactory.getClass().getName() + "' was found for " + string);
        } else {
            XPathFactoryFinder.debugPrintln("unable to find a factory for " + string);
        }
        return xPathFactory;
    }

    private XPathFactory _newFactory(String string) {
        Object object;
        XPathFactory xPathFactory;
        Object object2;
        block15: {
            String string2;
            block14: {
                string2 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    XPathFactoryFinder.debugPrintln("Looking up system property '" + string2 + "'");
                    object2 = System.getProperty(string2);
                    if (object2 != null) {
                        XPathFactoryFinder.debugPrintln("The value is '" + (String)object2 + "'");
                        xPathFactory = this.createInstance((String)object2);
                        if (xPathFactory != null) {
                            return xPathFactory;
                        }
                    } else {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable throwable) {
                    if (!debug) break block14;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + string2 + "'");
                    throwable.printStackTrace();
                }
            }
            try {
                object2 = System.getProperty("java.home");
                object = (String)object2 + File.separator + "lib" + File.separator + "jaxp.properties";
                File file = new File((String)object);
                if (file.exists()) {
                    xPathFactory = this.loadFromProperty(string2, file.getAbsolutePath(), new FileInputStream(file));
                    if (xPathFactory != null) {
                        return xPathFactory;
                    }
                } else {
                    XPathFactoryFinder.debugPrintln("Tried to read " + file.getAbsolutePath() + ", but it doesn't exist.");
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block15;
                XPathFactoryFinder.debugPrintln("failed to read $java.home/lib/jaxp.properties");
                throwable.printStackTrace();
            }
        }
        object2 = this.createServiceFileIterator();
        while (object2.hasNext()) {
            object = (URL)object2.next();
            XPathFactoryFinder.debugPrintln("looking into " + object);
            try {
                xPathFactory = this.loadFromProperty(string, ((URL)object).toExternalForm(), ((URL)object).openStream());
                if (xPathFactory == null) continue;
                return xPathFactory;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + object);
                iOException.printStackTrace();
            }
        }
        if (string.equals("http://java.sun.com/jaxp/xpath/dom")) {
            XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            return this.createInstance("com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl");
        }
        XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private XPathFactory createInstance(String string) {
        block4: {
            try {
                Object obj;
                XPathFactoryFinder.debugPrintln("instanciating " + string);
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(string) : Class.forName(string);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("loaded it from " + XPathFactoryFinder.which(clazz));
                }
                if ((obj = clazz.newInstance()) instanceof XPathFactory) {
                    return (XPathFactory)obj;
                }
                XPathFactoryFinder.debugPrintln(string + " is not assignable to " + SERVICE_CLASS.getName());
            }
            catch (Throwable throwable) {
                XPathFactoryFinder.debugPrintln("failed to instanciate " + string);
                if (!debug) break block4;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private XPathFactory loadFromProperty(String string, String string2, InputStream inputStream) throws IOException {
        XPathFactoryFinder.debugPrintln("Reading " + string2);
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            XPathFactoryFinder.debugPrintln("found " + string + " = " + string3);
            return this.createInstance(string3);
        }
        XPathFactoryFinder.debugPrintln(string + " is not in the property file");
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                protected Object value() {
                    return ClassLoader.getSystemResource(SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration<URL> enumeration = this.classLoader.getResources(SERVICE_ID);
            if (!enumeration.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    return enumeration.nextElement();
                }
            };
        }
        catch (IOException iOException) {
            XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
            if (debug) {
                iOException.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string, ClassLoader classLoader) {
        URL uRL;
        String string2 = string.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = classLoader.getResource(string2)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            debug = false;
        }
        SERVICE_CLASS = XPathFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

