/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthScrollPaneUI
extends BasicScrollPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthScrollPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthScrollPaneUI();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintScrollPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintScrollPaneBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        this.updateStyle(jScrollPane);
    }

    private void updateStyle(JScrollPane jScrollPane) {
        SynthContext synthContext = this.getContext(jScrollPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Border border = this.scrollpane.getViewportBorder();
            if (border == null || border instanceof UIResource) {
                this.scrollpane.setViewportBorder(new ViewportBorder(synthContext));
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions(jScrollPane);
                this.installKeyboardActions(jScrollPane);
            }
        }
        synthContext.dispose();
    }

    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        jScrollPane.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        SynthContext synthContext = this.getContext(jScrollPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        jComponent.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this.scrollpane);
        }
    }

    private class ViewportBorder
    extends AbstractBorder
    implements UIResource {
        private Insets insets;

        ViewportBorder(SynthContext synthContext) {
            this.insets = (Insets)synthContext.getStyle().get(synthContext, "ScrollPane.viewportBorderInsets");
            if (this.insets == null) {
                this.insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JComponent jComponent = (JComponent)component;
            SynthContext synthContext = SynthScrollPaneUI.this.getContext(jComponent);
            SynthStyle synthStyle = synthContext.getStyle();
            if (synthStyle == null) {
                assert (false) : "SynthBorder is being used outside after the  UI has been uninstalled";
                return;
            }
            synthContext.getPainter().paintViewportBorder(synthContext, graphics, n2, n3, n4, n5);
            synthContext.dispose();
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
            insets.left = this.insets.left;
            insets.right = this.insets.left;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

