/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -1662519690087375313L;

    public SerialClob(char[] cArray) throws SerialException, SQLException {
        this.len = cArray.length;
        this.buf = new char[(int)this.len];
        int n2 = 0;
        while ((long)n2 < this.len) {
            this.buf[n2] = cArray[n2];
            ++n2;
        }
        this.origLen = this.len;
    }

    public SerialClob(Clob clob) throws SerialException, SQLException {
        if (clob == null) {
            throw new SQLException("Cannot instantiate a SerialClob object with a null Clob object");
        }
        this.len = clob.length();
        this.clob = clob;
        this.buf = new char[(int)this.len];
        int n2 = 0;
        int n3 = 0;
        if (clob.getCharacterStream() == null || clob.getAsciiStream() == null) {
            throw new SQLException("Invalid Clob object. Calls to getCharacterStream or getAsciiStream return null which cannot be serialized.");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
            do {
                n2 = bufferedReader.read(this.buf, n3, (int)(this.len - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            throw new SerialException("SerialClob: " + iOException.getMessage());
        }
        this.origLen = this.len;
    }

    public long length() throws SerialException {
        return this.len;
    }

    public Reader getCharacterStream() throws SerialException {
        return new CharArrayReader(this.buf);
    }

    public InputStream getAsciiStream() throws SerialException, SQLException {
        if (this.clob != null) {
            return this.clob.getAsciiStream();
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a the CLOB value as an ascii stream, unless instantiated with a fully implemented Clob object.");
    }

    public String getSubString(long l2, int n2) throws SerialException {
        if (l2 < 1L || l2 > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if (l2 - 1L + (long)n2 > this.length()) {
            throw new SerialException("Invalid position and substring length");
        }
        try {
            return new String(this.buf, (int)l2 - 1, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SerialException("StringIndexOutOfBoundsException: " + stringIndexOutOfBoundsException.getMessage());
        }
    }

    public long position(String string, long l2) throws SerialException, SQLException {
        if (l2 < 1L || l2 > this.len) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n2 = (int)l2 - 1;
        int n3 = 0;
        long l3 = cArray.length;
        while ((long)n2 < this.len) {
            if (cArray[n3] == this.buf[n2]) {
                if ((long)(n3 + 1) == l3) {
                    return (long)(n2 + 1) - (l3 - 1L);
                }
                ++n3;
                ++n2;
                continue;
            }
            if (cArray[n3] == this.buf[n2]) continue;
            ++n2;
        }
        return -1L;
    }

    public long position(Clob clob, long l2) throws SerialException, SQLException {
        char[] cArray = null;
        try {
            Reader reader = clob.getCharacterStream();
            cArray = new char[(int)clob.length()];
            reader.read(cArray);
        }
        catch (IOException iOException) {
            throw new SerialException("Error streaming Clob search data");
        }
        return this.position(new String(cArray), l2);
    }

    public int setString(long l2, String string) throws SerialException {
        return this.setString(l2, string, 0, string.length());
    }

    public int setString(long l2, String string, int n2, int n3) throws SerialException {
        int n4;
        String string2 = string.substring(n2);
        char[] cArray = string2.toCharArray();
        if (n2 < 0 || n2 > string.length()) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (l2 < 1L || l2 > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)n3 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (n3 + n2 > string.length()) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset  and length that is greater that the Blob buffer");
        }
        --l2;
        for (n4 = 0; n4 < n3 || n2 + n4 + 1 < string.length() - n2; ++n4) {
            this.buf[(int)l2 + n4] = cArray[n2 + n4];
        }
        return n4;
    }

    public OutputStream setAsciiStream(long l2) throws SerialException, SQLException {
        if (this.clob.setAsciiStream(l2) != null) {
            return this.clob.setAsciiStream(l2);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable ascii stream\n unless instantiated with a Clob object that has a setAsciiStream() implementation");
    }

    public Writer setCharacterStream(long l2) throws SerialException, SQLException {
        if (this.clob.setCharacterStream(l2) != null) {
            return this.clob.setCharacterStream(l2);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable character stream\n unless instantiated with a Clob object that has a setCharacterStream implementation");
    }

    public void truncate(long l2) throws SerialException {
        if (l2 > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = l2;
        this.buf = this.len == 0L ? new char[0] : this.getSubString(1L, (int)this.len).toCharArray();
    }
}

