/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRowSet
implements Serializable,
Cloneable {
    public static final int UNICODE_STREAM_PARAM = 0;
    public static final int BINARY_STREAM_PARAM = 1;
    public static final int ASCII_STREAM_PARAM = 2;
    protected InputStream binaryStream;
    protected InputStream unicodeStream;
    protected InputStream asciiStream;
    protected Reader charStream;
    private String command;
    private String URL;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rowSetType = 1004;
    private boolean showDeleted = false;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int concurrency = 1008;
    private boolean readOnly;
    private boolean escapeProcessing;
    private int isolation;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    private Map map;
    private Vector listeners = new Vector();
    private Hashtable params;
    static final long serialVersionUID = 4886719666485113312L;

    protected void initParams() {
        this.params = new Hashtable();
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    private void checkforRowSetInterface() throws SQLException {
        if (!(this instanceof RowSet)) {
            throw new SQLException("The class extending abstract class BaseRowSet must implement javax.sql.RowSet or one of it's sub-interfaces.");
        }
    }

    protected void notifyCursorMoved() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
            }
        }
    }

    protected void notifyRowChanged() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) throws SQLException {
        if (string == null) {
            this.command = null;
        } else {
            if (string.length() == 0) {
                throw new SQLException("Invalid command string detected. Cannot be of length less than 0");
            }
            if (this.params == null) {
                throw new SQLException("Set initParams() before setCommand");
            }
            this.params.clear();
            this.command = new String(string);
        }
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public void setUrl(String string) throws SQLException {
        if (string == null) {
            string = null;
        } else {
            if (string.length() < 1) {
                throw new SQLException("Invalid url string detected. Cannot be of length less than 1");
            }
            this.URL = new String(string);
        }
        this.dataSource = null;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String string) throws SQLException {
        if (string == null) {
            this.dataSource = null;
        } else {
            if (string.equals("")) {
                throw new SQLException("DataSource name cannot be empty string");
            }
            this.dataSource = new String(string);
        }
        this.URL = null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string == null ? null : new String(string);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string == null ? null : new String(string);
    }

    public void setType(int n2) throws SQLException {
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new SQLException("Invalid type of RowSet set. Must be either ResultSet.TYPE_FORWARD_ONLY or ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_SCROLL_SENSITIVE.");
        }
        this.rowSetType = n2;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public void setConcurrency(int n2) throws SQLException {
        if (n2 != 1007 && n2 != 1008) {
            throw new SQLException("Invalid concurrency set. Must be either ResultSet.CONCUR_READ_ONLY or ResultSet.CONCUR_UPDATABLE.");
        }
        this.concurrency = n2;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        if (n2 != 0 && n2 != 2 && n2 != 1 && n2 != 4 && n2 != 8) {
            throw new SQLException("Invalid transaction isolation set. Must be either Connection.TRANSACTION_NONE or Connection.TRANSACTION_READ_UNCOMMITTED or Connection.TRANSACTION_READ_COMMITTED or Connection.RRANSACTION_REPEATABLE_READ or Connection.TRANSACTION_SERIALIZABLE");
        }
        this.isolation = n2;
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.map;
    }

    public void setTypeMap(Map<String, Class<?>> map) {
        this.map = map;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Invalid max field size set. Cannot be of value: " + n2);
        }
        this.maxFieldSize = n2;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Invalid max row size set. Cannot be of value: " + n2);
        }
        if (n2 < this.getFetchSize()) {
            throw new SQLException("Invalid max row size set. Cannot be less than the fetchSize.");
        }
        this.maxRows = n2;
    }

    public void setEscapeProcessing(boolean bl2) throws SQLException {
        this.escapeProcessing = bl2;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Invalid query timeout value set. Cannot be of value: " + n2);
        }
        this.queryTimeout = n2;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean bl2) throws SQLException {
        this.showDeleted = bl2;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public void setFetchDirection(int n2) throws SQLException {
        if (this.getType() == 1003 && n2 != 1000 || n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw new SQLException("Invalid Fetch Direction");
        }
        this.fetchDir = n2;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (this.getMaxRows() == 0 && n2 >= 0) {
            this.fetchSize = n2;
            return;
        }
        if (n2 < 0 || n2 > this.getMaxRows()) {
            throw new SQLException("Invalid fetch size set. Cannot be of value: " + n2);
        }
        this.fetchSize = n2;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    private void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            throw new SQLException("Invalid Parameter Index");
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{null, new Integer(n3)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{null, new Integer(n3), new String(string)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setBoolean(int n2, boolean bl2) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(new Integer(n2 - 1), new Boolean(bl2));
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setByte");
        }
        this.params.put(new Integer(n2 - 1), new Byte(by));
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setShort");
        }
        this.params.put(new Integer(n2 - 1), new Short(s2));
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setInt");
        }
        this.params.put(new Integer(n2 - 1), new Integer(n3));
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setLong");
        }
        this.params.put(new Integer(n2 - 1), new Long(l2));
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setFloat");
        }
        this.params.put(new Integer(n2 - 1), new Float(f2));
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDouble");
        }
        this.params.put(new Integer(n2 - 1), new Double(d2));
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBigDecimal");
        }
        this.params.put(new Integer(n2 - 1), bigDecimal);
    }

    public void setString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setString");
        }
        this.params.put(new Integer(n2 - 1), string);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBytes");
        }
        this.params.put(new Integer(n2 - 1), byArray);
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDate");
        }
        this.params.put(new Integer(n2 - 1), date);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTime");
        }
        this.params.put(new Integer(n2 - 1), time);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTimestamp");
        }
        this.params.put(new Integer(n2 - 1), timestamp);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(2)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setAsciiStream");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(1)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBinaryStream");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(0)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setUnicodeStream");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Integer(n3)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setCharacterStream");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, new Integer(n3), new Integer(n4)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, new Integer(n3)};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(new Integer(n2 - 1), object);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setRef");
        }
        this.params.put(new Integer(n2 - 1), new SerialRef(ref));
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBlob");
        }
        this.params.put(new Integer(n2 - 1), new SerialBlob(blob));
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setClob");
        }
        this.params.put(new Integer(n2 - 1), new SerialClob(clob));
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.checkParamIndex(n2);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setArray");
        }
        this.params.put(new Integer(n2 - 1), new SerialArray(array));
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{date, calendar};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDate");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{time, calendar};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTime");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{timestamp, calendar};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTimestamp");
        }
        this.params.put(new Integer(n2 - 1), objectArray);
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        if (this.params == null) {
            this.initParams();
            Object[] objectArray = new Object[this.params.size()];
            return objectArray;
        }
        Object[] objectArray = new Object[this.params.size()];
        for (int i2 = 0; i2 < this.params.size(); ++i2) {
            objectArray[i2] = this.params.get(new Integer(i2));
            if (objectArray[i2] != null) continue;
            throw new SQLException("missing parameter: " + (i2 + 1));
        }
        return objectArray;
    }
}

