/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SslRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static SocketFactory defaultSocketFactory = null;
    private static final long serialVersionUID = -8310631444933958385L;

    public Socket createSocket(String string, int n2) throws IOException {
        Object object;
        SocketFactory socketFactory = SslRMIClientSocketFactory.getDefaultClientSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string, n2);
        String string2 = System.getProperty("javax.rmi.ssl.client.enabledCipherSuites");
        if (string2 != null) {
            object = new StringTokenizer(string2, ",");
            int n3 = ((StringTokenizer)object).countTokens();
            String[] stringArray = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = ((StringTokenizer)object).nextToken();
            }
            try {
                sSLSocket.setEnabledCipherSuites(stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
        }
        if ((object = System.getProperty("javax.rmi.ssl.client.enabledProtocols")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            int n4 = stringTokenizer.countTokens();
            String[] stringArray = new String[n4];
            for (int i3 = 0; i3 < n4; ++i3) {
                stringArray[i3] = stringTokenizer.nextToken();
            }
            try {
                sSLSocket.setEnabledProtocols(stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
        }
        return sSLSocket;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static synchronized SocketFactory getDefaultClientSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = SSLSocketFactory.getDefault();
        }
        return defaultSocketFactory;
    }
}

