/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.text.resources.LocaleData;
import sun.util.BuddhistCalendar;
import sun.util.calendar.ZoneInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    private transient int[] stamp = new int[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    transient boolean areAllFieldsSet;
    private boolean lenient = true;
    private TimeZone zone;
    private transient boolean sharedZone = false;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private static Hashtable<Locale, int[]> cachedLocaleData = new Hashtable(3);
    private static final int UNSET = 0;
    private static final int COMPUTED = 1;
    private static final int MINIMUM_USER_STAMP = 2;
    static final int ALL_FIELDS = 131071;
    private int nextStamp = 2;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -1807547505821590642L;
    static final int ERA_MASK = 1;
    static final int YEAR_MASK = 2;
    static final int MONTH_MASK = 4;
    static final int WEEK_OF_YEAR_MASK = 8;
    static final int WEEK_OF_MONTH_MASK = 16;
    static final int DAY_OF_MONTH_MASK = 32;
    static final int DATE_MASK = 32;
    static final int DAY_OF_YEAR_MASK = 64;
    static final int DAY_OF_WEEK_MASK = 128;
    static final int DAY_OF_WEEK_IN_MONTH_MASK = 256;
    static final int AM_PM_MASK = 512;
    static final int HOUR_MASK = 1024;
    static final int HOUR_OF_DAY_MASK = 2048;
    static final int MINUTE_MASK = 4096;
    static final int SECOND_MASK = 8192;
    static final int MILLISECOND_MASK = 16384;
    static final int ZONE_OFFSET_MASK = 32768;
    static final int DST_OFFSET_MASK = 65536;
    private static final String[] FIELD_NAME = new String[]{"ERA", "YEAR", "MONTH", "WEEK_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_MONTH", "DAY_OF_YEAR", "DAY_OF_WEEK", "DAY_OF_WEEK_IN_MONTH", "AM_PM", "HOUR", "HOUR_OF_DAY", "MINUTE", "SECOND", "MILLISECOND", "ZONE_OFFSET", "DST_OFFSET"};

    protected Calendar() {
        this(TimeZone.getDefaultRef(), Locale.getDefault());
        this.sharedZone = true;
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.zone = timeZone;
        this.setWeekCountData(locale);
    }

    public static Calendar getInstance() {
        Calendar calendar = Calendar.createCalendar(TimeZone.getDefaultRef(), Locale.getDefault());
        calendar.sharedZone = true;
        return calendar;
    }

    public static Calendar getInstance(TimeZone timeZone) {
        return Calendar.createCalendar(timeZone, Locale.getDefault());
    }

    public static Calendar getInstance(Locale locale) {
        Calendar calendar = Calendar.createCalendar(TimeZone.getDefaultRef(), locale);
        calendar.sharedZone = true;
        return calendar;
    }

    public static Calendar getInstance(TimeZone timeZone, Locale locale) {
        return Calendar.createCalendar(timeZone, locale);
    }

    private static Calendar createCalendar(TimeZone timeZone, Locale locale) {
        if ("th".equals(locale.getLanguage()) && "TH".equals(locale.getCountry())) {
            return new BuddhistCalendar(timeZone, locale);
        }
        return new GregorianCalendar(timeZone, locale);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long l2) {
        if (this.time == l2 && this.isTimeSet && this.areFieldsSet && this.areAllFieldsSet && this.zone instanceof ZoneInfo && !((ZoneInfo)this.zone).isDirty()) {
            return;
        }
        this.time = l2;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.computeFields();
        this.areFieldsSet = true;
        this.areAllFieldsSet = true;
    }

    public int get(int n2) {
        this.complete();
        return this.internalGet(n2);
    }

    protected final int internalGet(int n2) {
        return this.fields[n2];
    }

    final void internalSet(int n2, int n3) {
        this.fields[n2] = n3;
    }

    public void set(int n2, int n3) {
        if (this.isLenient() && this.areFieldsSet && !this.areAllFieldsSet) {
            this.computeFields();
        }
        this.internalSet(n2, n3);
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[n2] = true;
        ++this.nextStamp;
        if (this.nextStamp == Integer.MAX_VALUE) {
            this.adjustStamp();
        }
    }

    public final void set(int n2, int n3, int n4) {
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public final void set(int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
    }

    public final void set(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    public final void clear() {
        int n2 = 0;
        while (n2 < this.fields.length) {
            this.fields[n2] = 0;
            this.stamp[n2] = 0;
            this.isSet[n2++] = false;
        }
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isTimeSet = false;
    }

    public final void clear(int n2) {
        this.fields[n2] = 0;
        this.stamp[n2] = 0;
        this.isSet[n2] = false;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isTimeSet = false;
    }

    public final boolean isSet(int n2) {
        return this.stamp[n2] != 0;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        if (!this.areFieldsSet || !this.areAllFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        } else {
            this.setFieldsComputed(131071);
        }
    }

    final boolean isExternallySet(int n2) {
        return this.stamp[n2] >= 2;
    }

    final int getSetStateFields() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            if (this.stamp[i2] == 0) continue;
            n2 |= 1 << i2;
        }
        return n2;
    }

    final void setFieldsComputed(int n2) {
        if (n2 == 131071) {
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                this.stamp[i2] = 1;
                this.isSet[i2] = true;
            }
            this.areAllFieldsSet = true;
            this.areFieldsSet = true;
        } else {
            for (int i3 = 0; i3 < this.fields.length; ++i3) {
                if ((n2 & 1) == 1) {
                    this.stamp[i3] = 1;
                    this.isSet[i3] = true;
                } else if (this.areAllFieldsSet && !this.isSet[i3]) {
                    this.areAllFieldsSet = false;
                }
                n2 >>>= 1;
            }
        }
    }

    final void setFieldsNormalized(int n2) {
        if (n2 == 131071) {
            this.areAllFieldsSet = true;
            this.areFieldsSet = true;
            return;
        }
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            if ((n2 & 1) == 0) {
                this.fields[i2] = 0;
                this.stamp[i2] = 0;
                this.isSet[i2] = false;
            }
            n2 >>= 1;
        }
        this.areFieldsSet = true;
        this.areAllFieldsSet = false;
    }

    final boolean isPartiallyNormalized() {
        return this.areFieldsSet && !this.areAllFieldsSet;
    }

    final boolean isFullyNormalized() {
        return this.areFieldsSet && this.areAllFieldsSet;
    }

    final void setUnnormalized() {
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
    }

    static final boolean isFieldSet(int n2, int n3) {
        return (n2 & 1 << n3) != 0;
    }

    final int selectFields() {
        int n2 = 2;
        if (this.stamp[0] != 0) {
            n2 |= 1;
        }
        int n3 = this.stamp[7];
        int n4 = this.stamp[2];
        int n5 = this.stamp[5];
        int n6 = Calendar.aggregateStamp(this.stamp[4], n3);
        int n7 = Calendar.aggregateStamp(this.stamp[8], n3);
        int n8 = this.stamp[6];
        int n9 = Calendar.aggregateStamp(this.stamp[3], n3);
        int n10 = n5;
        if (n6 > n10) {
            n10 = n6;
        }
        if (n7 > n10) {
            n10 = n7;
        }
        if (n8 > n10) {
            n10 = n8;
        }
        if (n9 > n10) {
            n10 = n9;
        }
        if (n10 == 0) {
            n6 = this.stamp[4];
            n7 = Math.max(this.stamp[8], n3);
            n9 = this.stamp[3];
            n10 = Math.max(Math.max(n6, n7), n9);
            if (n10 == 0) {
                n10 = n5 = n4;
            }
        }
        if (n10 == n5 || n10 == n6 && this.stamp[4] >= this.stamp[3] || n10 == n7 && this.stamp[8] >= this.stamp[3]) {
            n2 |= 4;
            if (n10 == n5) {
                n2 |= 0x20;
            } else {
                assert (n10 == n6 || n10 == n7);
                if (n3 != 0) {
                    n2 |= 0x80;
                }
                if (n10 == n6) {
                    n2 |= 0x10;
                } else {
                    assert (n10 == n7);
                    if (this.stamp[8] != 0) {
                        n2 |= 0x100;
                    }
                }
            }
        } else {
            assert (n10 == n8 || n10 == n9 || n10 == 0);
            if (n10 == n8) {
                n2 |= 0x40;
            } else {
                assert (n10 == n9);
                if (n3 != 0) {
                    n2 |= 0x80;
                }
                n2 |= 8;
            }
        }
        int n11 = this.stamp[11];
        int n12 = Calendar.aggregateStamp(this.stamp[10], this.stamp[9]);
        int n13 = n10 = n12 > n11 ? n12 : n11;
        if (n10 == 0) {
            n10 = Math.max(this.stamp[10], this.stamp[9]);
        }
        if (n10 != 0) {
            if (n10 == n11) {
                n2 |= 0x800;
            } else {
                n2 |= 0x400;
                if (this.stamp[9] != 0) {
                    n2 |= 0x200;
                }
            }
        }
        if (this.stamp[12] != 0) {
            n2 |= 0x1000;
        }
        if (this.stamp[13] != 0) {
            n2 |= 0x2000;
        }
        if (this.stamp[14] != 0) {
            n2 |= 0x4000;
        }
        if (this.stamp[15] >= 2) {
            n2 |= 0x8000;
        }
        if (this.stamp[16] >= 2) {
            n2 |= 0x10000;
        }
        return n2;
    }

    private static final int aggregateStamp(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        return n2 > n3 ? n2 : n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            Calendar calendar = (Calendar)object;
            return this.compareTo(Calendar.getMillisOf(calendar)) == 0 && this.lenient == calendar.lenient && this.firstDayOfWeek == calendar.firstDayOfWeek && this.minimalDaysInFirstWeek == calendar.minimalDaysInFirstWeek && this.zone.equals(calendar.zone);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        int n2 = (this.lenient ? 1 : 0) | this.firstDayOfWeek << 1 | this.minimalDaysInFirstWeek << 4 | this.zone.hashCode() << 7;
        long l2 = Calendar.getMillisOf(this);
        return (int)l2 ^ (int)(l2 >> 32) ^ n2;
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.compareTo((Calendar)object) < 0;
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.compareTo((Calendar)object) > 0;
    }

    @Override
    public int compareTo(Calendar calendar) {
        return this.compareTo(Calendar.getMillisOf(calendar));
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n2, int n3) {
        while (n3 > 0) {
            this.roll(n2, true);
            --n3;
        }
        while (n3 < 0) {
            this.roll(n2, false);
            ++n3;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        this.sharedZone = false;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
    }

    public TimeZone getTimeZone() {
        if (this.sharedZone) {
            this.zone = (TimeZone)this.zone.clone();
            this.sharedZone = false;
        }
        return this.zone;
    }

    TimeZone getZone() {
        return this.zone;
    }

    void setZoneShared(boolean bl2) {
        this.sharedZone = bl2;
    }

    public void setLenient(boolean bl2) {
        this.lenient = bl2;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n2) {
        if (this.firstDayOfWeek == n2) {
            return;
        }
        this.firstDayOfWeek = n2;
        this.invalidateWeekFields();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n2) {
        if (this.minimalDaysInFirstWeek == n2) {
            return;
        }
        this.minimalDaysInFirstWeek = n2;
        this.invalidateWeekFields();
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n2) {
        int n3;
        int n4 = this.getGreatestMinimum(n2);
        if (n4 == (n3 = this.getMinimum(n2))) {
            return n4;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        int n5 = n4;
        do {
            calendar.set(n2, n4);
            if (calendar.get(n2) != n4) break;
            n5 = n4--;
        } while (n4 >= n3);
        return n5;
    }

    public int getActualMaximum(int n2) {
        int n3;
        int n4 = this.getLeastMaximum(n2);
        if (n4 == (n3 = this.getMaximum(n2))) {
            return n4;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        if (n2 == 3 || n2 == 4) {
            calendar.set(7, this.firstDayOfWeek);
        }
        int n5 = n4;
        do {
            calendar.set(n2, n4);
            if (calendar.get(n2) != n4) break;
            n5 = n4++;
        } while (n4 <= n3);
        return n5;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = new int[17];
            calendar.isSet = new boolean[17];
            calendar.stamp = new int[17];
            for (int i2 = 0; i2 < 17; ++i2) {
                calendar.fields[i2] = this.fields[i2];
                calendar.stamp[i2] = this.stamp[i2];
                calendar.isSet[i2] = this.isSet[i2];
            }
            calendar.zone = (TimeZone)this.zone.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static final String getFieldName(int n2) {
        return FIELD_NAME[n2];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(800);
        stringBuilder.append(this.getClass().getName()).append('[');
        Calendar.appendValue(stringBuilder, "time", this.isTimeSet, this.time);
        stringBuilder.append(",areFieldsSet=").append(this.areFieldsSet);
        stringBuilder.append(",areAllFieldsSet=").append(this.areAllFieldsSet);
        stringBuilder.append(",lenient=").append(this.lenient);
        stringBuilder.append(",zone=").append(this.zone);
        Calendar.appendValue(stringBuilder, ",firstDayOfWeek", true, this.firstDayOfWeek);
        Calendar.appendValue(stringBuilder, ",minimalDaysInFirstWeek", true, this.minimalDaysInFirstWeek);
        for (int i2 = 0; i2 < 17; ++i2) {
            stringBuilder.append(',');
            Calendar.appendValue(stringBuilder, FIELD_NAME[i2], this.isSet(i2), this.fields[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static final void appendValue(StringBuilder stringBuilder, String string, boolean bl2, long l2) {
        stringBuilder.append(string).append('=');
        if (bl2) {
            stringBuilder.append(l2);
        } else {
            stringBuilder.append('?');
        }
    }

    private void setWeekCountData(Locale locale) {
        int[] nArray = cachedLocaleData.get(locale);
        if (nArray == null) {
            ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
            String[] stringArray = resourceBundle.getStringArray("DateTimeElements");
            nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
            cachedLocaleData.put(locale, nArray);
        }
        this.firstDayOfWeek = nArray[0];
        this.minimalDaysInFirstWeek = nArray[1];
    }

    private void updateTime() {
        this.computeTime();
        this.isTimeSet = true;
    }

    @Override
    private int compareTo(long l2) {
        long l3 = Calendar.getMillisOf(this);
        return l3 > l2 ? 1 : (l3 == l2 ? 0 : -1);
    }

    private static final long getMillisOf(Calendar calendar) {
        if (calendar.isTimeSet) {
            return calendar.time;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setLenient(true);
        return calendar2.getTimeInMillis();
    }

    private final void adjustStamp() {
        int n2;
        int n3 = 2;
        int n4 = 2;
        do {
            int n5;
            n2 = Integer.MAX_VALUE;
            for (n5 = 0; n5 < this.stamp.length; ++n5) {
                int n6 = this.stamp[n5];
                if (n6 >= n4 && n2 > n6) {
                    n2 = n6;
                }
                if (n3 >= n6) continue;
                n3 = n6;
            }
            if (n3 != n2 && n2 == Integer.MAX_VALUE) break;
            for (n5 = 0; n5 < this.stamp.length; ++n5) {
                if (this.stamp[n5] != n2) continue;
                this.stamp[n5] = n4;
            }
            ++n4;
        } while (n2 != n3);
        this.nextStamp = n4;
    }

    private void invalidateWeekFields() {
        int n2;
        if (this.stamp[4] != 1 && this.stamp[3] != 1) {
            return;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        calendar.clear(4);
        calendar.clear(3);
        if (this.stamp[4] == 1 && this.fields[4] != (n2 = calendar.get(4))) {
            this.fields[4] = n2;
        }
        if (this.stamp[3] == 1 && this.fields[3] != (n2 = calendar.get(3))) {
            this.fields[3] = n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            try {
                this.updateTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        TimeZone timeZone = null;
        if (this.zone instanceof ZoneInfo) {
            SimpleTimeZone simpleTimeZone = ((ZoneInfo)this.zone).getLastRuleInstance();
            if (simpleTimeZone == null) {
                simpleTimeZone = new SimpleTimeZone(this.zone.getRawOffset(), this.zone.getID());
            }
            timeZone = this.zone;
            this.zone = simpleTimeZone;
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(timeZone);
        if (timeZone != null) {
            this.zone = timeZone;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        TimeZone timeZone;
        Object object;
        final ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.stamp = new int[17];
        if (this.serialVersionOnStream >= 2) {
            this.isTimeSet = true;
            if (this.fields == null) {
                this.fields = new int[17];
            }
            if (this.isSet == null) {
                this.isSet = new boolean[17];
            }
        } else if (this.serialVersionOnStream >= 0) {
            for (int i2 = 0; i2 < 17; ++i2) {
                this.stamp[i2] = this.isSet[i2] ? 1 : 0;
            }
        }
        this.serialVersionOnStream = 1;
        try {
            object = (ZoneInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return objectInputStream2.readObject();
                }
            });
            if (object != null) {
                this.zone = object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.zone instanceof SimpleTimeZone && (timeZone = TimeZone.getTimeZone((String)(object = this.zone.getID()))) != null && timeZone.hasSameRules(this.zone) && timeZone.getID().equals(object)) {
            this.zone = timeZone;
        }
    }
}

