/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient E[] elementData;
    private int size;

    public ArrayList(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.elementData = new Object[n2];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Collection<? extends E> collection) {
        this.size = collection.size();
        this.elementData = new Object[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        collection.toArray(this.elementData);
    }

    public void trimToSize() {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (this.size < n2) {
            E[] EArray = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(EArray, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int n2) {
        ++this.modCount;
        int n3 = this.elementData.length;
        if (n2 > n3) {
            E[] EArray = this.elementData;
            int n4 = n3 * 3 / 2 + 1;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new Object[n4];
            System.arraycopy(EArray, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < this.size; ++i3) {
                if (!object.equals(this.elementData[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i2 = this.size - 1; i2 >= 0; --i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = this.size - 1; i3 >= 0; --i3) {
                if (!object.equals(this.elementData[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, arrayList.elementData, 0, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    @Override
    public E get(int n2) {
        this.RangeCheck(n2);
        return this.elementData[n2];
    }

    @Override
    public E set(int n2, E e2) {
        this.RangeCheck(n2);
        E e3 = this.elementData[n2];
        this.elementData[n2] = e2;
        return e3;
    }

    @Override
    public boolean add(E e2) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = e2;
        return true;
    }

    @Override
    public void add(int n2, E e2) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.size - n2);
        this.elementData[n2] = e2;
        ++this.size;
    }

    @Override
    public E remove(int n2) {
        this.RangeCheck(n2);
        ++this.modCount;
        E e2 = this.elementData[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.size] = null;
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.elementData[i2] != null) continue;
                this.fastRemove(i2);
                return true;
            }
        } else {
            for (int i3 = 0; i3 < this.size; ++i3) {
                if (!object.equals(this.elementData[i3])) continue;
                this.fastRemove(i3);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int n2) {
        ++this.modCount;
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elementData[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(objectArray, 0, this.elementData, this.size, n2);
        this.size += n2;
        return n2 != 0;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        Object[] objectArray = collection.toArray();
        int n3 = objectArray.length;
        this.ensureCapacity(this.size + n3);
        int n4 = this.size - n2;
        if (n4 > 0) {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + n3, n4);
        }
        System.arraycopy(objectArray, 0, this.elementData, n2, n3);
        this.size += n3;
        return n3 != 0;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        ++this.modCount;
        int n4 = this.size - n3;
        System.arraycopy(this.elementData, n3, this.elementData, n2, n4);
        int n5 = this.size - (n3 - n2);
        while (this.size != n5) {
            this.elementData[--this.size] = null;
        }
    }

    private void RangeCheck(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeObject(this.elementData[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = new Object[n2];
        Object[] objectArray = this.elementData;
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectArray[i2] = objectInputStream.readObject();
        }
    }
}

