/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInputStream
extends InputStream {
    Enumeration e;
    InputStream in;

    public SequenceInputStream(Enumeration<? extends InputStream> enumeration) {
        this.e = enumeration;
        try {
            this.nextStream();
        }
        catch (IOException iOException) {
            throw new Error("panic");
        }
    }

    public SequenceInputStream(InputStream inputStream, InputStream inputStream2) {
        Vector<InputStream> vector = new Vector<InputStream>(2);
        vector.addElement(inputStream);
        vector.addElement(inputStream2);
        this.e = vector.elements();
        try {
            this.nextStream();
        }
        catch (IOException iOException) {
            throw new Error("panic");
        }
    }

    final void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.e.hasMoreElements()) {
            this.in = (InputStream)this.e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        } else {
            this.in = null;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            this.nextStream();
            return this.read();
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 <= 0) {
            this.nextStream();
            return this.read(byArray, n2, n3);
        }
        return n4;
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextStream();
        } while (this.in != null);
    }
}

