/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.statics;

import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.LocalVariableInfoInconsistentException;
import com.sun.org.apache.bcel.internal.verifier.statics.DOUBLE_Upper;
import com.sun.org.apache.bcel.internal.verifier.statics.IntList;
import com.sun.org.apache.bcel.internal.verifier.statics.LONG_Upper;
import com.sun.org.apache.bcel.internal.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private LocalVariableInfo[] localVariableInfos;
    private IntList instruction_offsets = new IntList();

    LocalVariablesInfo(int n2) {
        this.localVariableInfos = new LocalVariableInfo[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.localVariableInfos[i2] = new LocalVariableInfo();
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int n2) {
        if (n2 < 0 || n2 >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[n2];
    }

    public void add(int n2, String string, int n3, int n4, Type type) throws LocalVariableInfoInconsistentException {
        if (n2 < 0 || n2 >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[n2].add(string, n3, n4, type);
        if (type == Type.LONG) {
            this.localVariableInfos[n2 + 1].add(string, n3, n4, LONG_Upper.theInstance());
        }
        if (type == Type.DOUBLE) {
            this.localVariableInfos[n2 + 1].add(string, n3, n4, DOUBLE_Upper.theInstance());
        }
    }
}

