/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier;

import com.sun.org.apache.bcel.internal.verifier.Verifier;
import com.sun.org.apache.bcel.internal.verifier.VerifierFactoryObserver;
import java.util.HashMap;
import java.util.Vector;

public class VerifierFactory {
    private static HashMap hashMap = new HashMap();
    private static Vector observers = new Vector();

    private VerifierFactory() {
    }

    public static Verifier getVerifier(String string) {
        Verifier verifier = (Verifier)hashMap.get(string);
        if (verifier == null) {
            verifier = new Verifier(string);
            hashMap.put(string, verifier);
            VerifierFactory.notify(string);
        }
        return verifier;
    }

    private static void notify(String string) {
        for (VerifierFactoryObserver verifierFactoryObserver : observers) {
            verifierFactoryObserver.update(string);
        }
    }

    public static Verifier[] getVerifiers() {
        Verifier[] verifierArray = new Verifier[hashMap.values().size()];
        return hashMap.values().toArray(verifierArray);
    }

    public static void attach(VerifierFactoryObserver verifierFactoryObserver) {
        observers.addElement(verifierFactoryObserver);
    }

    public static void detach(VerifierFactoryObserver verifierFactoryObserver) {
        observers.removeElement(verifierFactoryObserver);
    }
}

