/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basic_type;

    public ArrayType(byte by, int n2) {
        this(BasicType.getType(by), n2);
    }

    public ArrayType(String string, int n2) {
        this(new ObjectType(string), n2);
    }

    public ArrayType(Type type, int n2) {
        super((byte)13, "<dummy>");
        Object object;
        if (n2 < 1 || n2 > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + n2);
        }
        switch (type.getType()) {
            case 13: {
                object = (ArrayType)type;
                this.dimensions = n2 + ((ArrayType)object).dimensions;
                this.basic_type = ((ArrayType)object).basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = n2;
                this.basic_type = type;
            }
        }
        object = new StringBuffer();
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            ((StringBuffer)object).append('[');
        }
        ((StringBuffer)object).append(this.basic_type.getSignature());
        this.signature = ((StringBuffer)object).toString();
    }

    public Type getBasicType() {
        return this.basic_type;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int hashcode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return arrayType.dimensions == this.dimensions && arrayType.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

