/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(ConstantValue constantValue) {
        this(constantValue.getNameIndex(), constantValue.getLength(), constantValue.getConstantValueIndex(), constantValue.getConstantPool());
    }

    ConstantValue(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, dataInputStream.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)1, n2, n3, constantPool);
        this.constantvalue_index = n4;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantValue(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int n2) {
        this.constantvalue_index = n2;
    }

    public final String toString() throws InternalError {
        String string;
        Constant constant = this.constant_pool.getConstant(this.constantvalue_index);
        switch (constant.getTag()) {
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 8: {
                int n2 = ((ConstantString)constant).getStringIndex();
                constant = this.constant_pool.getConstant(n2, (byte)1);
                string = "\"" + ConstantValue.convertString(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            default: {
                throw new InternalError("Type of ConstValue invalid: " + constant);
            }
        }
        return string;
    }

    private static final String convertString(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        ConstantValue constantValue = (ConstantValue)this.clone();
        constantValue.constant_pool = constantPool;
        return constantValue;
    }
}

