/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpVarBindList
extends Vector {
    public String identity = "VarBindList ";
    Timestamp timestamp;

    public SnmpVarBindList() {
        super(5, 5);
    }

    public SnmpVarBindList(int n2) {
        super(n2);
    }

    public SnmpVarBindList(String string) {
        super(5, 5);
        this.identity = string;
    }

    public SnmpVarBindList(SnmpVarBindList snmpVarBindList) {
        super(snmpVarBindList.size(), 5);
        snmpVarBindList.copyInto(this.elementData);
        this.elementCount = snmpVarBindList.size();
    }

    public SnmpVarBindList(Vector vector) {
        super(vector.size(), 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            this.addElement((SnmpVarBind)snmpVarBind.clone());
        }
    }

    public SnmpVarBindList(String string, Vector vector) {
        this(vector);
        this.identity = string;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public final synchronized SnmpVarBind getVarBindAt(int n2) {
        return (SnmpVarBind)this.elementAt(n2);
    }

    public synchronized int getVarBindCount() {
        return this.size();
    }

    public synchronized Enumeration getVarBindList() {
        return this.elements();
    }

    public final synchronized void setVarBindList(Vector vector) {
        this.setVarBindList(vector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setVarBindList(Vector vector, boolean bl2) {
        Vector vector2 = vector;
        synchronized (vector2) {
            int n2 = vector.size();
            this.setSize(n2);
            vector.copyInto(this.elementData);
            if (bl2) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
                    this.elementData[i2] = snmpVarBind.clone();
                }
            }
        }
    }

    public synchronized void addVarBindList(SnmpVarBindList snmpVarBindList) {
        this.ensureCapacity(snmpVarBindList.size() + this.size());
        for (int i2 = 0; i2 < snmpVarBindList.size(); ++i2) {
            this.addElement(snmpVarBindList.getVarBindAt(i2));
        }
    }

    public synchronized boolean removeVarBindList(SnmpVarBindList snmpVarBindList) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < snmpVarBindList.size(); ++i2) {
            bl2 = this.removeElement(snmpVarBindList.getVarBindAt(i2));
        }
        return bl2;
    }

    public final synchronized void replaceVarBind(SnmpVarBind snmpVarBind, int n2) {
        this.setElementAt(snmpVarBind, n2);
    }

    public final synchronized void addVarBind(String[] stringArray, String string) throws SnmpStatusException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(stringArray[i2]);
            snmpVarBind.addInstance(string);
            this.addElement(snmpVarBind);
        }
    }

    public synchronized boolean removeVarBind(String[] stringArray, String string) throws SnmpStatusException {
        boolean bl2 = true;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(stringArray[i2]);
            snmpVarBind.addInstance(string);
            int n2 = this.indexOfOid(snmpVarBind);
            try {
                this.removeElementAt(n2);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public synchronized void addVarBind(String[] stringArray) throws SnmpStatusException {
        this.addVarBind(stringArray, null);
    }

    public synchronized boolean removeVarBind(String[] stringArray) throws SnmpStatusException {
        return this.removeVarBind(stringArray, null);
    }

    public synchronized void addVarBind(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = new SnmpVarBind(string);
        this.addVarBind(snmpVarBind);
    }

    public synchronized boolean removeVarBind(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = new SnmpVarBind(string);
        int n2 = this.indexOfOid(snmpVarBind);
        try {
            this.removeElementAt(n2);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public synchronized void addVarBind(SnmpVarBind snmpVarBind) {
        this.addElement(snmpVarBind);
    }

    public synchronized boolean removeVarBind(SnmpVarBind snmpVarBind) {
        return this.removeElement(snmpVarBind);
    }

    public synchronized void addInstance(String string) throws SnmpStatusException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((SnmpVarBind)this.elementData[i2]).addInstance(string);
        }
    }

    public final synchronized void concat(Vector vector) {
        this.ensureCapacity(this.size() + vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public synchronized boolean checkForValidValues() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            if (snmpVarBind.isValidValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean checkForUnspecifiedValue() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            if (!snmpVarBind.isUnspecifiedValue()) continue;
            return true;
        }
        return false;
    }

    public synchronized SnmpVarBindList splitAt(int n2) {
        SnmpVarBindList snmpVarBindList = null;
        if (n2 > this.elementCount) {
            return snmpVarBindList;
        }
        snmpVarBindList = new SnmpVarBindList();
        int n3 = this.size();
        for (int i2 = n2; i2 < n3; ++i2) {
            snmpVarBindList.addElement(this.elementData[i2]);
        }
        this.elementCount = n2;
        this.trimToSize();
        return snmpVarBindList;
    }

    public synchronized int indexOfOid(SnmpVarBind snmpVarBind, int n2, int n3) {
        SnmpOid snmpOid = snmpVarBind.getOid();
        for (int i2 = n2; i2 < n3; ++i2) {
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)this.elementData[i2];
            if (!snmpOid.equals(snmpVarBind2.getOid())) continue;
            return i2;
        }
        return -1;
    }

    public synchronized int indexOfOid(SnmpVarBind snmpVarBind) {
        return this.indexOfOid(snmpVarBind, 0, this.size());
    }

    public synchronized int indexOfOid(SnmpOid snmpOid) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            if (!snmpOid.equals(snmpVarBind.getOid())) continue;
            return i2;
        }
        return -1;
    }

    public synchronized SnmpVarBindList cloneWithValue() {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        snmpVarBindList.setTimestamp(this.getTimestamp());
        snmpVarBindList.ensureCapacity(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            snmpVarBindList.addElement(snmpVarBind.clone());
        }
        return snmpVarBindList;
    }

    public synchronized SnmpVarBindList cloneWithoutValue() {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        int n2 = this.size();
        snmpVarBindList.ensureCapacity(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            snmpVarBindList.addElement(snmpVarBind.cloneWithoutValue());
        }
        return snmpVarBindList;
    }

    public synchronized Object clone() {
        return this.cloneWithValue();
    }

    public synchronized Vector toVector(boolean bl2) {
        int n2 = this.elementCount;
        if (!bl2) {
            return (Vector)super.clone();
        }
        Vector<Object> vector = new Vector<Object>(n2, 5);
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            vector.addElement(snmpVarBind.clone());
        }
        return vector;
    }

    public String oidListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i2];
            stringBuffer.append(snmpVarBind.getOid().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public synchronized String varBindListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            stringBuffer.append(this.elementData[i2].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public void finalize() {
        this.removeAllElements();
    }
}

