/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    protected byte[] subnet = null;
    protected int prefix = -1;
    String dbgTag = "NetMaskImpl";

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] byArray) {
        int n2;
        int n3;
        int n4;
        int n5 = byArray.length;
        byte[] byArray2 = null;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "BINARY ARRAY :");
            StringBuffer stringBuffer = new StringBuffer();
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuffer.append((byArray[n4] & 0xFF) + ":");
            }
            this.debug("extractSubNet", stringBuffer.toString());
        }
        if ((n3 = this.prefix / 8) == n5) {
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " The mask is the complete address, strange..." + n5);
            }
            byArray2 = byArray;
            return byArray2;
        }
        if (n3 > n5) {
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        n4 = n3;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Partialy covered index : " + n4);
        }
        byte by = byArray[n4];
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Partialy covered byte : " + by);
        }
        int n6 = this.prefix % 8;
        int n7 = 0;
        n7 = n6 == 0 ? n4 : n4 + 1;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Remains : " + n6);
        }
        byte by2 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            by2 = (byte)(by2 | 1 << 7 - n2);
        }
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Mask value" + (by2 & 0xFF));
        }
        n2 = (byte)(by & by2);
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Masked byte :" + (n2 & 0xFF));
        }
        byArray2 = new byte[n7];
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Resulting subnet : ");
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray2[i2] = byArray[i2];
            if (!this.isDebugOn()) continue;
            this.debug("extractSubNet", (byArray2[i2] & 0xFF) + ":");
        }
        if (n6 != 0) {
            byArray2[n4] = n2;
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " Last subnet byte : " + (byArray2[n4] & 0xFF));
            }
        }
        return byArray2;
    }

    public NetMaskImpl(String string, int n2) throws UnknownHostException {
        super(string);
        this.prefix = n2;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    public boolean addMember(Principal principal) {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PrincipalImpl || object instanceof NetMaskImpl) {
            PrincipalImpl principalImpl = (PrincipalImpl)object;
            InetAddress inetAddress = principalImpl.getAddress();
            if (this.isDebugOn()) {
                this.debug("equals", "Received Address : " + inetAddress);
            }
            byte[] byArray = inetAddress.getAddress();
            for (int i2 = 0; i2 < this.subnet.length; ++i2) {
                if (this.isDebugOn()) {
                    this.debug("equals", "(recAddr[i]) :" + (byArray[i2] & 0xFF));
                    this.debug("equals", "(recAddr[i] & subnet[i]) :" + (byArray[i2] & this.subnet[i2] & 0xFF) + "subnet[i] :" + (this.subnet[i2] & 0xFF));
                }
                if ((byArray[i2] & this.subnet[i2]) == this.subnet[i2]) continue;
                if (this.isDebugOn()) {
                    this.debug("equals", "FALSE");
                }
                return false;
            }
            if (this.isDebugOn()) {
                this.debug("equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    public boolean isMember(Principal principal) {
        return (((Object)principal).hashCode() & super.hashCode()) == ((Object)principal).hashCode();
    }

    public Enumeration members() {
        Vector<NetMaskImpl> vector = new Vector<NetMaskImpl>(1);
        vector.addElement(this);
        return vector.elements();
    }

    public boolean removeMember(Principal principal) {
        return true;
    }

    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 512);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 512, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 512);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 512, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 512, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

