/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.BaseMetaDataImpl;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInstantiatorImpl;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class StandardMetaDataImpl
extends BaseMetaDataImpl {
    private static final String dbgTag = "StandardMetaDataImpl";
    private static Map mbeanInfoCache = new WeakHashMap();
    private static Map mbeanInterfaceCache = new WeakHashMap();
    private final boolean wrapRuntimeExceptions;
    private static final Hashtable primitiveClasses = new Hashtable(8);

    public StandardMetaDataImpl() {
        this(true);
    }

    protected StandardMetaDataImpl(boolean bl2) {
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.wrapRuntimeExceptions = bl2;
    }

    public synchronized MBeanInfo buildMBeanInfo(Class clazz) throws NotCompliantMBeanException {
        return Introspector.testCompliance(clazz);
    }

    public synchronized MBeanInfo buildMBeanInfo(Class clazz, Class clazz2) throws NotCompliantMBeanException {
        return Introspector.testCompliance(clazz, clazz2);
    }

    public synchronized void testCompliance(Class clazz) throws NotCompliantMBeanException {
        MBeanInfo mBeanInfo = this.buildMBeanInfo(clazz);
        Class clazz2 = Introspector.getMBeanInterface(clazz);
        this.cacheMBeanInfo(clazz, clazz2, mBeanInfo);
    }

    public synchronized void testCompliance(Class clazz, Class clazz2) throws NotCompliantMBeanException {
        MBeanInfo mBeanInfo = this.buildMBeanInfo(clazz, clazz2);
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        }
        this.cacheMBeanInfo(clazz, clazz2, mBeanInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getMBeanInterfaceFromClass(Class clazz) {
        Class clazz2 = this.getCachedMBeanInterface(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        StandardMetaDataImpl standardMetaDataImpl = this;
        synchronized (standardMetaDataImpl) {
            return Introspector.getMBeanInterface(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getStandardMBeanInterface(Class clazz) {
        StandardMetaDataImpl standardMetaDataImpl = this;
        synchronized (standardMetaDataImpl) {
            return Introspector.getStandardMBeanInterface(clazz);
        }
    }

    public MBeanInfo getMBeanInfoFromClass(Class clazz) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo mBeanInfo = this.getCachedMBeanInfo(clazz);
        if (mBeanInfo != null) {
            return (MBeanInfo)mBeanInfo.clone();
        }
        this.testCompliance(clazz);
        mBeanInfo = this.getCachedMBeanInfo(clazz);
        if (mBeanInfo != null) {
            return (MBeanInfo)mBeanInfo.clone();
        }
        return mBeanInfo;
    }

    public String getMBeanClassName(Object object) throws IntrospectionException, NotCompliantMBeanException {
        return object.getClass().getName();
    }

    public MBeanInfo getMBeanInfo(Object object) throws IntrospectionException {
        try {
            MBeanInfo mBeanInfo = this.getMBeanInfoFromClass(object.getClass());
            return new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanInfo.getAttributes(), mBeanInfo.getConstructors(), mBeanInfo.getOperations(), this.findNotifications(object));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            StandardMetaDataImpl.debugX("getMBeanInfo", notCompliantMBeanException);
            throw new IntrospectionException("Can't build MBeanInfo for " + object.getClass().getName());
        }
    }

    public Object getAttribute(Object object, String string) throws MBeanException, AttributeNotFoundException, ReflectionException {
        Class clazz = this.getMBeanInterfaceFromInstance(object);
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("getAttribute", "MBean Class is " + object.getClass());
            StandardMetaDataImpl.debug("getAttribute", "MBean Interface is " + clazz);
        }
        return this.getAttribute(object, string, clazz);
    }

    public AttributeList getAttributes(Object object, String[] stringArray) throws ReflectionException {
        Class clazz = this.getMBeanInterfaceFromInstance(object);
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("getAttributes", "MBean Class is " + object.getClass());
            StandardMetaDataImpl.debug("getAttributes", "MBean Interface is " + clazz);
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        int n2 = stringArray.length;
        AttributeList attributeList = new AttributeList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            try {
                Object object2 = this.getAttribute(object, string, clazz);
                attributeList.add(new Attribute(string, object2));
                continue;
            }
            catch (Exception exception) {
                if (!StandardMetaDataImpl.isDebugOn()) continue;
                StandardMetaDataImpl.debug("getAttributes", "Object= " + object + ", Attribute=" + string + " failed: " + exception);
            }
        }
        return attributeList;
    }

    public AttributeList setAttributes(Object object, AttributeList attributeList) throws ReflectionException {
        Class<? extends Object> clazz = object.getClass();
        Class clazz2 = this.getMBeanInterfaceFromInstance(object);
        ClassLoader classLoader = clazz.getClassLoader();
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("setAttributes", "MBean Class is " + object.getClass());
            StandardMetaDataImpl.debug("setAttributes", "MBean Interface is " + clazz2);
        }
        if (attributeList == null) {
            return new AttributeList();
        }
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        for (Attribute attribute : attributeList) {
            String string = attribute.getName();
            Object object2 = attribute.getValue();
            try {
                Object object3 = this.setAttribute(object, attribute, clazz2);
                if (StandardMetaDataImpl.isTraceOn()) {
                    StandardMetaDataImpl.trace("setAttributes", "Updating the list\n");
                }
                attributeList2.add(new Attribute(string, object3));
            }
            catch (Exception exception) {
                if (!StandardMetaDataImpl.isDebugOn()) continue;
                StandardMetaDataImpl.debug("setAttributes", "Unexpected exception occured: " + exception.getClass().getName());
            }
        }
        return attributeList2;
    }

    public Object setAttribute(Object object, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Class clazz = this.getMBeanInterfaceFromInstance(object);
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("setAttribute", "MBean Class is " + object.getClass());
            StandardMetaDataImpl.debug("setAttribute", "MBean Interface is " + clazz);
        }
        return this.setAttribute(object, attribute, clazz);
    }

    public Object invoke(Object object, String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Class[] classArray;
        Method method;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Operation name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to invoke the operation on the MBean");
        }
        Class<? extends Object> clazz = object.getClass();
        Class clazz2 = this.getMBeanInterfaceFromInstance(object);
        ClassLoader classLoader = clazz.getClassLoader();
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("invoke", "MBean Class is " + object.getClass());
            StandardMetaDataImpl.debug("invoke", "MBean Interface is " + clazz2);
        }
        if ((method = StandardMetaDataImpl.findMethod(clazz2, string, classArray = stringArray == null ? null : this.findSignatureClasses(stringArray, classLoader))) == null) {
            if (StandardMetaDataImpl.isTraceOn()) {
                StandardMetaDataImpl.trace("invoke", string + " not found in class " + clazz2.getName());
            }
            throw new ReflectionException(new NoSuchMethodException(string), "The operation with name " + string + " could not be found");
        }
        StandardMetaDataImpl.forbidInvokeGetterSetter(method, string);
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("invoke", "Invoking " + string);
        }
        Object object2 = null;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            StandardMetaDataImpl.debugX("invoke", illegalAccessException);
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occured trying to invoke operation " + string);
        }
        catch (RuntimeException runtimeException) {
            StandardMetaDataImpl.debugX("invoke", runtimeException);
            throw new RuntimeOperationsException(runtimeException, "RuntimeException occured trying to invoke operation " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            StandardMetaDataImpl.debugX("invoke", throwable);
            if (throwable instanceof RuntimeException) {
                String string2 = "RuntimeException thrown in operation " + string;
                throw this.wrapRuntimeException((RuntimeException)throwable, string2);
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in operation " + string);
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in operation " + string);
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("invoke", "Send the result");
        }
        return object2;
    }

    private static boolean startsWithAndHasMore(String string, String string2) {
        return string.startsWith(string2) && string.length() > string2.length();
    }

    private static void forbidInvokeGetterSetter(Method method, String string) throws ReflectionException {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        int n2 = classArray.length;
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                if ((!StandardMetaDataImpl.startsWithAndHasMore(string, "get") || clazz == Void.TYPE) && (!StandardMetaDataImpl.startsWithAndHasMore(string, "is") || clazz != Boolean.TYPE)) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (!StandardMetaDataImpl.startsWithAndHasMore(string, "set") || clazz != Void.TYPE) break;
                bl2 = true;
            }
        }
        if (bl2) {
            boolean bl3;
            Object object;
            try {
                object = new GetPropertyAction("jmx.invoke.getters");
                bl3 = AccessController.doPrivileged(object) != null;
            }
            catch (SecurityException securityException) {
                bl3 = false;
            }
            if (!bl3) {
                object = "Cannot invoke getter or setter (" + string + ") as operation unless jmx.invoke.getters property is set";
                NoSuchMethodException noSuchMethodException = new NoSuchMethodException(string);
                throw new ReflectionException(noSuchMethodException, (String)object);
            }
        }
    }

    public boolean isInstanceOf(Object object, String string) throws ReflectionException {
        Class clazz = this.findClass(string, object.getClass().getClassLoader());
        return clazz.isInstance(object);
    }

    protected Class getMBeanInterfaceFromInstance(Object object) {
        if (object == null) {
            return null;
        }
        return this.getMBeanInterfaceFromClass(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheMBeanInfo(Class clazz, Class clazz2, MBeanInfo mBeanInfo) throws NotCompliantMBeanException {
        Map map;
        if (mBeanInfo != null) {
            map = mbeanInfoCache;
            synchronized (map) {
                if (mbeanInfoCache.get(clazz) == null) {
                    mbeanInfoCache.put(clazz, mBeanInfo);
                }
            }
        }
        if (clazz2 != null) {
            map = mbeanInterfaceCache;
            synchronized (map) {
                if (mbeanInterfaceCache.get(clazz) == null || ((WeakReference)mbeanInterfaceCache.get(clazz)).get() == null) {
                    mbeanInterfaceCache.put(clazz, new WeakReference<Class>(clazz2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getCachedMBeanInterface(Class clazz) {
        Map map = mbeanInterfaceCache;
        synchronized (map) {
            return (Class)((WeakReference)mbeanInterfaceCache.get(clazz)).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanInfo getCachedMBeanInfo(Class clazz) {
        Map map = mbeanInfoCache;
        synchronized (map) {
            return (MBeanInfo)mbeanInfoCache.get(clazz);
        }
    }

    protected Class findClass(String string, ClassLoader classLoader) throws ReflectionException {
        return MBeanInstantiatorImpl.loadClass(string, classLoader);
    }

    protected Class[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        return stringArray == null ? null : MBeanInstantiatorImpl.loadSignatureClasses(stringArray, classLoader);
    }

    protected Object getAttribute(Object object, String string, Class clazz) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to invoke the getter on the MBean");
        }
        Method method = null;
        method = StandardMetaDataImpl.findGetter(clazz, string);
        if (method == null) {
            if (StandardMetaDataImpl.isTraceOn()) {
                StandardMetaDataImpl.trace("getAttribute", "Cannot find getter for " + string + " in class " + clazz.getName());
            }
            throw new AttributeNotFoundException(string + " not accessible");
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("getAttribute", "Invoke callback");
        }
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                StandardMetaDataImpl.debugX("getAttribute", throwable);
                String string2 = "RuntimeException thrown in the getter for the attribute " + string;
                throw this.wrapRuntimeException((RuntimeException)throwable, string2);
            }
            if (throwable instanceof Error) {
                StandardMetaDataImpl.debugX("getAttribute", throwable);
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the getter for the attribute " + string);
            }
            StandardMetaDataImpl.debugX("getAttribute", throwable);
            throw new MBeanException((Exception)throwable, "Exception thrown in the getter for the attribute " + string);
        }
        catch (RuntimeException runtimeException) {
            StandardMetaDataImpl.debugX("getAttribute", runtimeException);
            throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown trying to invoke the getter for the attribute " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            StandardMetaDataImpl.debugX("getAttribute", illegalAccessException);
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the getter for the attribute " + string);
        }
        catch (Error error) {
            StandardMetaDataImpl.debugX("getAttribute", error);
            throw new RuntimeErrorException(error, "Error thrown trying to invoke the getter  for the attribute " + string);
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("getAttribute", string + "= " + object2 + "\n");
        }
        return object2;
    }

    protected Object setAttribute(Object object, Attribute attribute, Class clazz) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object object2;
        if (attribute == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to invoke the setter on the MBean");
        }
        Class<? extends Object> clazz2 = object.getClass();
        ClassLoader classLoader = clazz2.getClassLoader();
        Object object3 = null;
        Object object4 = attribute.getValue();
        String string = attribute.getName();
        Method method = null;
        method = object4 == null ? StandardMetaDataImpl.findSetter(clazz, string) : StandardMetaDataImpl.findSetter(clazz, string, object4.getClass());
        if (method == null && (object2 = StandardMetaDataImpl.findPrimForClass(object4)) != null) {
            method = StandardMetaDataImpl.findSetter(clazz, string, (Class)object2);
        }
        if (method == null) {
            method = StandardMetaDataImpl.findSetter(clazz, string);
            if (method == null) {
                if (StandardMetaDataImpl.isTraceOn()) {
                    StandardMetaDataImpl.trace("setAttribute", "Cannot find setter for " + attribute + " in class " + clazz.getName());
                }
                throw new AttributeNotFoundException(string + " not accessible");
            }
            object2 = attribute.getValue();
            if (object2 == null) {
                throw new InvalidAttributeValueException("attribute= " + string + " value = null");
            }
            throw new InvalidAttributeValueException("attribute= " + string + " value = " + object2);
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("setAttribute", "Invoking the set method for " + string);
        }
        object2 = new Object[]{object4};
        try {
            object3 = method.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            StandardMetaDataImpl.debugX("setAttribute", illegalAccessException);
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occured trying to invoke the setter on the MBean");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            StandardMetaDataImpl.debugX("setAttribute", throwable);
            if (throwable instanceof RuntimeException) {
                String string2 = "RuntimeException thrown in the setter for the attribute " + attribute;
                throw this.wrapRuntimeException((RuntimeException)throwable, string2);
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's setter");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's setter");
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("setAttribute", string + "= " + object4);
        }
        return object4;
    }

    protected MBeanNotificationInfo[] findNotifications(Object object) {
        if (object instanceof NotificationBroadcaster) {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = ((NotificationBroadcaster)object).getNotificationInfo();
            if (mBeanNotificationInfoArray == null) {
                return new MBeanNotificationInfo[0];
            }
            MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length];
            for (int i2 = 0; i2 < mBeanNotificationInfoArray.length; ++i2) {
                mBeanNotificationInfoArray2[i2] = (MBeanNotificationInfo)mBeanNotificationInfoArray[i2].clone();
            }
            return mBeanNotificationInfoArray2;
        }
        return new MBeanNotificationInfo[0];
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string) {
        Method method = null;
        try {
            int n2;
            Method[] methodArray = clazz.getMethods();
            for (n2 = 0; n2 < methodArray.length && !methodArray[n2].getName().equals(string); ++n2) {
            }
            if (n2 < methodArray.length) {
                method = methodArray[n2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string, int n2) {
        Method method = null;
        try {
            int n3;
            Method[] methodArray = clazz.getMethods();
            boolean bl2 = false;
            for (n3 = 0; n3 < methodArray.length && !bl2; ++n3) {
                bl2 = methodArray[n3].getName().equals(string);
                if (!bl2) continue;
                bl2 = methodArray[n3].getParameterTypes().length == n2;
            }
            if (bl2) {
                method = methodArray[n3 - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findGetter(Class clazz, String string) {
        if (string.length() == 0) {
            return null;
        }
        Method method = StandardMetaDataImpl.findMethod(clazz, "get" + string, null);
        if (method != null && method.getReturnType() != Void.TYPE) {
            return method;
        }
        method = StandardMetaDataImpl.findMethod(clazz, "is" + string, null);
        if (method != null && method.getReturnType() == Boolean.TYPE) {
            return method;
        }
        return null;
    }

    public static Method findSetter(Class clazz, String string, Class clazz2) {
        Class<?>[] classArray;
        Method method = StandardMetaDataImpl.findMethod(clazz, "set" + string, 1);
        if (method != null && (classArray = method.getParameterTypes())[0].isAssignableFrom(clazz2)) {
            return method;
        }
        return null;
    }

    public static Method findSetter(Class clazz, String string) {
        return StandardMetaDataImpl.findMethod(clazz, "set" + string, 1);
    }

    public static Constructor findConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            return null;
        }
        return constructor;
    }

    public static Class findClassForPrim(String string) {
        return (Class)primitiveClasses.get(string);
    }

    public static Class findPrimForClass(Object object) {
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    static String[] findSignatures(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringArray[i2] = StandardMetaDataImpl.findSignature(classArray[i2]);
        }
        return stringArray;
    }

    static String findSignature(Class clazz) {
        return clazz.getName();
    }

    private RuntimeException wrapRuntimeException(RuntimeException runtimeException, String string) {
        if (this.wrapRuntimeExceptions) {
            return new RuntimeMBeanException(runtimeException, string);
        }
        return runtimeException;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        StandardMetaDataImpl.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        StandardMetaDataImpl.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (StandardMetaDataImpl.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            StandardMetaDataImpl.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            StandardMetaDataImpl.debug(dbgTag, string, string2);
        }
    }
}

