/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CAccept;
import com.sun.jlex.internal.CDTrans;
import com.sun.jlex.internal.CEmit;
import com.sun.jlex.internal.CError;
import com.sun.jlex.internal.CInput;
import com.sun.jlex.internal.CMakeNfa;
import com.sun.jlex.internal.CMinimize;
import com.sun.jlex.internal.CNfa;
import com.sun.jlex.internal.CNfa2Dfa;
import com.sun.jlex.internal.CSet;
import com.sun.jlex.internal.CSimplifyNfa;
import com.sun.jlex.internal.CSpec;
import com.sun.jlex.internal.CUtility;
import com.sun.jlex.internal.SparseBitSet;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CLexGen {
    private Reader m_instream;
    private PrintWriter m_outstream;
    private CInput m_input;
    private Hashtable m_tokens;
    private CSpec m_spec;
    private boolean m_init_flag = false;
    private CMakeNfa m_makeNfa;
    private CNfa2Dfa m_nfa2dfa;
    private CMinimize m_minimize;
    private CSimplifyNfa m_simplifyNfa;
    private CEmit m_emit;
    private static final boolean ERROR = false;
    private static final boolean NOT_ERROR = true;
    private static final int BUFFER_SIZE = 1024;
    static final int EOS = 1;
    static final int ANY = 2;
    static final int AT_BOL = 3;
    static final int AT_EOL = 4;
    static final int CCL_END = 5;
    static final int CCL_START = 6;
    static final int CLOSE_CURLY = 7;
    static final int CLOSE_PAREN = 8;
    static final int CLOSURE = 9;
    static final int DASH = 10;
    static final int END_OF_INPUT = 11;
    static final int L = 12;
    static final int OPEN_CURLY = 13;
    static final int OPEN_PAREN = 14;
    static final int OPTIONAL = 15;
    static final int OR = 16;
    static final int PLUS_CLOSE = 17;
    private final int CLASS_CODE = 0;
    private final int INIT_CODE = 1;
    private final int EOF_CODE = 2;
    private final int INIT_THROW_CODE = 3;
    private final int YYLEX_THROW_CODE = 4;
    private final int EOF_THROW_CODE = 5;
    private final int EOF_VALUE_CODE = 6;
    private char[] m_state_dir = new char[]{'%', 's', 't', 'a', 't', 'e', '\u0000'};
    private char[] m_char_dir = new char[]{'%', 'c', 'h', 'a', 'r', '\u0000'};
    private char[] m_line_dir = new char[]{'%', 'l', 'i', 'n', 'e', '\u0000'};
    private char[] m_cup_dir = new char[]{'%', 'c', 'u', 'p', '\u0000'};
    private char[] m_class_dir = new char[]{'%', 'c', 'l', 'a', 's', 's', '\u0000'};
    private char[] m_implements_dir = new char[]{'%', 'i', 'm', 'p', 'l', 'e', 'm', 'e', 'n', 't', 's', '\u0000'};
    private char[] m_function_dir = new char[]{'%', 'f', 'u', 'n', 'c', 't', 'i', 'o', 'n', '\u0000'};
    private char[] m_type_dir = new char[]{'%', 't', 'y', 'p', 'e', '\u0000'};
    private char[] m_integer_dir = new char[]{'%', 'i', 'n', 't', 'e', 'g', 'e', 'r', '\u0000'};
    private char[] m_intwrap_dir = new char[]{'%', 'i', 'n', 't', 'w', 'r', 'a', 'p', '\u0000'};
    private char[] m_full_dir = new char[]{'%', 'f', 'u', 'l', 'l', '\u0000'};
    private char[] m_unicode_dir = new char[]{'%', 'u', 'n', 'i', 'c', 'o', 'd', 'e', '\u0000'};
    private char[] m_ignorecase_dir = new char[]{'%', 'i', 'g', 'n', 'o', 'r', 'e', 'c', 'a', 's', 'e', '\u0000'};
    private char[] m_notunix_dir = new char[]{'%', 'n', 'o', 't', 'u', 'n', 'i', 'x', '\u0000'};
    private char[] m_init_code_dir = new char[]{'%', 'i', 'n', 'i', 't', '{', '\u0000'};
    private char[] m_init_code_end_dir = new char[]{'%', 'i', 'n', 'i', 't', '}', '\u0000'};
    private char[] m_init_throw_code_dir = new char[]{'%', 'i', 'n', 'i', 't', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_init_throw_code_end_dir = new char[]{'%', 'i', 'n', 'i', 't', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_yylex_throw_code_dir = new char[]{'%', 'y', 'y', 'l', 'e', 'x', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_yylex_throw_code_end_dir = new char[]{'%', 'y', 'y', 'l', 'e', 'x', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_eof_code_dir = new char[]{'%', 'e', 'o', 'f', '{', '\u0000'};
    private char[] m_eof_code_end_dir = new char[]{'%', 'e', 'o', 'f', '}', '\u0000'};
    private char[] m_eof_value_code_dir = new char[]{'%', 'e', 'o', 'f', 'v', 'a', 'l', '{', '\u0000'};
    private char[] m_eof_value_code_end_dir = new char[]{'%', 'e', 'o', 'f', 'v', 'a', 'l', '}', '\u0000'};
    private char[] m_eof_throw_code_dir = new char[]{'%', 'e', 'o', 'f', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_eof_throw_code_end_dir = new char[]{'%', 'e', 'o', 'f', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_class_code_dir = new char[]{'%', '{', '\u0000'};
    private char[] m_class_code_end_dir = new char[]{'%', '}', '\u0000'};
    private char[] m_yyeof_dir = new char[]{'%', 'y', 'y', 'e', 'o', 'f', '\u0000'};
    private char[] m_public_dir = new char[]{'%', 'p', 'u', 'b', 'l', 'i', 'c', '\u0000'};
    private SparseBitSet all_states = null;
    private boolean m_advance_stop = false;

    CLexGen(String string) throws FileNotFoundException, IOException {
        this.m_instream = new FileReader(string);
        if (null == this.m_instream) {
            System.out.println("Error: Unable to open input file " + string + ".");
            return;
        }
        this.m_outstream = new PrintWriter(new BufferedWriter(new FileWriter(string + ".java")));
        if (null == this.m_outstream) {
            System.out.println("Error: Unable to open output file " + string + ".java.");
            return;
        }
        this.m_input = new CInput(this.m_instream);
        this.m_tokens = new Hashtable();
        this.m_tokens.put(new Character('$'), new Integer(4));
        this.m_tokens.put(new Character('('), new Integer(14));
        this.m_tokens.put(new Character(')'), new Integer(8));
        this.m_tokens.put(new Character('*'), new Integer(9));
        this.m_tokens.put(new Character('+'), new Integer(17));
        this.m_tokens.put(new Character('-'), new Integer(10));
        this.m_tokens.put(new Character('.'), new Integer(2));
        this.m_tokens.put(new Character('?'), new Integer(15));
        this.m_tokens.put(new Character('['), new Integer(6));
        this.m_tokens.put(new Character(']'), new Integer(5));
        this.m_tokens.put(new Character('^'), new Integer(3));
        this.m_tokens.put(new Character('{'), new Integer(13));
        this.m_tokens.put(new Character('|'), new Integer(16));
        this.m_tokens.put(new Character('}'), new Integer(7));
        this.m_spec = new CSpec(this);
        this.m_nfa2dfa = new CNfa2Dfa();
        this.m_minimize = new CMinimize();
        this.m_makeNfa = new CMakeNfa();
        this.m_simplifyNfa = new CSimplifyNfa();
        this.m_emit = new CEmit();
        this.m_init_flag = true;
    }

    void generate() throws IOException, FileNotFoundException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        CUtility._assert(this.m_init_flag);
        if (this.m_spec.m_verbose) {
            System.out.println("Processing first section -- user code.");
        }
        this.userCode();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        if (this.m_spec.m_verbose) {
            System.out.println("Processing second section -- JLex declarations.");
        }
        this.userDeclare();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        if (this.m_spec.m_verbose) {
            System.out.println("Processing third section -- lexical rules.");
        }
        this.userRules();
        if (this.m_spec.m_verbose) {
            System.out.println("Outputting lexical analyzer code.");
        }
        this.m_emit.emit(this.m_spec, this.m_outstream);
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.m_outstream.close();
    }

    private void userCode() throws IOException {
        boolean bl2 = false;
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, 0);
        }
        while (true) {
            if (this.m_input.getLine()) {
                CError.parse_error(11, 0);
            }
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_index = this.m_input.m_line_read;
                return;
            }
            this.m_outstream.print(new String(this.m_input.m_line, 0, this.m_input.m_line_read));
        }
    }

    private char[] getName() {
        int n2;
        while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
        }
        if (this.m_input.m_line_index >= this.m_input.m_line_read) {
            CError.parse_error(12, 0);
        }
        for (n2 = this.m_input.m_line_index; n2 < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[n2]); ++n2) {
        }
        char[] cArray = new char[n2 - this.m_input.m_line_index];
        n2 = 0;
        while (this.m_input.m_line_index < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[this.m_input.m_line_index])) {
            cArray[n2] = this.m_input.m_line[this.m_input.m_line_index];
            ++n2;
            ++this.m_input.m_line_index;
        }
        return cArray;
    }

    /*
     * Unable to fully structure code
     */
    private char[] packCode(char[] var1_1, char[] var2_2, char[] var3_3, int var4_4, int var5_5) throws IOException {
        CUtility._assert(1 == var5_5 || 0 == var5_5 || 2 == var5_5 || 6 == var5_5 || 3 == var5_5 || 4 == var5_5 || 5 == var5_5);
        if (0 != CUtility.charncmp(this.m_input.m_line, 0, var1_1, 0, var1_1.length - 1)) {
            CError.parse_error(13, 0);
        }
        if (null == var3_3) {
            var3_3 = new char[1024];
            var4_4 = 0;
        }
        if (var4_4 >= var3_3.length) {
            var3_3 = CUtility.doubleSize(var3_3);
        }
        this.m_input.m_line_index = var1_1.length - 1;
        block9: while (true) {
            if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_input.getLine()) {
                    CError.parse_error(11, this.m_input.m_line_number);
                }
                if (0 != CUtility.charncmp(this.m_input.m_line, 0, var2_2, 0, var2_2.length - 1)) continue;
                this.m_input.m_line_index = var2_2.length - 1;
                switch (var5_5) {
                    case 0: {
                        this.m_spec.m_class_read = var4_4;
                        break;
                    }
                    case 1: {
                        this.m_spec.m_init_read = var4_4;
                        break;
                    }
                    case 2: {
                        this.m_spec.m_eof_read = var4_4;
                        break;
                    }
                    case 6: {
                        this.m_spec.m_eof_value_read = var4_4;
                        break;
                    }
                    case 3: {
                        this.m_spec.m_init_throw_read = var4_4;
                        break;
                    }
                    case 4: {
                        this.m_spec.m_yylex_throw_read = var4_4;
                        break;
                    }
                    case 5: {
                        this.m_spec.m_eof_throw_read = var4_4;
                        break;
                    }
                    default: {
                        CError.parse_error(13, this.m_input.m_line_number);
                    }
                }
                return var3_3;
            }
            while (true) {
                if (this.m_input.m_line_index < this.m_input.m_line_read) ** break;
                continue block9;
                var3_3[var4_4] = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
                if (++var4_4 < var3_3.length) continue;
                var3_3 = CUtility.doubleSize(var3_3);
            }
            break;
        }
    }

    private void userDeclare() throws IOException {
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        block14: while (!this.m_input.getLine()) {
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_read -= 2;
                System.arraycopy(this.m_input.m_line, 2, this.m_input.m_line, 0, this.m_input.m_line_read);
                this.m_input.m_pushback_line = true;
                if (0 == this.m_input.m_line_read || '\n' == this.m_input.m_line[0]) {
                    this.m_input.m_pushback_line = false;
                }
                return;
            }
            if (0 == this.m_input.m_line_read) continue;
            if ('%' == this.m_input.m_line[0]) {
                if (1 >= this.m_input.m_line_read) {
                    CError.parse_error(12, this.m_input.m_line_number);
                    continue;
                }
                switch (this.m_input.m_line[1]) {
                    case '{': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_class_code_dir, 0, this.m_class_code_dir.length - 1)) {
                            this.m_spec.m_class_code = this.packCode(this.m_class_code_dir, this.m_class_code_end_dir, this.m_spec.m_class_code, this.m_spec.m_class_read, 0);
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'c': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_char_dir, 0, this.m_char_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_char_dir.length;
                            this.m_spec.m_count_chars = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_class_dir, 0, this.m_class_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_class_dir.length;
                            this.m_spec.m_class_name = this.getName();
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_cup_dir, 0, this.m_cup_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_cup_dir.length;
                            this.m_spec.m_cup_compatible = true;
                            this.m_spec.m_implements_name = "java_cup.runtime.Scanner".toCharArray();
                            this.m_spec.m_function_name = "next_token".toCharArray();
                            this.m_spec.m_type_name = "java_cup.runtime.Symbol".toCharArray();
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'e': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_code_dir, 0, this.m_eof_code_dir.length - 1)) {
                            this.m_spec.m_eof_code = this.packCode(this.m_eof_code_dir, this.m_eof_code_end_dir, this.m_spec.m_eof_code, this.m_spec.m_eof_read, 2);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_value_code_dir, 0, this.m_eof_value_code_dir.length - 1)) {
                            this.m_spec.m_eof_value_code = this.packCode(this.m_eof_value_code_dir, this.m_eof_value_code_end_dir, this.m_spec.m_eof_value_code, this.m_spec.m_eof_value_read, 6);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_throw_code_dir, 0, this.m_eof_throw_code_dir.length - 1)) {
                            this.m_spec.m_eof_throw_code = this.packCode(this.m_eof_throw_code_dir, this.m_eof_throw_code_end_dir, this.m_spec.m_eof_throw_code, this.m_spec.m_eof_throw_read, 5);
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'f': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_function_dir, 0, this.m_function_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_function_dir.length;
                            this.m_spec.m_function_name = this.getName();
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_full_dir, 0, this.m_full_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_full_dir.length;
                            this.m_spec.m_dtrans_ncols = 256;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'i': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_integer_dir, 0, this.m_integer_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_integer_type = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_intwrap_dir, 0, this.m_intwrap_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_intwrap_type = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_init_code_dir, 0, this.m_init_code_dir.length - 1)) {
                            this.m_spec.m_init_code = this.packCode(this.m_init_code_dir, this.m_init_code_end_dir, this.m_spec.m_init_code, this.m_spec.m_init_read, 1);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_init_throw_code_dir, 0, this.m_init_throw_code_dir.length - 1)) {
                            this.m_spec.m_init_throw_code = this.packCode(this.m_init_throw_code_dir, this.m_init_throw_code_end_dir, this.m_spec.m_init_throw_code, this.m_spec.m_init_throw_read, 3);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_implements_dir, 0, this.m_implements_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_implements_dir.length;
                            this.m_spec.m_implements_name = this.getName();
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_ignorecase_dir, 0, this.m_ignorecase_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_ignorecase_dir.length;
                            this.m_spec.m_ignorecase = true;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'l': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_line_dir, 0, this.m_line_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_line_dir.length;
                            this.m_spec.m_count_lines = true;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'n': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_notunix_dir, 0, this.m_notunix_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_notunix_dir.length;
                            this.m_spec.m_unix = false;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'p': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_public_dir, 0, this.m_public_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_public_dir.length;
                            this.m_spec.m_public = true;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 's': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_state_dir, 0, this.m_state_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_state_dir.length;
                            this.saveStates();
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 't': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_type_dir, 0, this.m_type_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_type_dir.length;
                            this.m_spec.m_type_name = this.getName();
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'u': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_unicode_dir, 0, this.m_unicode_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_unicode_dir.length;
                            this.m_spec.m_dtrans_ncols = 65536;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                    case 'y': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_yyeof_dir, 0, this.m_yyeof_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_yyeof_dir.length;
                            this.m_spec.m_yyeof = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_yylex_throw_code_dir, 0, this.m_yylex_throw_code_dir.length - 1)) {
                            this.m_spec.m_yylex_throw_code = this.packCode(this.m_yylex_throw_code_dir, this.m_yylex_throw_code_end_dir, this.m_spec.m_yylex_throw_code, this.m_spec.m_yylex_throw_read, 4);
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        continue block14;
                    }
                }
                CError.parse_error(12, this.m_input.m_line_number);
                continue;
            }
            this.m_input.m_line_index = 0;
            this.saveMacro();
        }
    }

    private void userRules() throws IOException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        if (this.m_spec.m_verbose) {
            System.out.println("Creating NFA machine representation.");
        }
        this.m_makeNfa.allocate_BOL_EOF(this.m_spec);
        this.m_makeNfa.thompson(this, this.m_spec, this.m_input);
        this.m_simplifyNfa.simplify(this.m_spec);
        CUtility._assert(11 == this.m_spec.m_current_token);
        if (this.m_spec.m_verbose) {
            System.out.println("Creating DFA transition table.");
        }
        this.m_nfa2dfa.make_dfa(this, this.m_spec);
        if (this.m_spec.m_verbose) {
            System.out.println("Minimizing DFA transition table.");
        }
        this.m_minimize.min_dfa(this.m_spec);
    }

    private void printccl(CSet cSet) {
        System.out.print(" [");
        for (int i2 = 0; i2 < this.m_spec.m_dtrans_ncols; ++i2) {
            if (!cSet.contains(i2)) continue;
            System.out.print(this.interp_int(i2));
        }
        System.out.print(']');
    }

    private String plab(CNfa cNfa) {
        if (null == cNfa) {
            return new String("--");
        }
        int n2 = this.m_spec.m_nfa_states.indexOf(cNfa);
        return new Integer(n2).toString();
    }

    private String interp_int(int n2) {
        switch (n2) {
            case 8: {
                return new String("\\b");
            }
            case 9: {
                return new String("\\t");
            }
            case 10: {
                return new String("\\n");
            }
            case 12: {
                return new String("\\f");
            }
            case 13: {
                return new String("\\r");
            }
            case 32: {
                return new String("\\ ");
            }
        }
        return new Character((char)n2).toString();
    }

    void print_nfa() {
        CNfa cNfa;
        System.out.println("--------------------- NFA -----------------------");
        int n2 = this.m_spec.m_nfa_states.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            cNfa = (CNfa)this.m_spec.m_nfa_states.elementAt(i2);
            System.out.print("Nfa state " + this.plab(cNfa) + ": ");
            if (null == cNfa.m_next) {
                System.out.print("(TERMINAL)");
            } else {
                System.out.print("--> " + this.plab(cNfa.m_next));
                System.out.print("--> " + this.plab(cNfa.m_next2));
                switch (cNfa.m_edge) {
                    case -1: {
                        this.printccl(cNfa.m_set);
                        break;
                    }
                    case -3: {
                        System.out.print(" EPSILON ");
                        break;
                    }
                    default: {
                        System.out.print(" " + this.interp_int(cNfa.m_edge));
                    }
                }
            }
            if (0 == i2) {
                System.out.print(" (START STATE)");
            }
            if (null != cNfa.m_accept) {
                System.out.print(" accepting " + (0 != (cNfa.m_anchor & 1) ? "^" : "") + "<" + new String(cNfa.m_accept.m_action, 0, cNfa.m_accept.m_action_read) + ">" + (0 != (cNfa.m_anchor & 2) ? "$" : ""));
            }
            System.out.println();
        }
        Enumeration enumeration = this.m_spec.m_states.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n3 = (Integer)this.m_spec.m_states.get(string);
            CUtility._assert(null != string);
            CUtility._assert(null != n3);
            System.out.println("State \"" + string + "\" has identifying index " + n3.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            int n4 = n3;
            int n5 = this.m_spec.m_state_rules[n4].size();
            for (int i3 = 0; i3 < n5; ++i3) {
                cNfa = (CNfa)this.m_spec.m_state_rules[n4].elementAt(i3);
                System.out.print(this.m_spec.m_nfa_states.indexOf(cNfa) + " ");
            }
            System.out.println();
        }
        System.out.println("-------------------- NFA ----------------------");
    }

    SparseBitSet getStates() throws IOException {
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        SparseBitSet sparseBitSet = null;
        while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                return null;
            }
        }
        if ('<' == this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            sparseBitSet = new SparseBitSet();
            while (true) {
                int n2;
                String string;
                Integer n3;
                if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number);
                    return sparseBitSet;
                }
                block3: while (true) {
                    if (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                        do {
                            if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                        } while (!this.m_input.getLine());
                        CError.parse_error(11, this.m_input.m_line_number);
                        return sparseBitSet;
                    }
                    if (',' != this.m_input.m_line[this.m_input.m_line_index]) break;
                    ++this.m_input.m_line_index;
                }
                if ('>' == this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) {
                        this.m_advance_stop = true;
                    }
                    return sparseBitSet;
                }
                int n4 = this.m_input.m_line_index;
                while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index] && '>' != this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
                }
                if (null == (n3 = (Integer)this.m_spec.m_states.get(string = new String(this.m_input.m_line, n4, n2 = this.m_input.m_line_index - n4)))) {
                    System.out.println("Uninitialized State Name: " + string);
                    CError.parse_error(14, this.m_input.m_line_number);
                }
                sparseBitSet.set(n3);
            }
        }
        if (null == this.all_states) {
            this.all_states = new SparseBitSet();
            int n5 = this.m_spec.m_states.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                this.all_states.set(i2);
            }
        }
        if (this.m_input.m_line_index < this.m_input.m_line_read) {
            this.m_advance_stop = true;
        }
        return this.all_states;
    }

    private boolean expandMacro() {
        int n2;
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
            CError.parse_error(13, this.m_input.m_line_number);
            return false;
        }
        int n3 = this.m_input.m_line_index;
        int n4 = this.m_input.m_line_index + 1;
        if (n4 >= this.m_input.m_line_read) {
            CError.impos("Unfinished macro name");
            return false;
        }
        int n5 = n4;
        while ('}' != this.m_input.m_line[n4]) {
            if (++n4 < this.m_input.m_line_read) continue;
            CError.impos("Unfinished macro name at line " + this.m_input.m_line_number);
            return false;
        }
        int n6 = n4 - n5;
        int n7 = n4;
        if (0 == n6) {
            CError.impos("Nonexistent macro name");
            return false;
        }
        CUtility._assert(0 < n6);
        String string = new String(this.m_input.m_line, n5, n6);
        String string2 = (String)this.m_spec.m_macros.get(string);
        if (null == string2) {
            System.out.println("Error: Undefined macro \"" + string + "\".");
            CError.parse_error(8, this.m_input.m_line_number);
            return false;
        }
        char[] cArray = new char[this.m_input.m_line.length];
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n2] = this.m_input.m_line[n2];
            CUtility._assert(n2 < cArray.length);
        }
        if (n2 >= cArray.length) {
            cArray = CUtility.doubleSize(cArray);
        }
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            cArray[n2] = string2.charAt(i2);
            if (++n2 < cArray.length) continue;
            cArray = CUtility.doubleSize(cArray);
        }
        if (n2 >= cArray.length) {
            cArray = CUtility.doubleSize(cArray);
        }
        for (n4 = n7 + 1; n4 < this.m_input.m_line_read; ++n4) {
            cArray[n2] = this.m_input.m_line[n4];
            if (++n2 < cArray.length) continue;
            cArray = CUtility.doubleSize(cArray);
        }
        this.m_input.m_line = cArray;
        this.m_input.m_line_read = n2;
        return true;
    }

    private void saveMacro() {
        int n2;
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        int n3 = 0;
        while (CUtility.isspace(this.m_input.m_line[n3])) {
            if (++n3 < this.m_input.m_line_read) continue;
            return;
        }
        int n4 = n3;
        while (!CUtility.isspace(this.m_input.m_line[n3]) && '=' != this.m_input.m_line[n3]) {
            if (++n3 < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        int n5 = n3 - n4;
        if (0 == n5) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        while (CUtility.isspace(this.m_input.m_line[n3])) {
            if (++n3 < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        if ('=' == this.m_input.m_line[n3] && ++n3 >= this.m_input.m_line_read) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        while (CUtility.isspace(this.m_input.m_line[n3])) {
            if (++n3 < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        int n6 = n3;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!CUtility.isspace(this.m_input.m_line[n3]) || bl2 || bl3 || bl4) {
            if ('\"' == this.m_input.m_line[n3] && !bl4) {
                bl2 = !bl2;
            }
            if (!(bl4 = '\\' == this.m_input.m_line[n3] && false == bl4) && !bl2) {
                if ('[' == this.m_input.m_line[n3] && !bl3) {
                    bl3 = true;
                }
                if (']' == this.m_input.m_line[n3] && bl3) {
                    bl3 = false;
                }
            }
            if (++n3 < this.m_input.m_line_read) continue;
        }
        if (0 == (n2 = n3 - n6)) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        CUtility._assert(0 < n2);
        CUtility._assert(0 < n5);
        CUtility._assert(null != this.m_spec.m_macros);
        this.m_spec.m_macros.put(new String(this.m_input.m_line, n4, n5), new String(this.m_input.m_line, n6, n2));
    }

    private void saveStates() {
        CUtility._assert(null != this);
        CUtility._assert(null != this.m_outstream);
        CUtility._assert(null != this.m_input);
        CUtility._assert(null != this.m_tokens);
        CUtility._assert(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            return;
        }
        CUtility._assert('%' == this.m_input.m_line[0]);
        CUtility._assert('s' == this.m_input.m_line[1]);
        CUtility._assert(this.m_input.m_line_index <= this.m_input.m_line_read);
        CUtility._assert(0 <= this.m_input.m_line_index);
        CUtility._assert(0 <= this.m_input.m_line_read);
        if (this.m_input.m_line_index >= this.m_input.m_line_read) {
            return;
        }
        while (this.m_input.m_line_index < this.m_input.m_line_read) {
            while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                ++this.m_input.m_line_index;
                if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
                return;
            }
            int n2 = this.m_input.m_line_index;
            while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index]) {
                ++this.m_input.m_line_index;
                if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
            }
            int n3 = this.m_input.m_line_index - n2;
            this.m_spec.m_states.put(new String(this.m_input.m_line, n2, n3), new Integer(this.m_spec.m_states.size()));
            if (',' != this.m_input.m_line[this.m_input.m_line_index]) continue;
            ++this.m_input.m_line_index;
            if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
            return;
        }
    }

    private char expandEscape() {
        char c2;
        CUtility._assert(this.m_input.m_line_index < this.m_input.m_line_read);
        CUtility._assert(0 < this.m_input.m_line_read);
        CUtility._assert(0 <= this.m_input.m_line_index);
        if ('\\' != this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            return this.m_input.m_line[this.m_input.m_line_index - 1];
        }
        boolean bl2 = false;
        ++this.m_input.m_line_index;
        switch (this.m_input.m_line[this.m_input.m_line_index]) {
            case 'b': {
                ++this.m_input.m_line_index;
                return '\b';
            }
            case 't': {
                ++this.m_input.m_line_index;
                return '\t';
            }
            case 'n': {
                ++this.m_input.m_line_index;
                return '\n';
            }
            case 'f': {
                ++this.m_input.m_line_index;
                return '\f';
            }
            case 'r': {
                ++this.m_input.m_line_index;
                return '\r';
            }
            case '^': {
                ++this.m_input.m_line_index;
                char c3 = Character.toUpperCase(this.m_input.m_line[this.m_input.m_line_index]);
                if (c3 < '@' || c3 > 'Z') {
                    CError.parse_error(20, this.m_input.m_line_number);
                }
                c3 = (char)(c3 - 64);
                ++this.m_input.m_line_index;
                return c3;
            }
            case 'u': {
                bl2 = true;
            }
            case 'x': {
                ++this.m_input.m_line_index;
                char c4 = '\u0000';
                for (int i2 = 0; i2 < (bl2 ? 4 : 2) && CUtility.ishexdigit(this.m_input.m_line[this.m_input.m_line_index]); ++i2) {
                    c4 = (char)(c4 << 4);
                    c4 = (char)(c4 | CUtility.hex2bin(this.m_input.m_line[this.m_input.m_line_index]));
                    ++this.m_input.m_line_index;
                }
                return c4;
            }
        }
        if (!CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) {
            c2 = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        } else {
            c2 = '\u0000';
            for (int i3 = 0; i3 < 3 && CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index]); ++i3) {
                c2 = (char)(c2 << 3);
                c2 = (char)(c2 | CUtility.oct2bin(this.m_input.m_line[this.m_input.m_line_index]));
                ++this.m_input.m_line_index;
            }
        }
        return c2;
    }

    CAccept packAccept() throws IOException {
        int n2;
        char[] cArray;
        block23: {
            cArray = new char[1024];
            n2 = 0;
            CUtility._assert(null != this);
            CUtility._assert(null != this.m_outstream);
            CUtility._assert(null != this.m_input);
            CUtility._assert(null != this.m_tokens);
            CUtility._assert(null != this.m_spec);
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                CError.parse_error(11, this.m_input.m_line_number);
                return null;
            }
            while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                ++this.m_input.m_line_index;
                while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number);
                    return null;
                }
            }
            if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
                CError.parse_error(17, this.m_input.m_line_number);
            }
            int n3 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            block3: while (true) {
                cArray[n2] = this.m_input.m_line[this.m_input.m_line_index];
                if ((bl7 || bl6) && bl3) {
                    bl3 = false;
                } else if ((bl7 || bl6) && '\\' == this.m_input.m_line[this.m_input.m_line_index]) {
                    bl3 = true;
                } else if (!(bl7 || bl5 || bl4 || '\"' != this.m_input.m_line[this.m_input.m_line_index])) {
                    bl6 = !bl6;
                } else if (!(bl6 || bl5 || bl4 || '\'' != this.m_input.m_line[this.m_input.m_line_index])) {
                    boolean bl8 = bl7 = !bl7;
                }
                if (bl4) {
                    if (bl2 && '/' == this.m_input.m_line[this.m_input.m_line_index]) {
                        bl2 = false;
                        bl4 = false;
                    } else {
                        bl2 = '*' == this.m_input.m_line[this.m_input.m_line_index];
                    }
                } else if (!(bl5 || bl7 || bl6)) {
                    bl5 = bl2 && '/' == this.m_input.m_line[this.m_input.m_line_index];
                    bl4 = bl2 && '*' == this.m_input.m_line[this.m_input.m_line_index];
                    boolean bl9 = bl2 = '/' == this.m_input.m_line[this.m_input.m_line_index];
                }
                if (!(bl7 || bl6 || bl4 || bl5)) {
                    if ('{' == this.m_input.m_line[this.m_input.m_line_index]) {
                        ++n3;
                    } else if ('}' == this.m_input.m_line[this.m_input.m_line_index] && 0 == --n3) {
                        ++this.m_input.m_line_index;
                        break block23;
                    }
                }
                if (++n2 >= cArray.length) {
                    cArray = CUtility.doubleSize(cArray);
                }
                ++this.m_input.m_line_index;
                do {
                    if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                    bl2 = false;
                    bl5 = false;
                    if (!bl7 && !bl6) continue;
                    CError.parse_error(6, this.m_input.m_line_number);
                    bl6 = false;
                    bl7 = false;
                } while (!this.m_input.getLine());
                break;
            }
            CError.parse_error(16, this.m_input.m_line_number);
            return null;
        }
        CAccept cAccept = new CAccept(cArray, ++n2, this.m_input.m_line_number);
        CUtility._assert(null != cAccept);
        return cAccept;
    }

    /*
     * Unable to fully structure code
     */
    int advance() throws IOException {
        block19: {
            var1_1 = false;
            if (this.m_input.m_eof_reached) {
                this.m_spec.m_current_token = 11;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (1 == this.m_spec.m_current_token || this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_spec.m_in_quote) {
                    CError.parse_error(16, this.m_input.m_line_number);
                }
                do {
                    if (!this.m_advance_stop || this.m_input.m_line_index >= this.m_input.m_line_read) {
                        if (this.m_input.getLine()) {
                            this.m_spec.m_current_token = 11;
                            this.m_spec.m_lexeme = '\u0000';
                            return this.m_spec.m_current_token;
                        }
                        this.m_input.m_line_index = 0;
                    } else {
                        this.m_advance_stop = false;
                    }
                    while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                    }
                } while (this.m_input.m_line_index >= this.m_input.m_line_read);
            }
            CUtility._assert(this.m_input.m_line_index <= this.m_input.m_line_read);
            do lbl-1000:
            // 3 sources

            {
                block20: {
                    if (this.m_spec.m_in_quote || '{' != this.m_input.m_line[this.m_input.m_line_index]) break block20;
                    if (!this.expandMacro()) break block19;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) ** GOTO lbl-1000
                    this.m_spec.m_current_token = 1;
                    this.m_spec.m_lexeme = '\u0000';
                    return this.m_spec.m_current_token;
                }
                if ('\"' != this.m_input.m_line[this.m_input.m_line_index]) break block19;
                this.m_spec.m_in_quote = this.m_spec.m_in_quote == false;
                ++this.m_input.m_line_index;
            } while (this.m_input.m_line_index < this.m_input.m_line_read);
            this.m_spec.m_current_token = 1;
            this.m_spec.m_lexeme = '\u0000';
            return this.m_spec.m_current_token;
        }
        if (this.m_input.m_line_index > this.m_input.m_line_read) {
            System.out.println("m_input.m_line_index = " + this.m_input.m_line_index);
            System.out.println("m_input.m_line_read = " + this.m_input.m_line_read);
            CUtility._assert(this.m_input.m_line_index <= this.m_input.m_line_read);
        }
        var1_1 = '\\' == this.m_input.m_line[this.m_input.m_line_index];
        if (!this.m_spec.m_in_quote) {
            if (!this.m_spec.m_in_ccl && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                this.m_spec.m_current_token = 1;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (var1_1) {
                this.m_spec.m_lexeme = this.expandEscape();
            } else {
                this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
            }
        } else if (var1_1 && this.m_input.m_line_index + 1 < this.m_input.m_line_read && '\"' == this.m_input.m_line[this.m_input.m_line_index + 1]) {
            this.m_spec.m_lexeme = (char)34;
            this.m_input.m_line_index += 2;
        } else {
            this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        }
        var2_2 = (Integer)this.m_tokens.get(new Character(this.m_spec.m_lexeme));
        this.m_spec.m_current_token = this.m_spec.m_in_quote != false || true == var1_1 ? 12 : (null == var2_2 ? 12 : var2_2);
        if (6 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = true;
        }
        if (5 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = false;
        }
        return this.m_spec.m_current_token;
    }

    private void details() {
        System.out.println();
        System.out.println("\t** Macros **");
        Enumeration enumeration = this.m_spec.m_macros.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.m_spec.m_macros.get(string);
            CUtility._assert(null != string);
            CUtility._assert(null != string2);
            System.out.println("Macro name \"" + string + "\" has definition \"" + string2 + "\".");
        }
        System.out.println();
        System.out.println("\t** States **");
        Enumeration enumeration2 = this.m_spec.m_states.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            Integer n2 = (Integer)this.m_spec.m_states.get(string);
            CUtility._assert(null != string);
            CUtility._assert(null != n2);
            System.out.println("State \"" + string + "\" has identifying index " + n2.toString() + ".");
        }
        System.out.println();
        System.out.println("\t** Character Counting **");
        if (!this.m_spec.m_count_chars) {
            System.out.println("Character counting is off.");
        } else {
            CUtility._assert(this.m_spec.m_count_lines);
            System.out.println("Character counting is on.");
        }
        System.out.println();
        System.out.println("\t** Line Counting **");
        if (!this.m_spec.m_count_lines) {
            System.out.println("Line counting is off.");
        } else {
            CUtility._assert(this.m_spec.m_count_lines);
            System.out.println("Line counting is on.");
        }
        System.out.println();
        System.out.println("\t** Operating System Specificity **");
        if (!this.m_spec.m_unix) {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a newline, rather than \"\\n\".)");
        } else {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a newline, rather than \"\\r\\n\".)");
        }
        System.out.println();
        System.out.println("\t** Java CUP Compatibility **");
        if (!this.m_spec.m_cup_compatible) {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(Scanner implements java_cup.runtime.Scanner.)");
        } else {
            System.out.println("Not generating CUP compatible code.");
        }
        if (null != this.m_spec.m_dtrans_vector) {
            System.out.println();
            System.out.println("\t** DFA transition table **");
        }
    }

    void print_set(Vector vector) {
        int n2 = vector.size();
        if (0 == n2) {
            System.out.print("empty ");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            CNfa cNfa = (CNfa)vector.elementAt(i2);
            System.out.print(cNfa.m_label + " ");
        }
    }

    private void print_header() {
        int n2;
        int n3 = 0;
        System.out.println("/*---------------------- DFA -----------------------");
        Enumeration enumeration = this.m_spec.m_states.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n4 = (Integer)this.m_spec.m_states.get(string);
            CUtility._assert(null != string);
            CUtility._assert(null != n4);
            System.out.println("State \"" + string + "\" has identifying index " + n4.toString() + ".");
            n2 = n4;
            if (-1 != this.m_spec.m_state_dtrans[n2]) {
                System.out.println("\tStart index in transition table: " + this.m_spec.m_state_dtrans[n2]);
                continue;
            }
            System.out.println("\tNo associated transition states.");
        }
        for (n2 = 0; n2 < this.m_spec.m_dtrans_vector.size(); ++n2) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
            if (null == this.m_spec.m_accept_vector && null == this.m_spec.m_anchor_array) {
                if (null == cDTrans.m_accept) {
                    System.out.print(" * State " + n2 + " [nonaccepting]");
                } else {
                    System.out.print(" * State " + n2 + " [accepting, line " + cDTrans.m_accept.m_line_number + " <" + new String(cDTrans.m_accept.m_action, 0, cDTrans.m_accept.m_action_read) + ">]");
                    if (0 != cDTrans.m_anchor) {
                        System.out.print(" Anchor: " + (0 != (cDTrans.m_anchor & 1) ? "start " : "") + (0 != (cDTrans.m_anchor & 2) ? "end " : ""));
                    }
                }
            } else {
                CAccept cAccept = (CAccept)this.m_spec.m_accept_vector.elementAt(n2);
                if (null == cAccept) {
                    System.out.print(" * State " + n2 + " [nonaccepting]");
                } else {
                    System.out.print(" * State " + n2 + " [accepting, line " + cAccept.m_line_number + " <" + new String(cAccept.m_action, 0, cAccept.m_action_read) + ">]");
                    if (0 != this.m_spec.m_anchor_array[n2]) {
                        System.out.print(" Anchor: " + (0 != (this.m_spec.m_anchor_array[n2] & 1) ? "start " : "") + (0 != (this.m_spec.m_anchor_array[n2] & 2) ? "end " : ""));
                    }
                }
            }
            int n5 = -1;
            for (int i2 = 0; i2 < this.m_spec.m_dtrans_ncols; ++i2) {
                if (-1 == cDTrans.m_dtrans[i2]) continue;
                if (n5 != cDTrans.m_dtrans[i2]) {
                    System.out.println();
                    System.out.print(" *    goto " + cDTrans.m_dtrans[i2] + " on ");
                    n3 = 0;
                }
                String string = this.interp_int(i2);
                System.out.print(string);
                if (56 < (n3 += string.length())) {
                    System.out.println();
                    System.out.print(" *             ");
                    n3 = 0;
                }
                n5 = cDTrans.m_dtrans[i2];
            }
            System.out.println();
        }
        System.out.println(" */");
        System.out.println();
    }
}

