/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;

class Histogram {
    protected final int[][] matrix;
    protected final int totalWeight;
    protected final int[] values;
    protected final int[] counts;
    private static final long LOW32 = 0xFFFFFFFFL;
    private static double log2 = Math.log(2.0);
    private final BitMetric bitMetric = new BitMetric(){

        public double getBitLength(int n2) {
            return Histogram.this.getBitLength(n2);
        }
    };

    public Histogram(int[] nArray) {
        long[] lArray = Histogram.computeHistogram2Col(Histogram.maybeSort(nArray));
        int[][] nArray2 = Histogram.makeTable(lArray);
        this.values = nArray2[0];
        this.counts = nArray2[1];
        this.matrix = Histogram.makeMatrix(lArray);
        this.totalWeight = nArray.length;
        assert (this.assertWellFormed(nArray));
    }

    public Histogram(int[] nArray, int n2, int n3) {
        this(Histogram.sortedSlice(nArray, n2, n3));
    }

    public Histogram(int[][] nArray) {
        int n2;
        nArray = this.normalizeMatrix(nArray);
        this.matrix = nArray;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = nArray[i2].length - 1;
            n3 += n2;
            n4 += nArray[i2][0] * n2;
        }
        this.totalWeight = n4;
        long[] lArray = new long[n3];
        n2 = 0;
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            for (int i4 = 1; i4 < nArray[i3].length; ++i4) {
                lArray[n2++] = (long)nArray[i3][i4] << 32 | 0xFFFFFFFFL & (long)nArray[i3][0];
            }
        }
        assert (n2 == lArray.length);
        Arrays.sort(lArray);
        int[][] nArray2 = Histogram.makeTable(lArray);
        this.values = nArray2[1];
        this.counts = nArray2[0];
        assert (this.assertWellFormed(null));
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getRowCount() {
        return this.matrix.length;
    }

    public int getRowFrequency(int n2) {
        return this.matrix[n2][0];
    }

    public int getRowLength(int n2) {
        return this.matrix[n2].length - 1;
    }

    public int getRowValue(int n2, int n3) {
        return this.matrix[n2][n3 + 1];
    }

    public int getRowWeight(int n2) {
        return this.getRowFrequency(n2) * this.getRowLength(n2);
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalLength() {
        return this.values.length;
    }

    public int[] getAllValues() {
        return this.values;
    }

    public int[] getAllFrequencies() {
        return this.counts;
    }

    public int getFrequency(int n2) {
        int n3 = Arrays.binarySearch(this.values, n2);
        if (n3 < 0) {
            return 0;
        }
        assert (this.values[n3] == n2);
        return this.counts[n3];
    }

    public double getBitLength(int n2) {
        double d2 = (double)this.getFrequency(n2) / (double)this.getTotalWeight();
        return -Math.log(d2) / log2;
    }

    public double getRowBitLength(int n2) {
        double d2 = (double)this.getRowFrequency(n2) / (double)this.getTotalWeight();
        return -Math.log(d2) / log2;
    }

    public BitMetric getBitMetric() {
        return this.bitMetric;
    }

    public double getBitLength() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            d2 += this.getRowBitLength(i2) * (double)this.getRowWeight(i2);
        }
        assert (0.1 > Math.abs(d2 - this.getBitLength(this.bitMetric)));
        return d2;
    }

    public double getBitLength(BitMetric bitMetric) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            for (int i3 = 1; i3 < this.matrix[i2].length; ++i3) {
                d2 += (double)this.matrix[i2][0] * bitMetric.getBitLength(this.matrix[i2][i3]);
            }
        }
        return d2;
    }

    private static double round(double d2, double d3) {
        return (double)Math.round(d2 * d3) / d3;
    }

    public int[][] normalizeMatrix(int[][] object) {
        int n2;
        long[] lArray = new long[((int[][])object).length];
        for (int i2 = 0; i2 < ((int[][])object).length; ++i2) {
            if (object[i2].length <= 1 || (n2 = object[i2][0]) <= 0) continue;
            lArray[i2] = (long)n2 << 32 | (long)i2;
        }
        Arrays.sort(lArray);
        int[][] nArrayArray = new int[((int[][])object).length][];
        n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block14: {
                int[] nArray;
                block15: {
                    block13: {
                        if (n5 >= ((int[][])object).length) break block13;
                        long l2 = lArray[lArray.length - n5 - 1];
                        if (l2 == 0L) break block14;
                        nArray = object[(int)l2];
                        assert (l2 >>> 32 == (long)nArray[0]);
                        break block15;
                    }
                    nArray = new int[]{-1};
                }
                if (nArray[0] != n2 && n4 > n3) {
                    int n6;
                    int n7 = 0;
                    for (int i3 = n3; i3 < n4; ++i3) {
                        int[] nArray2 = nArrayArray[i3];
                        assert (nArray2[0] == n2);
                        n7 += nArray2.length - 1;
                    }
                    int[] nArray3 = new int[1 + n7];
                    nArray3[0] = n2;
                    int n8 = 1;
                    for (n6 = n3; n6 < n4; ++n6) {
                        int[] nArray4 = nArrayArray[n6];
                        assert (nArray4[0] == n2);
                        System.arraycopy(nArray4, 1, nArray3, n8, nArray4.length - 1);
                        n8 += nArray4.length - 1;
                    }
                    if (!Histogram.isSorted(nArray3, 1, true)) {
                        Arrays.sort(nArray3, 1, nArray3.length);
                        n6 = 2;
                        for (int i4 = 2; i4 < nArray3.length; ++i4) {
                            if (nArray3[i4] == nArray3[i4 - 1]) continue;
                            nArray3[n6++] = nArray3[i4];
                        }
                        if (n6 < nArray3.length) {
                            int[] nArray5 = new int[n6];
                            System.arraycopy(nArray3, 0, nArray5, 0, n6);
                            nArray3 = nArray5;
                        }
                    }
                    nArrayArray[n3++] = nArray3;
                    n4 = n3;
                }
                if (n5 == ((int[][])object).length) break;
                n2 = nArray[0];
                nArrayArray[n4++] = nArray;
            }
            ++n5;
        }
        assert (n3 == n4);
        object = nArrayArray;
        if (n3 < ((int[][])object).length) {
            nArrayArray = new int[n3][];
            System.arraycopy(object, 0, nArrayArray, 0, n3);
            object = nArrayArray;
        }
        return object;
    }

    public String[] getRowTitles(String string) {
        int n2 = this.getTotalLength();
        int n3 = this.getTotalWeight();
        String[] stringArray = new String[this.matrix.length];
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            int n6 = this.getRowFrequency(i2);
            int n7 = this.getRowLength(i2);
            int n8 = this.getRowWeight(i2);
            long l2 = ((long)(n4 += n8) * 100L + (long)(n3 / 2)) / (long)n3;
            long l3 = ((long)(n5 += n7) * 100L + (long)(n2 / 2)) / (long)n2;
            double d2 = this.getRowBitLength(i2);
            assert (0.1 > Math.abs(d2 - this.getBitLength(this.matrix[i2][1])));
            stringArray[i2] = string + "[" + i2 + "]" + " len=" + Histogram.round(d2, 10.0) + " (" + n6 + "*[" + n7 + "])" + " (" + n4 + ":" + l2 + "%)" + " [" + n5 + ":" + l3 + "%]";
        }
        return stringArray;
    }

    public void print(PrintStream printStream) {
        this.print("hist", printStream);
    }

    public void print(String string, PrintStream printStream) {
        this.print(string, this.getRowTitles(string), printStream);
    }

    public void print(String string, String[] stringArray, PrintStream printStream) {
        int n2 = this.getTotalLength();
        int n3 = this.getTotalWeight();
        double d2 = this.getBitLength();
        double d3 = d2 / (double)n3;
        double d4 = (double)n3 / (double)n2;
        String string2 = string + " len=" + Histogram.round(d2, 10.0) + " avgLen=" + Histogram.round(d3, 10.0) + " weight(" + n3 + ")" + " unique[" + n2 + "]" + " avgWeight(" + Histogram.round(d4, 100.0) + ")";
        if (stringArray == null) {
            printStream.println(string2);
        } else {
            printStream.println(string2 + " {");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.matrix.length; ++i2) {
                stringBuffer.setLength(0);
                stringBuffer.append("  " + stringArray[i2] + " {");
                for (int i3 = 1; i3 < this.matrix[i2].length; ++i3) {
                    stringBuffer.append(" " + this.matrix[i2][i3]);
                }
                stringBuffer.append(" }");
                printStream.println(stringBuffer);
            }
            printStream.println("}");
        }
    }

    private static int[][] makeMatrix(long[] lArray) {
        Arrays.sort(lArray);
        int[] nArray = new int[lArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = (int)(lArray[i2] >>> 32);
        }
        long[] lArray2 = Histogram.computeHistogram2Col(nArray);
        int[][] nArrayArray = new int[lArray2.length][];
        int n2 = 0;
        int n3 = 0;
        int n4 = nArrayArray.length;
        while (--n4 >= 0) {
            long l2 = lArray2[n3++];
            int n5 = (int)l2;
            int n6 = (int)(l2 >>> 32);
            int[] nArray2 = new int[1 + n6];
            nArray2[0] = n5;
            for (int i3 = 0; i3 < n6; ++i3) {
                long l3 = lArray[n2++];
                assert (l3 >>> 32 == (long)n5);
                nArray2[1 + i3] = (int)l3;
            }
            nArrayArray[n4] = nArray2;
        }
        assert (n2 == lArray.length);
        return nArrayArray;
    }

    private static int[][] makeTable(long[] lArray) {
        int[][] nArray = new int[2][lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            nArray[0][i2] = (int)lArray[i2];
            nArray[1][i2] = (int)(lArray[i2] >>> 32);
        }
        return nArray;
    }

    private static long[] computeHistogram2Col(int[] nArray) {
        switch (nArray.length) {
            case 0: {
                return new long[0];
            }
            case 1: {
                return new long[]{0x100000000L | 0xFFFFFFFFL & (long)nArray[0]};
            }
        }
        long[] lArray = null;
        boolean bl2 = true;
        while (true) {
            int n2 = -1;
            int n3 = ~nArray[0];
            int n4 = 0;
            for (int i2 = 0; i2 <= nArray.length; ++i2) {
                int n5 = i2 < nArray.length ? nArray[i2] : ~n3;
                if (n5 == n3) {
                    ++n4;
                    continue;
                }
                if (!bl2 && n4 != 0) {
                    lArray[n2] = (long)n4 << 32 | 0xFFFFFFFFL & (long)n3;
                }
                n3 = n5;
                n4 = 1;
                ++n2;
            }
            if (!bl2) break;
            lArray = new long[n2];
            bl2 = false;
        }
        return lArray;
    }

    private static int[][] regroupHistogram(int[][] nArray, int[] nArray2) {
        int n2;
        int n3;
        long l2 = 0L;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            l2 += (long)(nArray[i2].length - 1);
        }
        long l3 = 0L;
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            l3 += (long)nArray2[n3];
        }
        if (l3 > l2) {
            n3 = nArray2.length;
            long l4 = l2;
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                if (l4 < (long)nArray2[n2]) {
                    int[] nArray3 = new int[n2 + 1];
                    System.arraycopy(nArray2, 0, nArray3, 0, n2 + 1);
                    nArray2 = nArray3;
                    nArray2[n2] = (int)l4;
                    l4 = 0L;
                    break;
                }
                l4 -= (long)nArray2[n2];
            }
        } else {
            long l5 = l2 - l3;
            int[] nArray4 = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
            nArray4[nArray2.length] = (int)l5;
            nArray2 = nArray4;
        }
        int[][] nArrayArray = new int[nArray2.length][];
        int n4 = 0;
        int n5 = 1;
        n2 = nArray[n4].length;
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            int n6;
            int n7 = nArray2[i3];
            int[] nArray5 = new int[1 + n7];
            long l6 = 0L;
            nArrayArray[i3] = nArray5;
            for (int i4 = 1; i4 < nArray5.length; i4 += n6) {
                n6 = nArray5.length - i4;
                while (n5 == n2) {
                    n5 = 1;
                    n2 = nArray[++n4].length;
                }
                if (n6 > n2 - n5) {
                    n6 = n2 - n5;
                }
                l6 += (long)nArray[n4][0] * (long)n6;
                System.arraycopy(nArray[n4], n2 - n6, nArray5, i4, n6);
                n2 -= n6;
            }
            Arrays.sort(nArray5, 1, nArray5.length);
            nArray5[0] = (int)((l6 + (long)(n7 / 2)) / (long)n7);
        }
        assert (n5 == n2);
        assert (n4 == nArray.length - 1);
        return nArrayArray;
    }

    public static Histogram makeByteHistogram(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[4096];
        int[] nArray = new int[256];
        while ((n3 = inputStream.read(byArray)) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = byArray[n2] & 0xFF;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        int[][] nArray2 = new int[256][2];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2][0] = nArray[n2];
            nArray2[n2][1] = n2;
        }
        return new Histogram(nArray2);
    }

    private static int[] sortedSlice(int[] nArray, int n2, int n3) {
        if (n2 == 0 && n3 == nArray.length && Histogram.isSorted(nArray, 0, false)) {
            return nArray;
        }
        int[] nArray2 = new int[n3 - n2];
        System.arraycopy(nArray, n2, nArray2, 0, nArray2.length);
        Arrays.sort(nArray2);
        return nArray2;
    }

    private static boolean isSorted(int[] nArray, int n2, boolean bl2) {
        for (int i2 = n2 + 1; i2 < nArray.length; ++i2) {
            if (!(bl2 ? nArray[i2 - 1] >= nArray[i2] : nArray[i2 - 1] > nArray[i2])) continue;
            return false;
        }
        return true;
    }

    private static int[] maybeSort(int[] nArray) {
        if (!Histogram.isSorted(nArray, 0, false)) {
            nArray = (int[])nArray.clone();
            Arrays.sort(nArray);
        }
        return nArray;
    }

    private boolean assertWellFormed(int[] nArray) {
        return true;
    }

    public static interface BitMetric {
        public double getBitLength(int var1);
    }
}

