/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.sun.security.auth.PolicyFile;
import java.io.Serializable;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import sun.security.util.Debug;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private Map cachedPDs = new WeakHashMap();
    private Set principalSet;
    private Principal[] principals;
    private static final Debug debug = Debug.getInstance("combiner", "\t[SubjectDomainCombiner]");
    private static final boolean useJavaxPolicy = SubjectDomainCombiner.compatPolicy();
    private static final boolean allowCaching = useJavaxPolicy && SubjectDomainCombiner.cachePolicy();

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
        if (subject.isReadOnly()) {
            this.principalSet = subject.getPrincipals();
            this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
        }
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubjectFromDomainCombiner"));
        }
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (debug != null) {
            if (this.subject == null) {
                debug.println("null subject");
            } else {
                final Subject subject = this.subject;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        debug.println(subject.toString());
                        return null;
                    }
                });
            }
            SubjectDomainCombiner.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return protectionDomainArray2;
        }
        protectionDomainArray = SubjectDomainCombiner.optimize(protectionDomainArray);
        if (debug != null) {
            debug.println("after optimize");
            SubjectDomainCombiner.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null && protectionDomainArray2 == null) {
            return null;
        }
        if (useJavaxPolicy) {
            return this.combineJavaxPolicy(protectionDomainArray, protectionDomainArray2);
        }
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        boolean bl2 = true;
        Map map = this.cachedPDs;
        synchronized (map) {
            Object object;
            if (!this.subject.isReadOnly() && !((Object)this.subject.getPrincipals()).equals(this.principalSet)) {
                object = this.subject.getPrincipals();
                Set<Principal> set = object;
                synchronized (set) {
                    this.principalSet = new HashSet(object);
                }
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                ProtectionDomain protectionDomain = protectionDomainArray[i2];
                object = (ProtectionDomain)this.cachedPDs.get(protectionDomain);
                if (object == null) {
                    object = new ProtectionDomain(protectionDomain.getCodeSource(), protectionDomain.getPermissions(), protectionDomain.getClassLoader(), this.principals);
                    this.cachedPDs.put(protectionDomain, object);
                } else {
                    bl2 = false;
                }
                protectionDomainArray3[i2] = object;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i3 = 0; i3 < n2; ++i3) {
                debug.println("\tupdated[" + i3 + "] = " + SubjectDomainCombiner.printDomain(protectionDomainArray3[i3]));
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, n3);
            if (!bl2) {
                protectionDomainArray3 = SubjectDomainCombiner.optimize(protectionDomainArray3);
            }
        }
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i4 = 0; i4 < protectionDomainArray3.length; ++i4) {
                    debug.println("newDomain " + i4 + ": " + SubjectDomainCombiner.printDomain(protectionDomainArray3[i4]));
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain[] combineJavaxPolicy(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (!allowCaching) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        Map map = this.cachedPDs;
        synchronized (map) {
            Object object;
            if (!this.subject.isReadOnly() && !((Object)this.subject.getPrincipals()).equals(this.principalSet)) {
                Set<Principal> set = this.subject.getPrincipals();
                object = set;
                synchronized (object) {
                    this.principalSet = new HashSet<Principal>(set);
                }
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                object = protectionDomainArray[i2];
                ProtectionDomain protectionDomain = (ProtectionDomain)this.cachedPDs.get(object);
                if (protectionDomain == null) {
                    PermissionCollection permissionCollection;
                    Serializable serializable;
                    Enumeration<Permission> enumeration;
                    PermissionCollection permissionCollection2;
                    Permissions permissions = new Permissions();
                    Serializable serializable2 = permissionCollection2 = ((ProtectionDomain)object).getPermissions();
                    synchronized (serializable2) {
                        enumeration = permissionCollection2.elements();
                        while (enumeration.hasMoreElements()) {
                            serializable = enumeration.nextElement();
                            permissions.add((Permission)serializable);
                        }
                    }
                    serializable2 = ((ProtectionDomain)object).getCodeSource();
                    serializable = this.subject;
                    PermissionCollection permissionCollection3 = permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction((Subject)serializable, (CodeSource)serializable2){
                        final /* synthetic */ Subject val$finalS;
                        final /* synthetic */ CodeSource val$finalCs;
                        {
                            this.val$finalS = subject;
                            this.val$finalCs = codeSource;
                        }

                        public Object run() {
                            return Policy.getPolicy().getPermissions(this.val$finalS, this.val$finalCs);
                        }
                    });
                    synchronized (permissionCollection3) {
                        enumeration = permissionCollection.elements();
                        while (enumeration.hasMoreElements()) {
                            Permission permission = enumeration.nextElement();
                            if (permissions.implies(permission)) continue;
                            permissions.add(permission);
                            if (debug == null) continue;
                            debug.println("Adding perm " + permission + "\n");
                        }
                    }
                    protectionDomain = new ProtectionDomain((CodeSource)serializable2, permissions);
                    if (allowCaching) {
                        this.cachedPDs.put(object, protectionDomain);
                    }
                }
                protectionDomainArray3[i2] = protectionDomain;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i3 = 0; i3 < n2; ++i3) {
                debug.println("\tupdated[" + i3 + "] = " + protectionDomainArray3[i3]);
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, n3);
        }
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i4 = 0; i4 < protectionDomainArray3.length; ++i4) {
                    debug.println("newDomain " + i4 + ": " + protectionDomainArray3[i4].toString());
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    private static ProtectionDomain[] optimize(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[protectionDomainArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < protectionDomainArray.length; ++i2) {
            ProtectionDomain protectionDomain = protectionDomainArray[i2];
            if (protectionDomain == null) continue;
            boolean bl2 = false;
            for (int i3 = 0; i3 < n2 && !bl2; ++i3) {
                bl2 = protectionDomainArray2[i3] == protectionDomain;
            }
            if (bl2) continue;
            protectionDomainArray2[n2++] = protectionDomain;
        }
        if (n2 > 0 && n2 < protectionDomainArray.length) {
            ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2];
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, 0, protectionDomainArray3.length);
            protectionDomainArray2 = protectionDomainArray3;
        }
        return n2 == 0 || protectionDomainArray2.length == 0 ? null : protectionDomainArray2;
    }

    private static boolean cachePolicy() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("cache.auth.policy");
            }
        });
        if (string != null) {
            Boolean bl2 = new Boolean(string);
            return bl2;
        }
        return true;
    }

    private static boolean compatPolicy() {
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        if (!(policy instanceof PolicyFile)) {
            if (debug != null) {
                debug.println("Providing backwards compatibility for javax.security.auth.policy implementation: " + policy.toString());
            }
            return true;
        }
        return false;
    }

    private static void printInputDomains(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n2;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            debug.println("currentDomains null or 0 length");
        } else {
            for (n2 = 0; protectionDomainArray != null && n2 < protectionDomainArray.length; ++n2) {
                if (protectionDomainArray[n2] == null) {
                    debug.println("currentDomain " + n2 + ": SystemDomain");
                    continue;
                }
                debug.println("currentDomain " + n2 + ": " + SubjectDomainCombiner.printDomain(protectionDomainArray[n2]));
            }
        }
        if (protectionDomainArray2 == null || protectionDomainArray2.length == 0) {
            debug.println("assignedDomains null or 0 length");
        } else {
            debug.println("assignedDomains = ");
            for (n2 = 0; protectionDomainArray2 != null && n2 < protectionDomainArray2.length; ++n2) {
                if (protectionDomainArray2[n2] == null) {
                    debug.println("assignedDomain " + n2 + ": SystemDomain");
                    continue;
                }
                debug.println("assignedDomain " + n2 + ": " + SubjectDomainCombiner.printDomain(protectionDomainArray2[n2]));
            }
        }
    }

    private static String printDomain(final ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return "null";
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return protectionDomain.toString();
            }
        });
    }
}

