/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;
import sun.security.jca.JCAUtil;

public abstract class MessageDigestSpi {
    protected int engineGetDigestLength() {
        return 0;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset();
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.limit();
            this.engineUpdate(byArray, n2 + n3, n4 - n3);
            byteBuffer.position(n4);
        } else {
            int n5;
            int n6;
            byte[] byArray = new byte[JCAUtil.getTempArraySize(n6)];
            for (n6 = byteBuffer.remaining(); n6 > 0; n6 -= n5) {
                n5 = Math.min(n6, byArray.length);
                byteBuffer.get(byArray, 0, n5);
                this.engineUpdate(byArray, 0, n5);
            }
        }
    }

    protected abstract byte[] engineDigest();

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        byte[] byArray2 = this.engineDigest();
        if (n3 < byArray2.length) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n2 < byArray2.length) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

