/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;

public final class UID
implements Serializable {
    private static final long ONE_SECOND = 1000L;
    private static int hostUnique;
    private static boolean hostUniqueSet;
    private static final Object lock;
    private static long lastTime;
    private static short lastCount;
    private static final long serialVersionUID = 1086053664494604050L;
    private final int unique;
    private final long time;
    private final short count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        Object object = lock;
        synchronized (object) {
            if (!hostUniqueSet) {
                hostUnique = new SecureRandom().nextInt();
                hostUniqueSet = true;
            }
            this.unique = hostUnique;
            if (lastCount == Short.MAX_VALUE) {
                boolean bl2 = false;
                while (!bl2) {
                    long l2 = System.currentTimeMillis();
                    if (l2 < lastTime + 1000L) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    lastTime = l2;
                    lastCount = Short.MIN_VALUE;
                    bl2 = true;
                }
            }
            this.time = lastTime;
            short s2 = lastCount;
            lastCount = (short)(s2 + 1);
            this.count = s2;
        }
    }

    public UID(short s2) {
        this.unique = 0;
        this.time = 0L;
        this.count = s2;
    }

    private UID(int n2, long l2, short s2) {
        this.unique = n2;
        this.time = l2;
        this.count = s2;
    }

    public int hashCode() {
        return (int)this.time + this.count;
    }

    public boolean equals(Object object) {
        if (object instanceof UID) {
            UID uID = (UID)object;
            return this.unique == uID.unique && this.count == uID.count && this.time == uID.time;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.unique, 16) + ":" + Long.toString(this.time, 16) + ":" + Integer.toString(this.count, 16);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.unique);
        dataOutput.writeLong(this.time);
        dataOutput.writeShort(this.count);
    }

    public static UID read(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        long l2 = dataInput.readLong();
        short s2 = dataInput.readShort();
        return new UID(n2, l2, s2);
    }

    static {
        hostUniqueSet = false;
        lock = new Object();
        lastTime = System.currentTimeMillis();
        lastCount = Short.MIN_VALUE;
    }
}

