/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.SyncResolverImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

public class CachedRowSetWriter
implements TransactionalWriter,
Serializable {
    private transient Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private int[] keyCols;
    private Object[] params;
    private CachedRowSetReader reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;
    private CachedRowSetImpl crsResolve;
    private ArrayList status;
    private int iChangedValsInDbAndCRS;
    private int iChangedValsinDbOnly;

    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        int n2;
        int n3;
        int n4;
        boolean bl2 = false;
        boolean bl3 = false;
        PreparedStatement preparedStatement = null;
        this.iChangedValsInDbAndCRS = 0;
        this.iChangedValsinDbOnly = 0;
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)rowSetInternal;
        this.crsResolve = new CachedRowSetImpl();
        this.con = this.reader.connect(rowSetInternal);
        if (this.con == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.con.getAutoCommit()) {
            this.con.setAutoCommit(false);
        }
        this.con.setTransactionIsolation(cachedRowSetImpl.getTransactionIsolation());
        this.initSQLStatements(cachedRowSetImpl);
        RowSetMetaDataImpl rowSetMetaDataImpl = (RowSetMetaDataImpl)cachedRowSetImpl.getMetaData();
        RowSetMetaDataImpl rowSetMetaDataImpl2 = new RowSetMetaDataImpl();
        int n5 = rowSetMetaDataImpl.getColumnCount();
        int n6 = cachedRowSetImpl.size() + 1;
        this.status = new ArrayList(n6);
        this.status.add(0, null);
        rowSetMetaDataImpl2.setColumnCount(n5);
        for (n4 = 1; n4 <= n5; ++n4) {
            rowSetMetaDataImpl2.setColumnType(n4, rowSetMetaDataImpl.getColumnType(n4));
            rowSetMetaDataImpl2.setColumnName(n4, rowSetMetaDataImpl.getColumnName(n4));
            rowSetMetaDataImpl2.setNullable(n4, 2);
        }
        this.crsResolve.setMetaData(rowSetMetaDataImpl2);
        preparedStatement = this.con.prepareStatement(this.insertCmd);
        if (this.callerColumnCount < 1) {
            if (this.reader.getCloseConnection()) {
                this.con.close();
            }
            return true;
        }
        bl3 = cachedRowSetImpl.getShowDeleted();
        cachedRowSetImpl.setShowDeleted(true);
        cachedRowSetImpl.beforeFirst();
        n4 = 1;
        while (cachedRowSetImpl.next()) {
            if (cachedRowSetImpl.rowDeleted()) {
                bl2 = this.deleteOriginalRow(cachedRowSetImpl, this.crsResolve);
                if (bl2) {
                    this.status.add(n4, new Integer(1));
                } else {
                    this.status.add(n4, new Integer(3));
                }
            } else if (cachedRowSetImpl.rowInserted()) {
                bl2 = this.insertNewRow(cachedRowSetImpl, preparedStatement, this.crsResolve);
                if (bl2) {
                    this.status.add(n4, new Integer(2));
                } else {
                    this.status.add(n4, new Integer(3));
                }
            } else if (cachedRowSetImpl.rowUpdated()) {
                bl2 = this.updateOriginalRow(cachedRowSetImpl);
                if (bl2) {
                    this.status.add(n4, new Integer(0));
                } else {
                    this.status.add(n4, new Integer(3));
                }
            } else {
                n3 = cachedRowSetImpl.getMetaData().getColumnCount();
                this.status.add(n4, new Integer(3));
                this.crsResolve.moveToInsertRow();
                for (n2 = 0; n2 < n5; ++n2) {
                    this.crsResolve.updateNull(n2 + 1);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
            ++n4;
        }
        preparedStatement.close();
        cachedRowSetImpl.setShowDeleted(bl3);
        n3 = 0;
        for (n2 = 1; n2 < this.status.size(); ++n2) {
            if (this.status.get(n2).equals(new Integer(3))) continue;
            n3 = 1;
            break;
        }
        cachedRowSetImpl.beforeFirst();
        this.crsResolve.beforeFirst();
        if (n3 != 0) {
            SyncProviderException syncProviderException = new SyncProviderException(this.status.size() - 1 + " conflicts while synchronizing ");
            SyncResolverImpl syncResolverImpl = (SyncResolverImpl)syncProviderException.getSyncResolver();
            syncResolverImpl.setCachedRowSet(cachedRowSetImpl);
            syncResolverImpl.setCachedRowSetResolver(this.crsResolve);
            syncResolverImpl.setStatus(this.status);
            syncResolverImpl.setCachedRowSetWriter(this);
            throw syncProviderException;
        }
        return true;
    }

    private boolean updateOriginalRow(CachedRowSet cachedRowSet) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        try {
            Object object;
            this.updateWhere = this.buildWhereClause(this.updateWhere, resultSet);
            String string = this.selectCmd.toLowerCase();
            int n4 = string.indexOf("where");
            if (n4 != -1) {
                object = this.selectCmd.substring(0, n4);
                this.selectCmd = object;
            }
            PreparedStatement preparedStatement = this.con.prepareStatement(this.selectCmd + this.updateWhere, 1005, 1007);
            for (n2 = 0; n2 < this.keyCols.length; ++n2) {
                if (this.params[n2] == null) continue;
                preparedStatement.setObject(++n3, this.params[n2]);
            }
            try {
                preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
                preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = null;
            object = preparedStatement.executeQuery();
            if (object.next()) {
                if (object.next()) {
                    return true;
                }
                object.first();
                int n5 = 0;
                Vector<Integer> vector = new Vector<Integer>();
                String string2 = new String(this.updateCmd);
                boolean bl2 = true;
                Object object2 = null;
                boolean bl3 = true;
                boolean bl4 = true;
                this.crsResolve.moveToInsertRow();
                for (n2 = 1; n2 <= this.callerColumnCount; ++n2) {
                    Object object3 = resultSet.getObject(n2);
                    Object object4 = cachedRowSet.getObject(n2);
                    Object object5 = object.getObject(n2);
                    bl2 = true;
                    if (object5 == null && object3 != null) {
                        ++this.iChangedValsinDbOnly;
                        bl2 = false;
                        object2 = object5;
                    } else if (object5 != null && !object5.equals(object3)) {
                        ++this.iChangedValsinDbOnly;
                        bl2 = false;
                        object2 = object5;
                    } else if (object3 == null || object4 == null) {
                        if (!bl3 || !bl4) {
                            string2 = string2 + ", ";
                        }
                        string2 = string2 + cachedRowSet.getMetaData().getColumnName(n2);
                        vector.add(new Integer(n2));
                        string2 = string2 + " = ? ";
                        bl3 = false;
                    } else if (object3.equals(object4)) {
                        ++n5;
                    } else if (!object3.equals(object4) && cachedRowSet.columnUpdated(n2)) {
                        if (object5.equals(object3)) {
                            if (!bl4) {
                                string2 = string2 + ", ";
                            }
                            string2 = string2 + cachedRowSet.getMetaData().getColumnName(n2);
                            vector.add(new Integer(n2));
                            string2 = string2 + " = ? ";
                            bl4 = false;
                        } else {
                            bl2 = false;
                            object2 = object5;
                            ++this.iChangedValsInDbAndCRS;
                        }
                    }
                    if (!bl2) {
                        this.crsResolve.updateObject(n2, object2);
                        continue;
                    }
                    this.crsResolve.updateNull(n2);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
                if (!bl3 && vector.size() == 0 || n5 == this.callerColumnCount) {
                    return false;
                }
                if (this.iChangedValsInDbAndCRS != 0 || this.iChangedValsinDbOnly != 0) {
                    return true;
                }
                string2 = string2 + this.updateWhere;
                preparedStatement = this.con.prepareStatement(string2);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    Object object6 = cachedRowSet.getObject((Integer)vector.get(n2));
                    if (object6 != null) {
                        preparedStatement.setObject(n2 + 1, object6);
                        continue;
                    }
                    preparedStatement.setNull(n2 + 1, cachedRowSet.getMetaData().getColumnType(n2 + 1));
                }
                n3 = n2;
                for (n2 = 0; n2 < this.keyCols.length; ++n2) {
                    if (this.params[n2] == null) continue;
                    preparedStatement.setObject(++n3, this.params[n2]);
                }
                n2 = preparedStatement.executeUpdate();
                return false;
            }
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.crsResolve.moveToInsertRow();
            for (n2 = 1; n2 <= this.callerColumnCount; ++n2) {
                this.crsResolve.updateNull(n2);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    private boolean insertNewRow(CachedRowSet cachedRowSet, PreparedStatement preparedStatement, CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        int n2 = 0;
        int n3 = cachedRowSet.getMetaData().getColumnCount();
        try {
            for (n2 = 1; n2 <= n3; ++n2) {
                Object object = cachedRowSet.getObject(n2);
                if (object != null) {
                    preparedStatement.setObject(n2, object);
                    continue;
                }
                preparedStatement.setNull(n2, cachedRowSet.getMetaData().getColumnType(n2));
            }
            n2 = preparedStatement.executeUpdate();
            return false;
        }
        catch (SQLException sQLException) {
            this.crsResolve.moveToInsertRow();
            for (n2 = 1; n2 <= n3; ++n2) {
                this.crsResolve.updateNull(n2);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    private boolean deleteOriginalRow(CachedRowSet cachedRowSet, CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        int n2;
        int n3 = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, resultSet);
        PreparedStatement preparedStatement = this.con.prepareStatement(this.selectCmd + this.deleteWhere, 1005, 1007);
        for (n2 = 0; n2 < this.keyCols.length; ++n2) {
            if (this.params[n2] != null) {
                System.out.println("The value of params1 :" + this.params[n2]);
                preparedStatement.setObject(++n3, this.params[n2]);
                continue;
            }
            System.out.println("The value of params2 :" + this.params[n2]);
        }
        try {
            preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet2 = preparedStatement.executeQuery();
        if (resultSet2.next()) {
            if (resultSet2.next()) {
                return true;
            }
            resultSet2.first();
            boolean bl2 = false;
            cachedRowSetImpl.moveToInsertRow();
            for (n2 = 1; n2 <= cachedRowSet.getMetaData().getColumnCount(); ++n2) {
                if (!resultSet.getObject(n2).toString().equals(resultSet2.getObject(n2).toString())) {
                    bl2 = true;
                    cachedRowSetImpl.updateObject(n2, resultSet.getObject(n2));
                    continue;
                }
                cachedRowSetImpl.updateNull(n2);
            }
            cachedRowSetImpl.insertRow();
            cachedRowSetImpl.moveToCurrentRow();
            if (bl2) {
                return true;
            }
            String string = this.deleteCmd + this.deleteWhere;
            preparedStatement = this.con.prepareStatement(string);
            n3 = 0;
            for (n2 = 0; n2 < this.keyCols.length; ++n2) {
                if (this.params[n2] == null) continue;
                preparedStatement.setObject(++n3, this.params[n2]);
            }
            if (preparedStatement.executeUpdate() != 1) {
                return true;
            }
        } else {
            return true;
        }
        preparedStatement.close();
        return false;
    }

    public void setReader(CachedRowSetReader cachedRowSetReader) throws SQLException {
        this.reader = cachedRowSetReader;
    }

    public CachedRowSetReader getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet cachedRowSet) throws SQLException {
        int n2;
        this.callerMd = cachedRowSet.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String string = cachedRowSet.getTableName();
        if (string == null && ((string = this.callerMd.getTableName(1)) == null || string.length() == 0)) {
            throw new SQLException("writeData cannot determine the table name.");
        }
        String string2 = this.callerMd.getCatalogName(1);
        String string3 = this.callerMd.getSchemaName(1);
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        this.selectCmd = "SELECT ";
        for (n2 = 1; n2 <= this.callerColumnCount; ++n2) {
            this.selectCmd = this.selectCmd + this.callerMd.getColumnName(n2);
            this.selectCmd = n2 < this.callerMd.getColumnCount() ? this.selectCmd + ", " : this.selectCmd + " ";
        }
        this.selectCmd = this.selectCmd + "FROM " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.updateCmd = "UPDATE " + this.buildTableName(databaseMetaData, string2, string3, string);
        String string4 = this.updateCmd.toLowerCase();
        int n3 = string4.indexOf("where");
        if (n3 != -1) {
            this.updateCmd = this.updateCmd.substring(0, n3);
        }
        this.updateCmd = this.updateCmd + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.insertCmd = this.insertCmd + "(";
        for (n2 = 1; n2 <= this.callerColumnCount; ++n2) {
            this.insertCmd = this.insertCmd + this.callerMd.getColumnName(n2);
            this.insertCmd = n2 < this.callerMd.getColumnCount() ? this.insertCmd + ", " : this.insertCmd + ") VALUES (";
        }
        for (n2 = 1; n2 <= this.callerColumnCount; ++n2) {
            this.insertCmd = this.insertCmd + "?";
            this.insertCmd = n2 < this.callerColumnCount ? this.insertCmd + ", " : this.insertCmd + ")";
        }
        this.deleteCmd = "DELETE FROM " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.buildKeyDesc(cachedRowSet);
    }

    private String buildTableName(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        String string4 = new String();
        string = string.trim();
        string2 = string2.trim();
        string3 = string3.trim();
        if (databaseMetaData.isCatalogAtStart()) {
            if (string != null && string.length() > 0) {
                string4 = string4 + string + databaseMetaData.getCatalogSeparator();
            }
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2 + ".";
            }
            string4 = string4 + string3;
        } else {
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2 + ".";
            }
            string4 = string4 + string3;
            if (string != null && string.length() > 0) {
                string4 = string4 + databaseMetaData.getCatalogSeparator() + string;
            }
        }
        string4 = string4 + " ";
        return string4;
    }

    private void buildKeyDesc(CachedRowSet cachedRowSet) throws SQLException {
        this.keyCols = cachedRowSet.getKeyColumns();
        if (this.keyCols == null || this.keyCols.length == 0) {
            this.keyCols = new int[this.callerColumnCount];
            int n2 = 0;
            while (n2 < this.keyCols.length) {
                this.keyCols[n2++] = n2;
            }
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildWhereClause(String string, ResultSet resultSet) throws SQLException {
        string = "WHERE ";
        for (int i2 = 0; i2 < this.keyCols.length; ++i2) {
            if (i2 > 0) {
                string = string + "AND ";
            }
            string = string + this.callerMd.getColumnName(this.keyCols[i2]);
            this.params[i2] = resultSet.getObject(this.keyCols[i2]);
            string = resultSet.wasNull() ? string + " IS NULL " : string + " = ? ";
        }
        return string;
    }

    void updateResolvedConflictToDB(CachedRowSet cachedRowSet, Connection connection) throws SQLException {
        int n2;
        int n3;
        int n4;
        String string = "WHERE ";
        String string2 = " ";
        String string3 = "UPDATE ";
        int n5 = cachedRowSet.getMetaData().getColumnCount();
        int[] nArray = cachedRowSet.getKeyColumns();
        String string4 = "";
        string = this.buildWhereClause(string, cachedRowSet);
        if (nArray == null || nArray.length == 0) {
            nArray = new int[n5];
            n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4++] = n4;
            }
        }
        Object[] objectArray = new Object[nArray.length];
        string3 = "UPDATE " + this.buildTableName(connection.getMetaData(), cachedRowSet.getMetaData().getCatalogName(1), cachedRowSet.getMetaData().getSchemaName(1), cachedRowSet.getTableName());
        string3 = string3 + "SET ";
        n4 = 1;
        for (n3 = 1; n3 <= n5; ++n3) {
            if (!cachedRowSet.columnUpdated(n3)) continue;
            if (n4 == 0) {
                string4 = string4 + ", ";
            }
            string4 = string4 + cachedRowSet.getMetaData().getColumnName(n3);
            string4 = string4 + " = ? ";
            n4 = 0;
        }
        string3 = string3 + string4;
        string = "WHERE ";
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (n3 > 0) {
                string = string + "AND ";
            }
            string = string + cachedRowSet.getMetaData().getColumnName(nArray[n3]);
            objectArray[n3] = cachedRowSet.getObject(nArray[n3]);
            string = cachedRowSet.wasNull() ? string + " IS NULL " : string + " = ? ";
        }
        string3 = string3 + string;
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            if (!cachedRowSet.columnUpdated(n2 + 1)) continue;
            Object object = cachedRowSet.getObject(n2 + 1);
            if (object != null) {
                preparedStatement.setObject(++n3, object);
                continue;
            }
            preparedStatement.setNull(n2 + 1, cachedRowSet.getMetaData().getColumnType(n2 + 1));
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (objectArray[n2] == null) continue;
            preparedStatement.setObject(++n3, objectArray[n2]);
        }
        n2 = preparedStatement.executeUpdate();
    }

    public void commit() throws SQLException {
        this.con.commit();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void rollback() throws SQLException {
        this.con.rollback();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }
}

