/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.serializer.CharInfo;
import com.sun.org.apache.xml.internal.serializer.ElemContext;
import com.sun.org.apache.xml.internal.serializer.ElemDesc;
import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;
import com.sun.org.apache.xml.internal.serializer.OutputPropertyUtils;
import com.sun.org.apache.xml.internal.serializer.ToStream;
import com.sun.org.apache.xml.internal.utils.Trie;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToHTMLStream
extends ToStream {
    protected boolean m_inDTD = false;
    private boolean m_inBlockElem = false;
    protected static final CharInfo m_htmlcharInfo = CharInfo.getCharInfo(CharInfo.HTML_ENTITIES_RESOURCE, "html");
    static final Trie m_elementFlags = new Trie();
    private static final ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;

    public void setSpecialEscapeURLs(boolean bl2) {
        this.m_specialEscapeURLs = bl2;
    }

    public void setOmitMetaTag(boolean bl2) {
        this.m_omitMetaTag = bl2;
    }

    public void setOutputFormat(Properties properties) {
        this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", properties);
        this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", properties);
        super.setOutputFormat(properties);
    }

    private final boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private final boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    public static final ElemDesc getElemDesc(String string) {
        Object object = m_elementFlags.get(string);
        if (null != object) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public ToHTMLStream() {
        this.m_charInfo = m_htmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
    }

    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.setOmitXMLDeclaration(true);
        if (this.m_needToOutputDocTypeDecl) {
            String string = this.getDoctypeSystem();
            String string2 = this.getDoctypePublic();
            if (null != string || null != string2) {
                Writer writer = this.m_writer;
                try {
                    writer.write("<!DOCTYPE HTML");
                    if (null != string2) {
                        writer.write(" PUBLIC \"");
                        writer.write(string2);
                        writer.write(34);
                    }
                    if (null != string) {
                        if (null == string2) {
                            writer.write(" SYSTEM \"");
                        } else {
                            writer.write(34);
                        }
                        writer.write(string);
                        writer.write(34);
                    }
                    writer.write(62);
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public final void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ElemContext elemContext = this.m_elemContext;
        if (elemContext.m_startTagOpen) {
            this.closeStartTag();
            elemContext.m_startTagOpen = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (null != string && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        try {
            ElemDesc elemDesc = ToHTMLStream.getElemDesc(string3);
            int n2 = elemDesc.getFlags();
            if (this.m_doIndent) {
                boolean bl2;
                boolean bl3 = bl2 = (n2 & 8) != 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (null != elemContext.m_elementName && (!this.m_inBlockElem || bl2)) {
                    this.m_startNewLine = true;
                    this.indent();
                }
                boolean bl4 = this.m_inBlockElem = !bl2;
            }
            if (attributes != null) {
                this.addAttributes(attributes);
            }
            this.m_isprevtext = false;
            Writer writer = this.m_writer;
            writer.write(60);
            writer.write(string3);
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
            if ((n2 & 2) != 0) {
                this.m_elemContext = elemContext.push();
                this.m_elemContext.m_elementName = string3;
                this.m_elemContext.m_elementDesc = elemDesc;
                return;
            }
            this.m_elemContext = elemContext = elemContext.push(string, string2, string3);
            elemContext.m_elementDesc = elemDesc;
            boolean bl5 = elemContext.m_isRaw = (n2 & 0x100) != 0;
            if ((n2 & 0x400000) != 0) {
                this.closeStartTag();
                elemContext.m_startTagOpen = false;
                if (!this.m_omitMetaTag) {
                    if (this.m_doIndent) {
                        this.indent();
                    }
                    writer.write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                    String string4 = this.getEncoding();
                    String string5 = Encodings.getMimeEncoding(string4);
                    writer.write(string5);
                    writer.write("\">");
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (null != string && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        try {
            int n2;
            boolean bl2;
            ElemContext elemContext = this.m_elemContext;
            ElemDesc elemDesc = elemContext.m_elementDesc;
            int n3 = elemDesc.getFlags();
            boolean bl3 = bl2 = (n3 & 2) != 0;
            if (this.m_doIndent) {
                boolean bl4 = (n3 & 8) != 0;
                n2 = 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (this.m_doIndent && (!this.m_inBlockElem || bl4)) {
                    this.m_startNewLine = true;
                    n2 = 1;
                }
                if (!elemContext.m_startTagOpen && n2 != 0) {
                    this.indent(elemContext.m_currentElemDepth - 1);
                }
                this.m_inBlockElem = !bl4;
            }
            Writer writer = this.m_writer;
            if (!elemContext.m_startTagOpen) {
                writer.write("</");
                writer.write(string3);
                writer.write(62);
            } else {
                if (this.m_tracer != null) {
                    super.fireStartElem(string3);
                }
                if ((n2 = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n2);
                    this.m_attributes.clear();
                }
                if (!bl2) {
                    writer.write("></");
                    writer.write(string3);
                    writer.write(62);
                } else {
                    writer.write(62);
                }
            }
            if ((n3 & 0x200000) != 0) {
                this.m_ispreserve = true;
            }
            this.m_isprevtext = false;
            if (this.m_tracer != null) {
                super.fireEndElem(string3);
            }
            if (bl2) {
                this.m_elemContext = elemContext.m_prev;
                return;
            }
            if (!elemContext.m_startTagOpen && this.m_doIndent && !this.m_preserves.isEmpty()) {
                this.m_preserves.pop();
            }
            this.m_elemContext = elemContext.m_prev;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void processAttribute(Writer writer, String string, String string2, ElemDesc elemDesc) throws IOException {
        writer.write(32);
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc != null && elemDesc.isAttrFlagSet(string, 4)) {
            writer.write(string);
        } else {
            writer.write(string);
            writer.write("=\"");
            if (elemDesc != null && elemDesc.isAttrFlagSet(string, 2)) {
                this.writeAttrURI(writer, string2, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(writer, string2, this.getEncoding());
            }
            writer.write(34);
        }
    }

    private boolean isASCIIDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static String makeHHString(int n2) {
        String string = Integer.toHexString(n2).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private boolean isHHSign(String string) {
        boolean bl2 = true;
        try {
            char c2 = (char)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        return bl2;
    }

    public void writeAttrURI(Writer writer, String string, boolean bl2) throws IOException {
        int n2 = string.length();
        if (n2 > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n3 = 0;
        int n4 = 0;
        char c2 = '\u0000';
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = cArray[i2];
            if (c2 < ' ' || c2 > '~') {
                if (n4 > 0) {
                    writer.write(cArray, n3, n4);
                    n4 = 0;
                }
                if (bl2) {
                    int n5;
                    int n6;
                    int n7;
                    if (c2 <= '\u007f') {
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(c2));
                    } else if (c2 <= '\u07ff') {
                        n7 = c2 >> 6 | 0xC0;
                        n6 = c2 & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n7));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n6));
                    } else if (ToHTMLStream.isUTF16Surrogate(c2)) {
                        n7 = c2 & 0x3FF;
                        n6 = (n7 & 0x3C0) >> 6;
                        n5 = n6 + 1;
                        int n8 = (n7 & 0x3C) >> 2;
                        int n9 = (n7 & 3) << 4 & 0x30;
                        c2 = cArray[++i2];
                        int n10 = c2 & 0x3FF;
                        int n11 = n10 & 0x3F;
                        int n12 = 0xF0 | n5 >> 2;
                        int n13 = 0x80 | (n5 & 3) << 4 & 0x30 | n8;
                        int n14 = 0x80 | (n9 |= (n10 & 0x3C0) >> 6);
                        int n15 = 0x80 | n11;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n12));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n13));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n14));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n15));
                    } else {
                        n7 = c2 >> 12 | 0xE0;
                        n6 = (c2 & 0xFC0) >> 6 | 0x80;
                        n5 = c2 & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n7));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n6));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n5));
                    }
                } else if (this.escapingNotNeeded(c2)) {
                    writer.write(c2);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(c2));
                    writer.write(59);
                }
                n3 = i2 + 1;
                continue;
            }
            if (c2 == '\"') {
                if (n4 > 0) {
                    writer.write(cArray, n3, n4);
                    n4 = 0;
                }
                if (bl2) {
                    writer.write("%22");
                } else {
                    writer.write("&quot;");
                }
                n3 = i2 + 1;
                continue;
            }
            ++n4;
        }
        if (n4 > 1) {
            if (n3 == 0) {
                writer.write(string);
            } else {
                writer.write(cArray, n3, n4);
            }
        } else if (n4 == 1) {
            writer.write(c2);
        }
    }

    public void writeAttrString(Writer writer, String string, String string2) throws IOException {
        int n2 = string.length();
        if (n2 > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n3 = 0;
        int n4 = 0;
        char c2 = '\u0000';
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            c2 = cArray[i2];
            if (this.escapingNotNeeded(c2) && !this.m_charInfo.isSpecialAttrChar(c2)) {
                ++n4;
                continue;
            }
            if ('<' == c2 || '>' == c2) {
                ++n4;
                continue;
            }
            if ('&' == c2 && i2 + 1 < n2 && '{' == cArray[i2 + 1]) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                writer.write(cArray, n3, n4);
                n4 = 0;
            }
            if (i2 != (n5 = this.accumDefaultEntity(writer, c2, i2, cArray, n2, false, false))) {
                i2 = n5 - 1;
            } else {
                String string3;
                if (ToHTMLStream.isUTF16Surrogate(c2)) {
                    this.writeUTF16Surrogate(c2, cArray, i2, n2);
                    ++i2;
                }
                if (null != (string3 = this.m_charInfo.getEntityNameForChar(c2))) {
                    writer.write(38);
                    writer.write(string3);
                    writer.write(59);
                } else if (this.escapingNotNeeded(c2)) {
                    writer.write(c2);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(c2));
                    writer.write(59);
                }
            }
            n3 = i2 + 1;
        }
        if (n4 > 1) {
            if (n3 == 0) {
                writer.write(string);
            } else {
                writer.write(cArray, n3, n4);
            }
        } else if (n4 == 1) {
            writer.write(c2);
        }
    }

    public final void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_elemContext.m_isRaw) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                this.writeNormalizedChars(cArray, n2, n3, false, this.m_lineSepUse);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n2, n3);
                }
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        }
        super.characters(cArray, n2, n3);
    }

    public final void cdata(char[] cArray, int n2, int n3) throws SAXException {
        if (null != this.m_elemContext.m_elementName && (this.m_elemContext.m_elementName.equalsIgnoreCase("SCRIPT") || this.m_elemContext.m_elementName.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writeNormalizedChars(cArray, n2, n3, true, this.m_lineSepUse);
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n2, n3);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                writer.write(string2);
                writer.write(62);
                if (this.m_elemContext.m_currentElemDepth <= 0) {
                    this.outputLineSep();
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public final void entityReference(String string) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void processAttributes(Writer writer, int n2) throws IOException, SAXException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.processAttribute(writer, this.m_attributes.getQName(i2), this.m_attributes.getValue(i2), this.m_elemContext.m_elementDesc);
        }
    }

    protected void closeStartTag() throws SAXException {
        try {
            int n2;
            if (this.m_tracer != null) {
                super.fireStartElem(this.m_elemContext.m_elementName);
            }
            if ((n2 = this.m_attributes.getLength()) > 0) {
                this.processAttributes(this.m_writer, n2);
                this.m_attributes.clear();
            }
            this.m_writer.write(62);
            if (this.m_cdataSectionElements != null) {
                this.m_elemContext.m_isCdataSection = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected synchronized void init(OutputStream outputStream, Properties properties) throws UnsupportedEncodingException {
        if (null == properties) {
            properties = OutputPropertiesFactory.getDefaultMethodProperties("html");
        }
        super.init(outputStream, properties, false);
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Properties properties = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("html") : this.m_format;
            this.init(outputStream, properties, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToHTMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        super.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void addUniqueAttribute(String string, String string2, int n2) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if ((n2 & 1) > 0 && ToHTMLStream.m_htmlcharInfo.onlyQuotAmpLtGt) {
                writer.write(32);
                writer.write(string);
                writer.write("=\"");
                writer.write(string2);
                writer.write(34);
            } else if ((n2 & 2) > 0 && (string2.length() == 0 || string2.equalsIgnoreCase(string))) {
                writer.write(32);
                writer.write(string);
            } else {
                writer.write(32);
                writer.write(string);
                writer.write("=\"");
                if ((n2 & 4) > 0) {
                    this.writeAttrURI(writer, string2, this.m_specialEscapeURLs);
                } else {
                    this.writeAttrString(writer, string2, this.getEncoding());
                }
                writer.write(34);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        super.comment(cArray, n2, n3);
    }

    public boolean reset() {
        boolean bl2 = super.reset();
        if (!bl2) {
            return false;
        }
        this.initToHTMLStream();
        return true;
    }

    private void initToHTMLStream() {
        this.m_inBlockElem = false;
        this.m_inDTD = false;
        this.m_omitMetaTag = false;
        this.m_specialEscapeURLs = true;
    }

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        m_elementFlags.put("FONT", new ElemDesc(4096));
        m_elementFlags.put("S", new ElemDesc(4096));
        m_elementFlags.put("STRIKE", new ElemDesc(4096));
        m_elementFlags.put("U", new ElemDesc(4096));
        m_elementFlags.put("NOBR", new ElemDesc(4096));
        m_elementFlags.put("IFRAME", new ElemDesc(56));
        m_elementFlags.put("LAYER", new ElemDesc(56));
        m_elementFlags.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }
}

