/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpMibOid
extends SnmpMibNode
implements Serializable {
    private NonSyncVector children = new NonSyncVector(1);
    private int nbChildren = 0;

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpStatusException snmpStatusException = new SnmpStatusException(225);
            snmpMibSubRequest.registerGetException(snmpVarBind, snmpStatusException);
        }
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpStatusException snmpStatusException = new SnmpStatusException(6);
            snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
        }
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpStatusException snmpStatusException = new SnmpStatusException(6);
            snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
        }
    }

    void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n2, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n3 = lArray.length;
        Object var6_6 = null;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        if (n2 > n3) {
            throw noSuchObjectException;
        }
        if (n2 == n3) {
            throw noSuchInstanceException;
        }
        SnmpMibNode snmpMibNode = this.getChild(lArray[n2]);
        if (snmpMibNode == null) {
            snmpRequestTree.add(this, n2, snmpVarBind);
        } else {
            snmpMibNode.findHandlingNode(snmpVarBind, lArray, n2 + 1, snmpRequestTree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n2, int n3, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker) throws SnmpStatusException {
        int n4 = lArray.length;
        Object var8_8 = null;
        long[] lArray2 = null;
        if (snmpRequestTree == null) {
            throw noSuchObjectException;
        }
        Object object = snmpRequestTree.getUserData();
        int n5 = snmpRequestTree.getRequestPduVersion();
        if (n2 >= n4) {
            long[] lArray3 = new long[]{this.getNextVarId(-1L, object, n5)};
            lArray2 = this.findNextHandlingNode(snmpVarBind, lArray3, 0, n3, snmpRequestTree, acmChecker);
            return lArray2;
        }
        long[] lArray4 = new long[1];
        long l2 = lArray[n2];
        while (true) {
            try {
                SnmpMibNode snmpMibNode = this.getChild(l2);
                if (snmpMibNode == null) {
                    throw noSuchObjectException;
                }
                acmChecker.add(n3, l2);
                try {
                    lArray2 = snmpMibNode.findNextHandlingNode(snmpVarBind, lArray, n2 + 1, n3 + 1, snmpRequestTree, acmChecker);
                }
                finally {
                    acmChecker.remove(n3);
                }
                lArray2[n3] = l2;
                return lArray2;
            }
            catch (SnmpStatusException snmpStatusException) {
                lArray4[0] = l2 = this.getNextVarId(l2, object, n5);
                n2 = 1;
                lArray = lArray4;
                continue;
            }
            break;
        }
    }

    public void getRootOid(Vector vector) {
        if (this.nbChildren != 1) {
            return;
        }
        vector.addElement(new Integer(this.varList[0]));
        ((SnmpMibNode)this.children.firstElement()).getRootOid(vector);
    }

    public void registerNode(String string, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        SnmpOid snmpOid = new SnmpOid(string);
        this.registerNode(snmpOid.longValue(), 0, snmpMibNode);
    }

    void registerNode(long[] lArray, int n2, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        if (n2 >= lArray.length) {
            throw new IllegalAccessException();
        }
        long l2 = lArray[n2];
        int n3 = this.retrieveIndex(l2);
        if (n3 == this.nbChildren) {
            ++this.nbChildren;
            this.varList = new int[this.nbChildren];
            this.varList[0] = (int)l2;
            n3 = 0;
            if (n2 + 1 == lArray.length) {
                this.children.insertElementAt(snmpMibNode, n3);
                return;
            }
            SnmpMibOid snmpMibOid = new SnmpMibOid();
            this.children.insertElementAt(snmpMibOid, n3);
            snmpMibOid.registerNode(lArray, n2 + 1, snmpMibNode);
            return;
        }
        if (n3 == -1) {
            int[] nArray = new int[this.nbChildren + 1];
            nArray[this.nbChildren] = (int)l2;
            System.arraycopy(this.varList, 0, nArray, 0, this.nbChildren);
            this.varList = nArray;
            ++this.nbChildren;
            SnmpMibNode.sort(this.varList);
            int n4 = this.retrieveIndex(l2);
            this.varList[n4] = (int)l2;
            if (n2 + 1 == lArray.length) {
                this.children.insertElementAt(snmpMibNode, n4);
                return;
            }
            SnmpMibOid snmpMibOid = new SnmpMibOid();
            this.children.insertElementAt(snmpMibOid, n4);
            snmpMibOid.registerNode(lArray, n2 + 1, snmpMibNode);
            return;
        }
        SnmpMibNode snmpMibNode2 = (SnmpMibNode)this.children.elementAt(n3);
        if (n2 + 1 == lArray.length) {
            if (snmpMibNode2 == snmpMibNode) {
                return;
            }
            if (snmpMibNode2 != null && snmpMibNode != null) {
                if (snmpMibNode instanceof SnmpMibGroup) {
                    ((SnmpMibOid)snmpMibNode2).exportChildren((SnmpMibOid)snmpMibNode);
                    this.children.setElementAt(snmpMibNode, n3);
                    return;
                }
                if (snmpMibNode instanceof SnmpMibOid && snmpMibNode2 instanceof SnmpMibGroup) {
                    ((SnmpMibOid)snmpMibNode).exportChildren((SnmpMibOid)snmpMibNode2);
                    return;
                }
                if (snmpMibNode instanceof SnmpMibOid) {
                    ((SnmpMibOid)snmpMibNode2).exportChildren((SnmpMibOid)snmpMibNode);
                    this.children.setElementAt(snmpMibNode, n3);
                    return;
                }
            }
            this.children.setElementAt(snmpMibNode, n3);
            return;
        }
        if (snmpMibNode2 == null) {
            throw new IllegalAccessException();
        }
        ((SnmpMibOid)snmpMibNode2).registerNode(lArray, n2 + 1, snmpMibNode);
    }

    void exportChildren(SnmpMibOid snmpMibOid) throws IllegalAccessException {
        if (snmpMibOid == null) {
            return;
        }
        long[] lArray = new long[1];
        for (int i2 = 0; i2 < this.nbChildren; ++i2) {
            SnmpMibNode snmpMibNode = (SnmpMibNode)this.children.elementAt(i2);
            if (snmpMibNode == null) continue;
            lArray[0] = this.varList[i2];
            snmpMibOid.registerNode(lArray, 0, snmpMibNode);
        }
    }

    SnmpMibNode getChild(long l2) throws SnmpStatusException {
        int n2 = this.getInsertAt(l2);
        if (n2 >= this.nbChildren) {
            throw noSuchObjectException;
        }
        if (this.varList[n2] != (int)l2) {
            throw noSuchObjectException;
        }
        SnmpMibNode snmpMibNode = null;
        try {
            snmpMibNode = (SnmpMibNode)this.children.elementAtNonSync(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw noSuchObjectException;
        }
        if (snmpMibNode == null) {
            throw noSuchInstanceException;
        }
        return snmpMibNode;
    }

    private int retrieveIndex(long l2) {
        int n2 = 0;
        int n3 = (int)l2;
        if (this.varList == null || this.varList.length < 1) {
            return this.nbChildren;
        }
        int n4 = this.varList.length - 1;
        int n5 = n2 + (n4 - n2) / 2;
        int n6 = 0;
        while (n2 <= n4) {
            n6 = this.varList[n5];
            if (n3 == n6) {
                return n5;
            }
            if (n6 < n3) {
                n2 = n5 + 1;
            } else {
                n4 = n5 - 1;
            }
            n5 = n2 + (n4 - n2) / 2;
        }
        return -1;
    }

    private int getInsertAt(long l2) {
        int n2 = 0;
        int n3 = (int)l2;
        if (this.varList == null) {
            return -1;
        }
        int n4 = this.varList.length - 1;
        int n5 = 0;
        int n6 = n2 + (n4 - n2) / 2;
        while (n2 <= n4) {
            n5 = this.varList[n6];
            if (n3 == n5) {
                return n6;
            }
            if (n5 < n3) {
                n2 = n6 + 1;
            } else {
                n4 = n6 - 1;
            }
            n6 = n2 + (n4 - n2) / 2;
        }
        return n6;
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n2) {
            super(n2);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n2) {
            return this.elementData[n2];
        }
    }
}

