/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class ByteComponentRaster
extends SunWritableRaster {
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected byte[] data;
    int type;
    private int maxX;
    private int maxY;

    private static native void initIDs();

    public ByteComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteComponentRaster byteComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteComponentRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteComponentRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (dataBufferByte.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for ByteComponentRasters must only have 1 bank.");
        }
        int n2 = dataBufferByte.getOffset();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.type = 1;
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            this.dataOffsets = componentSampleModel.getBandOffsets();
            int n3 = rectangle.x - point.x;
            int n4 = rectangle.y - point.y;
            int n5 = 0;
            while (n5 < this.getNumDataElements()) {
                int n6 = n5++;
                this.dataOffsets[n6] = this.dataOffsets[n6] + (n2 + n3 * this.pixelStride + n4 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.type = 7;
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = n2;
            int n7 = rectangle.x - point.x;
            int n8 = rectangle.y - point.y;
            this.dataOffsets[0] = this.dataOffsets[0] + (n7 * this.pixelStride + n8 * this.scanlineStride);
        } else {
            throw new RasterFormatException("IntegerComponentRasters must have ComponentSampleModel or SinglePixelPackedSampleModel");
        }
        this.bandOffset = this.dataOffsets[0];
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            byArray[i2] = this.data[this.dataOffsets[i2] + n4];
        }
        return byArray;
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[n4 * n5 * this.numDataElements] : (byte[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                for (int i2 = 0; i2 < this.numDataElements; ++i2) {
                    byArray[n7++] = this.data[this.dataOffsets[i2] + n9];
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return byArray;
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n5];
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(this.data, n7, byArray, 0, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(this.data, n7, byArray, n8, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    byArray[n8++] = this.data[n11];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n5];
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                for (int i2 = 0; i2 < this.numDataElements; ++i2) {
                    byArray[n7++] = this.data[this.dataOffsets[i2] + n9];
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return byArray;
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            this.data[this.dataOffsets[i2] + n4] = byArray[i2];
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = raster.getMinX() + n2;
        int n5 = raster.getMinY() + n3;
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.maxX || n5 + n7 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n4, n5, n6, n7, raster);
    }

    private void setDataElements(int n2, int n3, int n4, int n5, Raster raster) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        Object object = null;
        if (raster instanceof ByteComponentRaster) {
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
            byte[] byArray = byteComponentRaster.getDataStorage();
            if (this.numDataElements == 1) {
                int n8 = byteComponentRaster.getDataOffset(0);
                int n9 = byteComponentRaster.getScanlineStride();
                int n10 = n8;
                int n11 = this.dataOffsets[0] + (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
                if (this.pixelStride == byteComponentRaster.getPixelStride()) {
                    n4 *= this.pixelStride;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        System.arraycopy(byArray, n10, this.data, n11, n4);
                        n10 += n9;
                        n11 += this.scanlineStride;
                    }
                    this.notifyChanged();
                    return;
                }
            }
        }
        for (int i3 = 0; i3 < n5; ++i3) {
            object = raster.getDataElements(n6, n7 + i3, n4, 1, object);
            this.setDataElements(n2, n3 + i3, n4, 1, object);
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        if (this.numDataElements == 1) {
            int n8 = 0;
            int n9 = n6 + this.dataOffsets[0];
            for (int i2 = 0; i2 < n5; ++i2) {
                int n10 = n6;
                System.arraycopy(byArray, n8, this.data, n9, n4);
                n8 += n4;
                n9 += this.scanlineStride;
            }
            this.notifyChanged();
            return;
        }
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n6;
            int n13 = 0;
            while (n13 < n4) {
                for (int i3 = 0; i3 < this.numDataElements; ++i3) {
                    this.data[this.dataOffsets[i3] + n12] = byArray[n7++];
                }
                ++n13;
                n12 += this.pixelStride;
            }
            ++n11;
            n6 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public void putByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(byArray, 0, this.data, n7, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(byArray, n8, this.data, n7, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    this.data[n11] = byArray[n8++];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public void putByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        if (this.numDataElements == 1) {
            n6 += this.dataOffsets[0];
            if (this.pixelStride == 1) {
                if (this.scanlineStride == n4) {
                    System.arraycopy(byArray, 0, this.data, n6, n4 * n5);
                } else {
                    for (int i2 = 0; i2 < n5; ++i2) {
                        System.arraycopy(byArray, n7, this.data, n6, n4);
                        n7 += n4;
                        n6 += this.scanlineStride;
                    }
                }
            } else {
                int n8 = 0;
                while (n8 < n5) {
                    int n9 = n6;
                    int n10 = 0;
                    while (n10 < n4) {
                        this.data[n9] = byArray[n7++];
                        ++n10;
                        n9 += this.pixelStride;
                    }
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n11 = 0;
            while (n11 < n5) {
                int n12 = n6;
                int n13 = 0;
                while (n13 < n4) {
                    for (int i3 = 0; i3 < this.numDataElements; ++i3) {
                        this.data[this.dataOffsets[i3] + n12] = byArray[n7++];
                    }
                    ++n13;
                    n12 += this.pixelStride;
                }
                ++n11;
                n6 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
        return writableRaster;
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new ByteComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new ByteComponentRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl2) {
        int n2;
        for (n2 = 0; n2 < this.dataOffsets.length; ++n2) {
            if (this.dataOffsets[n2] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + n2 + "(" + this.dataOffsets[n2] + ") must be >= 0");
        }
        n2 = 0;
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            int n3 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[i2];
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (this.data.length < n2) {
            throw new RasterFormatException("Data array too small (should be " + n2 + " )");
        }
    }

    public String toString() {
        return new String("ByteComponentRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }

    static {
        NativeLibLoader.loadLibraries();
        ByteComponentRaster.initIDs();
    }
}

